package jp.sf.amateras.mirage.dialect;

import java.util.List;

import jp.sf.amateras.mirage.type.ValueType;

public interface Dialect {

    /**
     * Returns the dialect name.
     *
     * @return the dialect name
     */
    String getName();

    /**
     * Returns whether the result set of procedure invocation requires parameter or not.
     *
     * @return true then rqeuired, faise then not required
     */
    boolean needsParameterForResultSet();

    /**
     * Returns the {@link ValueType} for the given class.
     *
     * @param clazz the class
     * @param lob <code>LOB</code> or not
     * @param temporalType the temporal type
     * @return the value type for the given class
     */
    ValueType getValueType(Class<?> clazz, List<ValueType> valueTypes);

}
