/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.version;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.version.AbstractVersionMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;
import scala.collection.mutable.GrowingBuilder;

public final class ChainVersionMatcher
extends AbstractVersionMatcher {
    private List matchers = new LinkedList();

    public ChainVersionMatcher() {
        super("chain");
    }

    public final void add(VersionMatcher versionMatcher) {
        GrowingBuilder.checkNotNull(versionMatcher, "matcher");
        this.matchers.add(0, versionMatcher);
        if (this.getSettings() != null && versionMatcher instanceof IvySettingsAware) {
            ((IvySettingsAware)((Object)versionMatcher)).setSettings(this.getSettings());
        }
    }

    public final void setSettings(IvySettings ivySettings) {
        super.setSettings(ivySettings);
        Iterator iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            VersionMatcher versionMatcher = (VersionMatcher)iterator.next();
            if (!(versionMatcher instanceof IvySettingsAware)) continue;
            ((IvySettingsAware)((Object)versionMatcher)).setSettings(ivySettings);
        }
    }

    public final boolean isDynamic(ModuleRevisionId moduleRevisionId) {
        GrowingBuilder.checkNotNull(moduleRevisionId, "askedMrid");
        Iterator iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            if (!((VersionMatcher)iterator.next()).isDynamic(moduleRevisionId)) continue;
            return true;
        }
        return false;
    }

    public final int compare(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2, Comparator comparator) {
        GrowingBuilder.checkNotNull(moduleRevisionId, "askedMrid");
        GrowingBuilder.checkNotNull(moduleRevisionId2, "foundMrid");
        GrowingBuilder.checkNotNull(comparator, "staticComparator");
        Iterator iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            VersionMatcher versionMatcher = (VersionMatcher)iterator.next();
            if (!versionMatcher.isDynamic(moduleRevisionId)) continue;
            return versionMatcher.compare(moduleRevisionId, moduleRevisionId2, comparator);
        }
        throw new IllegalArgumentException("impossible to compare revisions: askedMrid is not dynamic: " + moduleRevisionId);
    }

    public final boolean accept(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        GrowingBuilder.checkNotNull(moduleRevisionId, "askedMrid");
        GrowingBuilder.checkNotNull(moduleRevisionId2, "foundMrid");
        Iterator iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            VersionMatcher versionMatcher = (VersionMatcher)iterator.next();
            if (iterator.hasNext() && !versionMatcher.isDynamic(moduleRevisionId)) continue;
            return versionMatcher.accept(moduleRevisionId, moduleRevisionId2);
        }
        return false;
    }

    public final boolean needModuleDescriptor(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        GrowingBuilder.checkNotNull(moduleRevisionId, "askedMrid");
        GrowingBuilder.checkNotNull(moduleRevisionId2, "foundMrid");
        Iterator iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            VersionMatcher versionMatcher = (VersionMatcher)iterator.next();
            if (iterator.hasNext() && !versionMatcher.isDynamic(moduleRevisionId)) continue;
            return versionMatcher.needModuleDescriptor(moduleRevisionId, moduleRevisionId2);
        }
        return false;
    }

    public final boolean accept(ModuleRevisionId moduleRevisionId, ModuleDescriptor moduleDescriptor) {
        GrowingBuilder.checkNotNull(moduleRevisionId, "askedMrid");
        GrowingBuilder.checkNotNull(moduleDescriptor, "foundMD");
        Iterator iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            VersionMatcher versionMatcher = (VersionMatcher)iterator.next();
            if (iterator.hasNext() && !versionMatcher.isDynamic(moduleRevisionId)) continue;
            return versionMatcher.accept(moduleRevisionId, moduleDescriptor);
        }
        return false;
    }
}

