/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class FileUtil {
    private static final byte[] EMPTY_BUFFER = new byte[0];

    private FileUtil() {
    }

    public static void symlink(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        try {
            if (dest.exists()) {
                if (!dest.isFile()) {
                    throw new IOException("impossible to copy: destination is not a file: " + dest);
                }
                if (!overwrite) {
                    Message.verbose(dest + " already exists, nothing done");
                    return;
                }
            }
            if (dest.getParentFile() != null) {
                dest.getParentFile().mkdirs();
            }
            Runtime runtime = Runtime.getRuntime();
            Message.verbose("executing 'ln -s -f " + src.getAbsolutePath() + " " + dest.getPath() + "'");
            Process process2 = runtime.exec(new String[]{"ln", "-s", "-f", src.getAbsolutePath(), dest.getPath()});
            if (process2.waitFor() != 0) {
                String line;
                InputStream errorStream = process2.getErrorStream();
                InputStreamReader isr = new InputStreamReader(errorStream);
                BufferedReader br = new BufferedReader(isr);
                StringBuffer error = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    error.append(line);
                    error.append('\n');
                }
                throw new IOException("error symlinking " + src + " to " + dest + ":\n" + error);
            }
            if (!dest.exists()) {
                throw new IOException("error symlinking " + dest + " doesn't exists");
            }
        }
        catch (IOException x) {
            Message.verbose("symlink failed; falling back to copy");
            StringWriter buffer = new StringWriter();
            x.printStackTrace(new PrintWriter(buffer));
            Message.debug(buffer.toString());
            FileUtil.copy(src, dest, l, overwrite);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean copy(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        if (dest.exists()) {
            if (!dest.isFile()) {
                throw new IOException("impossible to copy: destination is not a file: " + dest);
            }
            if (overwrite) {
                if (!dest.canWrite()) {
                    dest.delete();
                }
            } else {
                Message.verbose(dest + " already exists, nothing done");
                return false;
            }
        }
        FileUtil.copy((InputStream)new FileInputStream(src), dest, l);
        long srcLen = src.length();
        long destLen = dest.length();
        if (srcLen != destLen) {
            dest.delete();
            throw new IOException("size of source file " + src.toString() + "(" + srcLen + ") differs from size of dest file " + dest.toString() + "(" + destLen + ") - please retry");
        }
        dest.setLastModified(src.lastModified());
        return true;
    }

    public static void copy(URL src, File dest, CopyProgressListener l) throws IOException {
        URLHandlerRegistry.getDefault().download(src, dest, l);
    }

    public static void copy(File src, URL dest, CopyProgressListener l) throws IOException {
        URLHandlerRegistry.getDefault().upload(src, dest, l);
    }

    public static void copy(InputStream src, File dest, CopyProgressListener l) throws IOException {
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        FileUtil.copy(src, new FileOutputStream(dest), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream src, OutputStream dest, CopyProgressListener l) throws IOException {
        CopyProgressEvent evt = null;
        if (l != null) {
            evt = new CopyProgressEvent();
        }
        try {
            int c;
            byte[] buffer = new byte[65536];
            long total = 0L;
            if (l != null) {
                l.start(evt);
            }
            while ((c = src.read(buffer)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("transfer interrupted");
                }
                dest.write(buffer, 0, c);
                total += (long)c;
                if (l == null) continue;
                l.progress(evt.update(buffer, c, total));
            }
            if (l != null) {
                evt.update(EMPTY_BUFFER, 0, total);
            }
            try {
                dest.flush();
            }
            catch (IOException ex) {
                // empty catch block
            }
            src.close();
            dest.close();
        }
        finally {
            try {
                src.close();
            }
            catch (IOException ex) {}
            try {
                dest.close();
            }
            catch (IOException ex) {}
        }
        if (l != null) {
            l.end(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntirely(BufferedReader in) throws IOException {
        try {
            StringBuffer buf = new StringBuffer();
            String line = in.readLine();
            while (line != null) {
                buf.append(line + "\n");
                line = in.readLine();
            }
            String string = buf.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public static boolean forceDelete(File file2) {
        if (!file2.exists()) {
            return true;
        }
        if (file2.isDirectory()) {
            File[] files = file2.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (FileUtil.forceDelete(files[i])) continue;
                return false;
            }
        }
        return file2.delete();
    }

    public static List getPathFiles(File root, File file2) {
        ArrayList<File> ret = new ArrayList<File>();
        while (file2 != null && !file2.getAbsolutePath().equals(root.getAbsolutePath())) {
            ret.add(file2);
            file2 = file2.getParentFile();
        }
        if (root != null) {
            ret.add(root);
        }
        Collections.reverse(ret);
        return ret;
    }

    public static Collection listAll(File dir, Collection ignore) {
        return FileUtil.listAll(dir, new ArrayList(), ignore);
    }

    private static Collection listAll(File file2, Collection list, Collection ignore) {
        if (ignore.contains(file2.getName())) {
            return list;
        }
        if (file2.exists()) {
            list.add(file2);
        }
        if (file2.isDirectory()) {
            File[] files = file2.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtil.listAll(files[i], list, ignore);
            }
        }
        return list;
    }

    public static File resolveFile(File file2, String filename) {
        File f = new File(filename);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(file2, filename);
    }
}

