/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.util.Checks;

public class ArtifactOrigin {
    private boolean isLocal;
    private String location;
    private Artifact artifact;

    public static final ArtifactOrigin unkwnown(Artifact artifact) {
        return new ArtifactOrigin(artifact, false, "UNKNOWN");
    }

    public static final boolean isUnknown(ArtifactOrigin artifact) {
        return artifact == null || "UNKNOWN".equals(artifact.getLocation());
    }

    public static final boolean isUnknown(String location) {
        return location == null || "UNKNOWN".equals(location);
    }

    public ArtifactOrigin(Artifact artifact, boolean isLocal, String location) {
        Checks.checkNotNull(artifact, "artifact");
        Checks.checkNotNull(location, "location");
        this.artifact = artifact;
        this.isLocal = isLocal;
        this.location = location;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String getLocation() {
        return this.location;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String toString() {
        return "ArtifactOrigin { isLocal=" + this.isLocal + ", location=" + this.location + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactOrigin that = (ArtifactOrigin)o;
        if (this.isLocal != that.isLocal) {
            return false;
        }
        return this.location.equals(that.location);
    }

    public int hashCode() {
        int result = this.isLocal ? 1 : 0;
        result = 31 * result + this.location.hashCode();
        return result;
    }
}

