package net.y3n20u.aeszip;

import static net.y3n20u.aeszip.CommonValues.FILE_NAME_SEPARATOR;
import static net.y3n20u.aeszip.CommonValues.METHOD_DEFLATED;
import static net.y3n20u.aeszip.CommonValues.PASSWORD_ENCODING;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;

public class AesZipBasicEncrypter {
	private static final int BUFFER_SIZE = 16384;
	
	public static int METHOD_DEFAULT = METHOD_DEFLATED;

	private File _destination;
	private FileFilter _fileFilter;
	private final HashMap<String, File> _filesToBeArchived;
	private final HashMap<String, String> _passwords;
	private boolean _inArchiving = false;
	
	public AesZipBasicEncrypter(File destination) {
		if (destination == null || destination.isDirectory()) {
			// FIXME
			throw new IllegalArgumentException();
		}
		_destination = destination;
		_filesToBeArchived = new HashMap<String, File>();
		_passwords = new HashMap<String, String>();
	}
	
	public void setFileFilter(FileFilter fileFileter) {
		_fileFilter = fileFileter;
	}

	public void add(String name, File source, String password) {
		if (_inArchiving) {
			// FIXME
			throw new IllegalStateException();
		}
		_filesToBeArchived.put(name, source);
		_passwords.put(name, password);
	}
	
	public void archive() {
		_inArchiving = true;
		AesZipOutputStream zipOutputStream = null;
		try {
			zipOutputStream = new AesZipOutputStream(new FileOutputStream(_destination));
			for (String name: _filesToBeArchived.keySet()) {
				File sourceFile = _filesToBeArchived.get(name);
				String password = _passwords.get(name);
				archiveImpl(zipOutputStream, sourceFile, name, password.getBytes(PASSWORD_ENCODING));
			}

		} catch (FileNotFoundException fnfe) {
			// FIXME
			fnfe.printStackTrace();
		} catch (UnsupportedEncodingException uee) {
			// FIXME: Auto-generated catch block
			uee.printStackTrace();
		} finally {
			try {
				if (zipOutputStream != null) {
					zipOutputStream.close();
				}
			} catch (IOException ioe) {
				// FIXME
				ioe.printStackTrace();
			}
		}
	}

	private void archiveImpl(AesZipOutputStream zipOut, File file, String name, byte[] password) {
		if (_fileFilter != null && !_fileFilter.accept(file)) {
			return;
		}
		name += (file.isDirectory() && !name.endsWith(FILE_NAME_SEPARATOR))? FILE_NAME_SEPARATOR : "";
		AesZipEntry entry = new AesZipEntry(name, password);
		entry.setActualCompressionMethod(METHOD_DEFAULT);
		entry.setTime(new Date().getTime());
		try {
			zipOut.putNextZipEntry(entry);
		} catch (IOException ioe) {
			// FIXME Auto-generated catch block
			ioe.printStackTrace();
		}

		if (file.isDirectory()) {
			return;
		}
		InputStream fileIn = null;
		try {
			fileIn = new BufferedInputStream(new FileInputStream(file));
			byte[] buf = new byte[BUFFER_SIZE];
			int size = fileIn.read(buf, 0, BUFFER_SIZE);
			while (size != -1) {
				zipOut.write(buf, 0, size);
				size = fileIn.read(buf, 0, BUFFER_SIZE);
			}
		} catch (FileNotFoundException fnfe) {
			// FIXME
			fnfe.printStackTrace();
		} catch (IOException ioe) {
			// FIXME
			ioe.printStackTrace();
		} finally {
			try {
				if (fileIn != null) {
					fileIn.close();
				}
			} catch (IOException ioe) {
				// FIXME
				ioe.printStackTrace();
			}
		}
	}
}
