package net.y3n20u.aeszip;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.File;

import org.junit.Test;

public class AesZipDecrypterTest {

	@Test
	public void testDecryptAndUncompressStringFileString() {
		String password = "password";
		
		String srcBase = "c:/temp/";
		String encFileName = "c:/temp/abctest.zip";
		String decBase = "c:/temp/decTest/";
		String suffix = "ziptest/";
		
		File source = new File(srcBase + suffix);
		File encDestination = new File(encFileName);
		File decDestination = new File(decBase);
		File resultDestination = new File(decBase + suffix);
		
		FileUtil.deleteRecursive(encDestination);
		FileUtil.deleteRecursive(resultDestination);

		try {
			new AesZipRecursiveEncrypter(source, password, encDestination).archive();
			decDestination.mkdirs();
			AesZipDecrypter zipDec = new AesZipDecrypter(encDestination);
			for (String name : zipDec.getEntryNames()) {
				zipDec.decryptAndUncompress(name, decDestination, password);
			}
			assertTrue(FileUtil.compareFilesRecursive(source, resultDestination));
		} catch (Exception e) {
			fail(e.getMessage());
		}
	}

}
