package net.y3n20u.aeszip;

import java.util.zip.Deflater;

public class CommonValues {
	
	// messages for exception
	public static final String MESSAGE_NAMELENGTH_TOOLONG = "the name of this entry is too long: {0}";
	public static final String MESSAGE_INVALID_METHOD = "the compression method is invalid: {0}";
	public static final String MESSAGE_RECORDS_TOO_MUCH = "the number of records too much: {0}";
	public static final String MESSAGE_COMMENT_LENGTH_TOOLONG = "the comment is too long: {0}";
	public static final String MESSAGE_WRITE_WHILE_NO_ENTRY = "you should put an entry before writing data.";
	public static final String MESSAGE_ALREADY_EXISTS = "[{0}] already exists.";
	
	public static final String MESSAGE_ARGUMENT_INVALID = "the value is too big or invalid: {0}";
	public static final String MESSAGE_OFFSET_INVALID = "the offset must be in [0, {1}], but the argument is {0}.";
	
	
	// common constant values
	
	/** name of algorithm used to generate authentication code */
	public static final String AUTH_MAC_ALGORITHM = "HmacSHA1";

	public static final String FILE_NAME_ENCODING = "MS932";
	
	public static final String PASSWORD_ENCODING = "UTF-8";
	
	public static final String COMMENT_ENCODING = "UTF-8";
	
	public static final String FILE_NAME_SEPARATOR = "/";
	
	/** local file header signature = 0x04034b50 */
	public static final long LOCAL_FILE_HEADER_SIG = 0x04034b50L;

	/** central directory file header signature = 0x02014b50 */
	public static final long CENTRAL_FILE_HEADER_SIG = 0x02014b50L;

	/** end of central directory signature = 0x06054b50 */
	public static final long END_OF_CENTRAL_SIG = 0x06054b50L;

	/** zip data descriptor signature = 0x08074b50 */
	public static final long DATA_DESCRIPTOR_SIG = 0x08074b50L;

	/** extra field header ID: 0x9901 */
	public static final short EXTRA_FIELD_HEADER_ID = (short) 0x9901;

	/** extra field data size: 0x0007 */
	public static final short EXTRA_FIELD_DATA_SIZE = 7;

	/** integer version number: 0x0002 (AE-2) */
	public static final short EXTRA_FIELD_VERSION_NUMBER = 2;

	/** extra field vender ID: "AE" */
	public static final short EXTRA_FIELD_VENDER_ID = 0x4541;
	
	/**
	 * constant value for actual compression method that indicates
	 * 'uncompressed'
	 */
	public static final short METHOD_STORED = 0;

	/**
	 * constant value for actual compression method that indicates 'deflated
	 * (compressed)'
	 */
	public static final short METHOD_DEFLATED = 8;

	// TODO: I do not understand the meaning of this field
	// FIXME: I may have to set 10 if the method is 'stored.'
	public static final short VERSION = 20; // 0x14

	/**
	 * constant value for compression method that indicates 'AES encrypted'. 0x63.
	 */
	public static final short METHOD_AES = 99;
	
	/**
	 * length of an extra field for an AES encrypted entry. 0x0b.
	 */
	public static final short EXTRA_FIELD_LENGTH = 11;

	// TODO: details unknown.
	public static final short FILE_START_DISK_NUMBER = 0;

	// TODO: details unknown.
	public static final short INTERNAL_FILE_ATTRIBUTE = 0;

	// TODO: details unknown.
	public static final int EXTERNAL_FILE_ATTRIBUTE = 0;

	// TODO: details unknown.
	public static final short NUMBER_OF_THIS_DISK = 0;

	// TODO: details unknown.
	public static final short CENTRAL_DIR_START_DISK_NUMBER = 0;
	
	/** iteration count for PBKDF2. */
	public static final int ITERATION_COUNT = 1000;
	
	/** length of password verification value (bytes). */
	public static final int LENGTH_PASSWORD_VERIFICATION_VALUE = 2;
	
	/** length of authentication code (bytes). */
	public static final int LENGTH_AUTHENTICATION_CODE = 10;
	
	public static final EncryptionStrengthMode  DEFAULT_ENCRYPT_STRENGTH_MODE = EncryptionStrengthMode.THREE;
	
	public static final int DEFLATER_LEVEL = Deflater.BEST_COMPRESSION;
	
	/**
	 * Used as general-purpose flag value for encrypted file entries.
	 * If sizes or crc are not known, bit 3(0x08) should be set.
	 */
	public static final short FLAG_FOR_ENCRYPTED_FILE  = 9; // 0009
	
	/**
	 * Used as general-purpose flag value for directory entries.
	 * Directories should NOT be encrypted and their sizes are 0.
	 */
	public static final short FLAG_FOR_DIRECTORY  = 0;

	public static final long MAX_FOUR_BYTE_FIELD_LONG = 0xffffffffL;
	public static final int MAX_FOUR_BYTE_FIELD_INT = 0xffffffff;
	public static final int MAX_TWO_BYTE_FIELD = 0xffff;

	public static final String ZIP_EXTENTION_WITH_PERIOD = ".zip";

}
