import java.io.File;
import java.io.FileFilter;

import net.y3n20u.aeszip.AesZipBasicEncrypter;
import net.y3n20u.aeszip.AesZipRecursiveEncrypter;

public class AesZipSample {
	
	public static void main(String[] args) {
		AesZipBasicEncrypter zip = new AesZipBasicEncrypter(new File("c:\\temp\\abc.zip"));
		zip.setFileFilter(new FileFilter() {
			@Override
			public boolean accept(File pathname) {
				return !pathname.getName().startsWith("V");
			}
			
		});
		
		System.out.println("start archive.");
		zip.add("abc", new File("c:\\temp\\abc"), "password");
		zip.add("abc/cde", new File("c:\\temp\\abc\\def"), "password");
		zip.add("abc/cde.txt", new File("c:\\temp\\abc\\cde.txt"), "password");
		zip.archive();
		System.out.println("finished.");
	}

}
