/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.y3n20u.aeszip.AesZipRuntimeException;

public class AesCtrBlockCipherOutputStream
extends FilterOutputStream {
    public static final String CIPHER_MODE_AES_CTR = "AES/CTR/NoPadding";
    public static final String KEY_ALGORITHM = "AES";
    public static final byte[] INITIAL_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int NONCE_SIZE = 8;
    private static final byte BYTE_HEX_FF = -1;
    private static final String MESSAGE_NONCE_OVERFLOW = "nonce overflow (it must not occur).";
    private Cipher cipher;
    private Key encryptKey;
    private final byte[] iv = new byte[16];
    private final byte[] restBytes = new byte[16];
    private int restBytesLength;
    private final int mode;

    public static AesCtrBlockCipherOutputStream generateEncryptInstance(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException();
        }
        return new AesCtrBlockCipherOutputStream(outputStream, 1);
    }

    public static AesCtrBlockCipherOutputStream generateDecryptInstance(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException();
        }
        return new AesCtrBlockCipherOutputStream(outputStream, 2);
    }

    private AesCtrBlockCipherOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        if (2 != n && 1 != n) {
            throw new IllegalArgumentException();
        }
        this.mode = n;
        try {
            this.cipher = Cipher.getInstance(CIPHER_MODE_AES_CTR);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AesZipRuntimeException(noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new AesZipRuntimeException(noSuchPaddingException);
        }
    }

    public void init(byte[] byArray) {
        System.arraycopy(INITIAL_IV, 0, this.iv, 0, 16);
        this.encryptKey = new SecretKeySpec(byArray, KEY_ALGORITHM);
        this.restBytesLength = 0;
    }

    private void initIvAndCipher() {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv);
        try {
            this.cipher.init(this.mode, this.encryptKey, ivParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AesZipRuntimeException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new AesZipRuntimeException(invalidAlgorithmParameterException);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.restBytesLength > 0) {
            n3 = 16 - this.restBytesLength;
            if (n2 < n3) {
                System.arraycopy(byArray, n, this.restBytes, this.restBytesLength, n2);
                this.restBytesLength += n2;
                return;
            }
            byte[] byArray2 = new byte[16];
            System.arraycopy(this.restBytes, 0, byArray2, 0, this.restBytesLength);
            System.arraycopy(byArray, n, byArray2, this.restBytesLength, n3);
            this.encryptAndWriteBlock(byArray2, 0, 16);
            n += n3;
            n2 -= n3;
            this.restBytesLength = 0;
        }
        n3 = n;
        while (n3 + 16 <= n + n2) {
            this.encryptAndWriteBlock(byArray, n3, 16);
            n3 += 16;
        }
        int n4 = n + n2 - n3;
        if (n4 > 0) {
            this.restBytesLength = n4;
            System.arraycopy(byArray, n3, this.restBytes, 0, n4);
        }
    }

    private void encryptAndWriteBlock(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.incrementIv();
            this.initIvAndCipher();
            byte[] byArray2 = this.cipher.doFinal(byArray, n, n2);
            this.out.write(byArray2, 0, byArray2.length);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new AesZipRuntimeException(illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new AesZipRuntimeException(badPaddingException);
        }
    }

    private void incrementIv() {
        for (int i = 0; i < 8; ++i) {
            if (this.iv[i] != -1) {
                int n = i;
                this.iv[n] = (byte)(this.iv[n] + 1);
                return;
            }
            this.iv[i] = 0;
        }
        throw new AesZipRuntimeException(MESSAGE_NONCE_OVERFLOW);
    }

    @Override
    public void flush() throws IOException {
        if (this.restBytesLength > 0) {
            this.encryptAndWriteBlock(this.restBytes, 0, this.restBytesLength);
            this.restBytesLength = 0;
        }
        this.out.flush();
    }
}

