/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import java.util.zip.ZipException;
import net.y3n20u.aeszip.AesCtrBlockCipherOutputStream;
import net.y3n20u.aeszip.AesZipEntry;
import net.y3n20u.aeszip.AesZipRuntimeException;
import net.y3n20u.aeszip.ArchiveProgressListener;
import net.y3n20u.aeszip.ArchiveProgressStatus;
import net.y3n20u.aeszip.EncryptionStrengthMode;
import net.y3n20u.aeszip.InvalidFieldException;
import net.y3n20u.aeszip.InvalidMethodException;
import net.y3n20u.aeszip.MacFilterOutputStream;
import net.y3n20u.aeszip.PasswordNotCorrectException;
import net.y3n20u.util.ByteHelper;

public class AesZipDecrypter {
    private static final String FILE_ACCESS_MODE = "r";
    private static final long OFFSET_NUMBER_OF_CENTRAL_DIR = 8L;
    private static final byte[] END_OF_CENTRAL_DIR_SIG = new byte[]{80, 75, 5, 6};
    private static final byte[] CENTRAL_DIR_FILE_HEADER_SIG = new byte[]{80, 75, 1, 2};
    private static final byte[] AES_EXTRA_FIELD_HEADER_AND_SIZE = new byte[]{1, -103, 7, 0};
    private static final byte[] AES_EXTRA_FIELD_VERSION_AE1 = new byte[]{1, 0};
    private static final byte[] AES_EXTRA_FIELD_VERSION_AE2 = new byte[]{2, 0};
    private static final byte[] AES_EXTRA_FIELD_VENDER_ID = new byte[]{65, 69};
    private static final byte[] AES_ALLOWED_ENCRYPTION_STRENGTH = new byte[]{1, 2, 3};
    private static final int LENGTH_EXTRA_FIELD = 11;
    private static final int ENCRYPTED_FLAG = 1;
    private static final int[] ALLOWED_ACTUAL_METHODS = new int[]{0, 8};
    private static final long LENGTH_LOCAL_FILE_HEADER_SKIP = 26L;
    private final Map<String, AesZipEntry> nameToEntryMap;
    private final RandomAccessFile sourceFile;
    private final byte[] comment;
    private Charset fileNameCharset;
    private Charset commentCharset;
    private Charset passwordCharset;
    private final byte[] decryptionBlock = new byte[16];
    private ArchiveProgressListener progressListener;
    private ArchiveProgressStatus previousStatus;

    public AesZipDecrypter(File file) throws ZipException, IOException {
        long l;
        if (file == null || file.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.sourceFile = new RandomAccessFile(file, FILE_ACCESS_MODE);
        this.fileNameCharset = Charset.defaultCharset();
        this.commentCharset = Charset.defaultCharset();
        this.passwordCharset = Charset.defaultCharset();
        this.nameToEntryMap = new HashMap<String, AesZipEntry>();
        long l2 = this.getEndOfCentralDir();
        this.sourceFile.seek(l2 + 8L);
        int n = this.readTwoBytesAndGetInt();
        int n2 = this.readTwoBytesAndGetInt();
        if (n != n2) {
            throw new IllegalArgumentException();
        }
        long l3 = this.readFourBytesAndGetLong();
        if (l3 + (l = this.readFourBytesAndGetLong()) != l2) {
            throw new IllegalArgumentException();
        }
        int n3 = this.readTwoBytesAndGetInt();
        this.comment = new byte[n3];
        this.sourceFile.read(this.comment);
        this.sourceFile.seek(l);
        for (int i = 0; i < n2; ++i) {
            AesZipEntry aesZipEntry = this.getEntryFromCentralDir();
            this.nameToEntryMap.put(aesZipEntry.getName(), aesZipEntry);
        }
        if (this.sourceFile.getFilePointer() != l2) {
            throw new IllegalArgumentException();
        }
    }

    private AesZipEntry getEntryFromCentralDir() throws IOException {
        AesZipEntry aesZipEntry;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[2];
        this.sourceFile.read(byArray);
        if (!Arrays.equals(byArray, CENTRAL_DIR_FILE_HEADER_SIG)) {
            throw new IllegalArgumentException();
        }
        this.sourceFile.read(byArray);
        this.sourceFile.read(byArray2);
        int n = ByteHelper.getInt(byArray2);
        this.sourceFile.read(byArray2);
        int n2 = ByteHelper.getInt(byArray2);
        this.sourceFile.read(byArray2);
        int n3 = ByteHelper.getInt(byArray2);
        this.sourceFile.read(byArray2);
        int n4 = ByteHelper.getInt(byArray2);
        this.sourceFile.read(byArray);
        long l = ByteHelper.getLong(byArray);
        this.sourceFile.read(byArray);
        long l2 = ByteHelper.getLong(byArray);
        this.sourceFile.read(byArray);
        long l3 = ByteHelper.getLong(byArray);
        this.sourceFile.read(byArray2);
        int n5 = ByteHelper.getInt(byArray2);
        this.sourceFile.read(byArray2);
        int n6 = ByteHelper.getInt(byArray2);
        this.sourceFile.read(byArray2);
        int n7 = ByteHelper.getInt(byArray2);
        this.sourceFile.read(byArray2);
        this.sourceFile.read(byArray2);
        this.sourceFile.read(byArray);
        this.sourceFile.read(byArray);
        long l4 = ByteHelper.getLong(byArray);
        byte[] byArray3 = new byte[n5];
        this.sourceFile.read(byArray3);
        byte[] byArray4 = new byte[n6];
        this.sourceFile.read(byArray4);
        byte[] byArray5 = new byte[n7];
        this.sourceFile.read(byArray5);
        if (AesZipDecrypter.isAesEncrypted(n, n2)) {
            AesZipDecrypter.checkAesExtraField(byArray4);
            EncryptionStrengthMode encryptionStrengthMode = AesZipDecrypter.getEncryptionStrengthMode(byArray4[8]);
            aesZipEntry = new AesZipEntry(new String(byArray3, this.getFileNameCharset()), encryptionStrengthMode);
            int n8 = ByteHelper.getInt(byArray4[9], byArray4[10]);
            aesZipEntry.setActualCompressionMethod(n8);
        } else {
            aesZipEntry = new AesZipEntry(new String(byArray3, this.getFileNameCharset()));
        }
        aesZipEntry.setCompressedSize(l2);
        aesZipEntry.setSize(l3);
        aesZipEntry.setMethod(n2);
        aesZipEntry.setCrc(l);
        aesZipEntry.setComment(new String(byArray5, this.getCommentCharset()));
        aesZipEntry.setExtra(byArray4);
        aesZipEntry.setRelativeOffsetOfLocalFileHeader(l4);
        return aesZipEntry;
    }

    private static boolean isAesEncrypted(int n, int n2) {
        if ((n & 1) == 0) {
            return false;
        }
        return n2 == 99;
    }

    private static EncryptionStrengthMode getEncryptionStrengthMode(byte by) {
        switch (by) {
            case 1: {
                return EncryptionStrengthMode.ONE;
            }
            case 2: {
                return EncryptionStrengthMode.TWO;
            }
            case 3: {
                return EncryptionStrengthMode.THREE;
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     */
    private static void checkAesExtraField(byte[] byArray) {
        void var5_9;
        int n;
        if (byArray.length != 11) {
            throw new InvalidFieldException();
        }
        for (n = 0; n < 4; ++n) {
            if (byArray[n] == AES_EXTRA_FIELD_HEADER_AND_SIZE[n]) continue;
            throw new InvalidFieldException();
        }
        if (byArray[4] != AES_EXTRA_FIELD_VERSION_AE1[0] && byArray[5] != AES_EXTRA_FIELD_VERSION_AE1[1] || byArray[4] != AES_EXTRA_FIELD_VERSION_AE2[0] && byArray[5] != AES_EXTRA_FIELD_VERSION_AE2[1]) {
            throw new InvalidFieldException();
        }
        if (byArray[6] != AES_EXTRA_FIELD_VENDER_ID[0] && byArray[7] != AES_EXTRA_FIELD_VENDER_ID[1]) {
            throw new InvalidFieldException();
        }
        n = 1;
        for (byte n2 : AES_ALLOWED_ENCRYPTION_STRENGTH) {
            if (byArray[8] != n2) continue;
            n = 0;
            break;
        }
        if (n != 0) {
            throw new InvalidFieldException();
        }
        int n3 = ByteHelper.getInt(byArray[9], byArray[10]);
        int[] nArray = ALLOWED_ACTUAL_METHODS;
        int n2 = nArray.length;
        boolean bl = false;
        while (var5_9 < n2) {
            int n4 = nArray[var5_9];
            if (n4 == n3) {
                return;
            }
            ++var5_9;
        }
        throw new InvalidFieldException();
    }

    private long getEndOfCentralDir() throws IOException {
        byte[] byArray = new byte[4];
        for (long i = this.sourceFile.length() - 4L; i > 76L; --i) {
            this.sourceFile.seek(i);
            this.sourceFile.read(byArray);
            if (byArray[0] != END_OF_CENTRAL_DIR_SIG[0] || byArray[1] != END_OF_CENTRAL_DIR_SIG[1] || byArray[2] != END_OF_CENTRAL_DIR_SIG[2] || byArray[3] != END_OF_CENTRAL_DIR_SIG[3]) continue;
            return i;
        }
        throw new AesZipRuntimeException();
    }

    public Set<String> getEntryNames() {
        return Collections.unmodifiableSet(this.nameToEntryMap.keySet());
    }

    public AesZipEntry getEntry(String string) {
        return this.nameToEntryMap.get(string);
    }

    public void decryptAndExtractAllFiles(File file, String string) throws IOException, PasswordNotCorrectException {
        String[] stringArray = this.getEntryNames().toArray(new String[this.nameToEntryMap.size()]);
        this.decryptAndExtractFiles(stringArray, file, string);
    }

    public void decryptAndExtractFiles(String[] stringArray, File file, String string) throws IOException, PasswordNotCorrectException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException();
        }
        if (this.progressListener != null) {
            this.progressListener.start();
            long l = 0L;
            for (String object : stringArray) {
                l += this.nameToEntryMap.get(object).getContentCompressedSize();
            }
            this.previousStatus = new ArchiveProgressStatus(stringArray.length, 0, l, 0L, -1L, 0L);
        }
        for (String string2 : stringArray) {
            FileOutputStream fileOutputStream;
            AesZipEntry aesZipEntry = this.nameToEntryMap.get(string2);
            File file2 = new File(file, string2);
            if (this.progressListener != null) {
                long l = aesZipEntry.getContentCompressedSize();
                this.previousStatus = this.previousStatus.generateUpdatedStatusWithNextEntry(l, string2, file2.getCanonicalPath());
                this.progressListener.notifyStatus(this.previousStatus);
            }
            if (aesZipEntry.isDirectory()) {
                file2.mkdirs();
                continue;
            }
            this.prepare(aesZipEntry, string);
            if (!file.exists()) {
                file.mkdirs();
            }
            file2.getParentFile().mkdirs();
            try {
                fileOutputStream = new FileOutputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException(fileNotFoundException);
            }
            this.decryptAndExtractImpl(aesZipEntry, fileOutputStream);
        }
        if (this.progressListener != null) {
            this.progressListener.finishedAll();
        }
    }

    public void decryptAndExtract(String string, File file, String string2) throws IOException, PasswordNotCorrectException {
        FileOutputStream fileOutputStream;
        this.checkEntryName(string);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException();
        }
        AesZipEntry aesZipEntry = this.nameToEntryMap.get(string);
        if (this.progressListener != null) {
            this.progressListener.start();
            long l = aesZipEntry.getContentCompressedSize();
            this.previousStatus = new ArchiveProgressStatus(1, 0, l, 0L, -1L, 0L);
        }
        File file2 = new File(file, string);
        if (aesZipEntry.isDirectory()) {
            file2.mkdirs();
            return;
        }
        this.prepare(aesZipEntry, string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        file2.getParentFile().mkdirs();
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException(fileNotFoundException);
        }
        this.decryptAndExtractImpl(aesZipEntry, fileOutputStream);
        if (this.progressListener != null) {
            this.progressListener.finishedAll();
        }
    }

    public void decryptAndExtract(String string, OutputStream outputStream, String string2) throws IOException, PasswordNotCorrectException {
        this.checkEntryName(string);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if (outputStream == null) {
            throw new IllegalArgumentException();
        }
        AesZipEntry aesZipEntry = this.nameToEntryMap.get(string);
        if (this.progressListener != null) {
            this.progressListener.start();
            long l = aesZipEntry.getContentCompressedSize();
            this.previousStatus = new ArchiveProgressStatus(1, 0, l, 0L, -1L, 0L);
        }
        if (aesZipEntry.isDirectory()) {
            return;
        }
        this.prepare(aesZipEntry, string2);
        this.decryptAndExtractImpl(aesZipEntry, outputStream);
        if (this.progressListener != null) {
            this.progressListener.finishedAll();
        }
    }

    private void decryptAndExtractImpl(AesZipEntry aesZipEntry, OutputStream outputStream) throws IOException {
        OutputStream outputStream2;
        short s = aesZipEntry.getActualCompressionMethod();
        switch (s) {
            case 8: {
                outputStream2 = new InflaterOutputStream(outputStream, new Inflater(true));
                break;
            }
            case 0: {
                outputStream2 = outputStream;
                break;
            }
            default: {
                throw new InvalidMethodException(s);
            }
        }
        AesCtrBlockCipherOutputStream aesCtrBlockCipherOutputStream = AesCtrBlockCipherOutputStream.generateDecryptInstance(outputStream2);
        MacFilterOutputStream macFilterOutputStream = new MacFilterOutputStream(aesCtrBlockCipherOutputStream);
        aesCtrBlockCipherOutputStream.init(aesZipEntry.getEncryptionKey());
        macFilterOutputStream.init(aesZipEntry.getAuthenticationKey());
        long l = aesZipEntry.getContentCompressedSize();
        int n = 16;
        while ((long)n < l) {
            this.sourceFile.read(this.decryptionBlock, 0, 16);
            macFilterOutputStream.write(this.decryptionBlock);
            this.updateProgress(this.decryptionBlock.length);
            n += 16;
        }
        int n2 = (int)(l - (long)n) + 16;
        if (n2 > 1) {
            this.sourceFile.read(this.decryptionBlock, 0, n2);
            macFilterOutputStream.write(this.decryptionBlock, 0, n2);
            this.updateProgress(n2);
        }
        byte[] byArray = new byte[10];
        this.sourceFile.read(byArray, 0, 10);
        aesCtrBlockCipherOutputStream.flush();
        outputStream.close();
        outputStream2.close();
        aesCtrBlockCipherOutputStream.close();
        macFilterOutputStream.close();
        byte[] byArray2 = macFilterOutputStream.getAuthenticationCode();
        if (!Arrays.equals(byArray, byArray2)) {
            throw new AesZipRuntimeException(MessageFormat.format("MAC value not match for [{0}]", aesZipEntry.getName()));
        }
    }

    private void prepare(AesZipEntry aesZipEntry, String string) throws IOException, PasswordNotCorrectException {
        this.sourceFile.seek(aesZipEntry.getRelativeOffsetOfLocalFileHeader() + 26L);
        int n = this.readTwoBytesAndGetInt();
        int n2 = this.readTwoBytesAndGetInt();
        this.sourceFile.skipBytes(n + n2);
        EncryptionStrengthMode encryptionStrengthMode = aesZipEntry.getStrengthMode();
        int n3 = encryptionStrengthMode.getSaltLength();
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[2];
        this.sourceFile.read(byArray, 0, n3);
        this.sourceFile.read(byArray2, 0, 2);
        aesZipEntry.deriveKeys(string.getBytes(this.getPasswordCharset()), byArray, byArray2);
    }

    public void setPasswordCharset(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
        this.passwordCharset = charset;
    }

    private Charset getPasswordCharset() {
        return this.passwordCharset;
    }

    public void setFileNameCharset(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
        this.fileNameCharset = charset;
    }

    private Charset getFileNameCharset() {
        return this.fileNameCharset;
    }

    public void setCommentCharset(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
        this.commentCharset = charset;
    }

    private Charset getCommentCharset() {
        return this.commentCharset;
    }

    private void checkEntryName(String string) {
        if (string == null || !this.nameToEntryMap.containsKey(string)) {
            throw new IllegalArgumentException(new NullPointerException());
        }
    }

    public void setProgressListener(ArchiveProgressListener archiveProgressListener) {
        this.progressListener = archiveProgressListener;
    }

    private void updateProgress(long l) {
        if (this.progressListener != null) {
            this.previousStatus = this.previousStatus.generateUpdatedStatus(l);
            this.progressListener.notifyStatus(this.previousStatus);
        }
    }

    private int readTwoBytesAndGetInt() throws IOException {
        byte[] byArray = new byte[2];
        this.sourceFile.read(byArray);
        return ByteHelper.getInt(byArray);
    }

    private long readFourBytesAndGetLong() throws IOException {
        byte[] byArray = new byte[4];
        this.sourceFile.read(byArray);
        return ByteHelper.getLong(byArray);
    }
}

