package jp.sourceforge.acerola3d.apng;

import java.io.*;
import java.awt.image.*;
import java.util.zip.*;

class Frame {
    APNGImageReader apng;

    int width;
    int height;
    int x_offset;
    int y_offset;
    short delay_num;
    short delay_den;
    byte dispose_op;
    byte blend_op;
    BufferedImage image;

ByteArrayOutputStream tmpData = new ByteArrayOutputStream();

    public Frame(APNGImageReader apng,Chunk c,int seq) throws IOException {
        this.apng = apng;

        if (c==null) {
            width = apng.width;
            height = apng.height;
        } else {
            DataInputStream dis = c.getDataInputStream();
            int dSeq = dis.readInt();
            if (seq!=dSeq)
                System.out.println("ERROR!: seq!=dSeq: "+seq+","+dSeq);
            width = dis.readInt();
            height = dis.readInt();
            x_offset = dis.readInt();
            y_offset = dis.readInt();
            delay_num = dis.readShort();
            delay_den = dis.readShort();
            dispose_op = dis.readByte();
            blend_op = dis.readByte();
        }
    }

    public String toString() {
        String ret = "";
        ret = ret + "Frame:\n";
        ret = ret + "  width="+width+"\n";
        ret = ret + "  height="+height+"\n";
        ret = ret + "  x_offset="+x_offset+"\n";
        ret = ret + "  y_offset="+y_offset+"\n";
        ret = ret + "  delay_num="+delay_num+"\n";
        ret = ret + "  delay_den="+delay_den+"\n";
        ret = ret + "  dispose_op="+dispose_op+"\n";
        ret = ret + "  blend_op="+blend_op+"\n";
        return ret;
    }

    void addChunk(Chunk c,int seq) {
        if (c.typeStr.equals("IDAT")) {
            tmpData.write(c.data,0,c.data.length);
        } else if (c.typeStr.equals("fdAT")) {
            int dSeq = 0;
            dSeq = dSeq | 0xff & c.data[0]; dSeq = dSeq<<8;
            dSeq = dSeq | 0xff & c.data[1]; dSeq = dSeq<<8;
            dSeq = dSeq | 0xff & c.data[2]; dSeq = dSeq<<8;
            dSeq = dSeq | 0xff & c.data[3];
            if (seq!=dSeq)
                System.out.println("ERROR!: seq!=dSeq: "+seq+","+dSeq);
            tmpData.write(c.data,4,c.data.length-4);
        }
    }

    void createImage() throws DataFormatException {
        byte[] bs = tmpData.toByteArray();
        Inflater inflater = new Inflater();
        inflater.setInput(bs);
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (true) {
            int size = inflater.inflate(buffer);
            baos.write(buffer,0,size);
            if (inflater.finished())
                break;
        }
        inflater.end();
        bs = baos.toByteArray();

        //bppは1ピクセルのバイト数
        int bpp=1;//???
        switch (apng.colorType) {
        case 0: bpp = apng.bitDepth>8?2:1; break;
        //case 1: break;
        case 2: bpp = apng.bitDepth>8?6:3; break;
        case 3: bpp = 1; break;
        case 4: bpp = apng.bitDepth>8?4:2; break;
        //case 5: break;
        case 6: bpp = apng.bitDepth>8?8:4; break;
        }

        //フィルターの処理
        int ft = 0;
        for (int idx=0;idx<bs.length;idx++) {
            if ((idx % (1+bpp*width))==0) {
                ft = bs[idx];
                continue;
            }
            int x = ((idx % (1+bpp*width))-1)/bpp;
            int y = idx / (1+bpp*width);
            //m(自分)，w(左)，n(上)，nw(左上)
            int m=0xff & bs[idx];
            int w=0,n=0,nw=0;
            if (x!=0) w=0xff & bs[idx-bpp];
            if (y!=0) n=0xff & bs[idx-(1+bpp*width)];
            if (x!=0 && y!=0) nw=0xff & bs[idx-bpp-(1+bpp*width)];
            switch(ft) {
            case 0: bs[idx] = (byte)filter0(m,w,n,nw); break;
            case 1: bs[idx] = (byte)filter1(m,w,n,nw); break;
            case 2: bs[idx] = (byte)filter2(m,w,n,nw); break;
            case 3: bs[idx] = (byte)filter3(m,w,n,nw); break;
            case 4: bs[idx] = (byte)filter4(m,w,n,nw); break;
            }
        }

        //BufferedImage bi = new BufferedImage(width,height,BufferedImage.TYPE_4BYTE_ABGR);
        BufferedImage bi = new BufferedImage(width,height,BufferedImage.TYPE_INT_ARGB);

        if (apng.colorType==0) {
            //グレースケール
            //TODO
        } else if (apng.colorType==2) {
            //RGBカラー、パレット無し
            //TODO
        } else if (apng.colorType==3) {
            //インデックスカラー、パレット有り
            for (int x=0;x<width;x++) {
                for (int y=0;y<height;y++) {
                    byte idx = bs[1+bpp*x+(1+bpp*width)*y];
                    byte alp = (byte)0xff;
                    if (apng.alpha!=null) {
                        Integer a = apng.alpha.get((int)idx);
                        if (a!=null)
                            alp = (byte)(a.intValue());
                    }
                    byte[] rgb = apng.palette[0xFF & idx];
                    int argb = 0;
                    argb = argb | 0xff & alp   ; argb = argb<<8;
                    argb = argb | 0xff & rgb[0]; argb = argb<<8;
                    argb = argb | 0xff & rgb[1]; argb = argb<<8;
                    argb = argb | 0xff & rgb[2];
                    bi.setRGB(x,y,argb);
                }
            }
        } else if (apng.colorType==4) {
            //グレースケール、アルファチャネル有り
            //TODO
        } else if (apng.colorType==6) {
            //RGBカラー、アルファチャネル有り、パレット無し
            for (int x=0;x<width;x++) {
                for (int y=0;y<height;y++) {
                    byte r = bs[1+4*x+(1+bpp*width)*y+0];
                    byte g = bs[1+4*x+(1+bpp*width)*y+1];
                    byte b = bs[1+4*x+(1+bpp*width)*y+2];
                    byte a = bs[1+4*x+(1+bpp*width)*y+3];
                    int argb = 0;
                    argb = argb | 0xff & a; argb = argb<<8;
                    argb = argb | 0xff & r; argb = argb<<8;
                    argb = argb | 0xff & g; argb = argb<<8;
                    argb = argb | 0xff & b;
                    bi.setRGB(x,y,argb);
                }
            }
        }

        tmpData.reset();
        image = bi;
    }

    int filter0(int m,int w,int n,int nw) {
        return m;
    }
    int filter1(int m,int w,int n,int nw) {
        return m+w;
    }
    int filter2(int m,int w,int n,int nw) {
        return m+n;
    }
    int filter3(int m,int w,int n,int nw) {
        //return m+(int)(Math.floor((w+n)/2.0));
        return m+(w+n)/2;
    }
    int filter4(int m,int w,int n,int nw) {
        return m+paethPredictor(w,n,nw);
    }

    //http://web.archive.org/web/20050305152509/http://tech.millto.net/~pngnews/kndh/PngSpec1.2/PNG-Filters.html
    int paethPredictor(int a,int b,int c) {
        int p = a+b-c;
        int pa = Math.abs(p-a);
        int pb = Math.abs(p-b);
        int pc = Math.abs(p-c);
        if (pa<=pb && pa<=pc) return a;
        else if (pb<=pc) return b;
        else return c;
    }

    public BufferedImage getImage() {
        return image;
    }
}
