package jp.sourceforge.acerola3d.apng;

import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import java.util.Locale;
import java.io.IOException;

public class APNGImageReaderSpi extends ImageReaderSpi {
    static final String vendorName = "Kenji Saito";
    static final String version = "0.01-20130703";
    static final String[] names = { "apng" };
    static final String[] suffixes = { "apng" };
    static final String[] MIMETypes = { "image/apng" };
    static final String readerClassName =
            "jp.sourceforge.acerola3d.apng.APNGImageReader";
    static final Class<?>[] inputTypes = { ImageInputStream.class };
    static final String[] writerSpiNames = null;//???

    // Metadata formats, more information below
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName = null;
    static final String nativeStreamMetadataFormatClassName = null;
    static final String[] extraStreamMetadataFormatNames = null;
    static final String[] extraStreamMetadataFormatClassNames = null;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName =
            APNGMetadata.nativeMetadataFormatName;
    static final String nativeImageMetadataFormatClassName =
            "jp.sourceforge.acerola3d.apng.APNGMetadata";
    static final String[] extraImageMetadataFormatNames = null;
    static final String[] extraImageMetadataFormatClassNames = null;

    public APNGImageReaderSpi() {
        super(vendorName, version,
              names, suffixes, MIMETypes,
              readerClassName,
              inputTypes,
              writerSpiNames,
              supportsStandardStreamMetadataFormat,
              nativeStreamMetadataFormatName,
              nativeStreamMetadataFormatClassName,
              extraStreamMetadataFormatNames,
              extraStreamMetadataFormatClassNames,
              supportsStandardImageMetadataFormat,
              nativeImageMetadataFormatName,
              nativeImageMetadataFormatClassName,
              extraImageMetadataFormatNames,
              extraImageMetadataFormatClassNames);
    }

    @Override
    public String getDescription(Locale locale) {
        return "APNG(Animated Portable Network Graphics) decoder.";
    }

    @Override
    public boolean canDecodeInput(Object input) throws IOException {
        if (!(input instanceof ImageInputStream)) {
            return false;
        }

        ImageInputStream stream = (ImageInputStream)input;
        byte[] b = new byte[8];
        stream.mark();
        stream.readFully(b);
        stream.reset();

        for (int i=0;i<APNGImageReader.pngSignature.length;i++)
            if (b[i]!=APNGImageReader.pngSignature[i])
                return false;
        return true;
    }

    @Override
    public ImageReader createReaderInstance(Object extension) {
        return new APNGImageReader(this);
    }
}
