import javax.swing.*;
import javax.imageio.*;
import javax.imageio.stream.ImageInputStream;
import java.util.Iterator;
import java.io.InputStream;
import java.awt.Color;
import java.awt.FlowLayout;

public class Test {
    public static void main(String args[]) throws Exception {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("apng");
        if (!readers.hasNext()) {
            System.out.println("No Reader!!!");
            return;
        }
        ImageReader reader = readers.next();

        InputStream is = Test.class.getResourceAsStream("/apng_test.apng");
        ImageInputStream iis = ImageIO.createImageInputStream(is);
        //reader.setInput(iis,true);//こっちはダメ？
        reader.setInput(iis,false);

        int n = reader.getNumImages(true);
        System.out.println("getNumImages="+n);

        JFrame frame = new JFrame("APNG_TEST");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.getContentPane().setBackground(new Color(0,100,0));
        frame.setLayout(new FlowLayout());
        for (int i=0;i<n;i++) {
            ImageIcon ii = new ImageIcon(reader.read(i));
            JLabel l = new JLabel(ii);
            frame.add(l);
        }
        frame.setSize(800,500);
        frame.setVisible(true);
    }
}
