package jp.sourceforge.acerola3d.a3panels;

import java.awt.*;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.*;

public class ImagePanel extends JPanel {
    private static final long serialVersionUID = 1L;
    JLabel imageLabel;
    public ImagePanel(String urlString) {
        setLayout(new BorderLayout());
        imageLabel = new JLabel();
        JScrollPane scrolPane = new JScrollPane(imageLabel);
        add(scrolPane,BorderLayout.CENTER);
        if (urlString!=null) {
            ImageIcon ii = new ImageIcon(urlString);
            imageLabel.setIcon(ii);
        }
    }
    public void loadImage(URL url) {
        ImageIcon ii = new ImageIcon(url);
        imageLabel.setIcon(ii);
    }
    public void loadImage(String urlString) {
        try {
            loadImage(new URL(urlString));
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
    public void loadImage(File f) {
        try {
            loadImage(f.toURI().toURL());
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}
