package jp.sourceforge.acerola3d.a3editor;

import java.io.*;
import java.nio.channels.FileChannel;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.swing.*;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.sound.A3SoundSystem;

public class A3Editor {
    static ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    static A3SoundSystem soundSystem;
    A3EditorGUI gui;
    A3eFileManager fileManager = null;
    Catalog catalog = null;
    A3eActionEditor actionEditor = null;
    public A3Editor(String args[]) {
        A23.initA23();
        File f = null;
        if (args.length==0) {
            JOptionPane.showMessageDialog(null,"作業用ディレクトリを選択して下さい。");
            JFileChooser fc = new JFileChooser(".");
            fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            int returnVal = fc.showOpenDialog(null);
            if (returnVal != JFileChooser.APPROVE_OPTION) {
                return;
            }
            f = fc.getSelectedFile();
        } else if (args.length==1){
            f = new File(args[0]);
        } else if (args.length==2 && args[0].equals("-open")) {
            f = new File(args[1]);
        }
        setWorkingDir(f);
        gui = new A3EditorGUI(this);
        soundSystem = A3SoundSystem.getDefaultSoundSystem();//gaha
    }
    public static void main(String args[]) {
        new A3Editor(args);
    }
    public void setWorkingDir(File f) {
        try {
            fileManager = new A3eFileManager(f);
        } catch (IOException e) {
            fileManager = null;
            e.printStackTrace();
            int ret = JOptionPane.showConfirmDialog(gui,
                    "作業用ディレクトリの読み込みに失敗しました。もう一度選択しますか?");
            if (ret==JOptionPane.NO_OPTION) {
                return;
            } else {
                JFileChooser fc = new JFileChooser(".");
                fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
                int returnVal = fc.showOpenDialog(null);
                if (returnVal != JFileChooser.APPROVE_OPTION) {
                    return;
                }
                f = fc.getSelectedFile();
                setWorkingDir(f);
                return;
            }
        }
        A3eFile file = null;
        try {
            file = fileManager.listA3eFile(A3eFileType.CATALOG)[0];
            catalog = new Catalog(file.toFile(),fileManager);
            catalogBackup();
        } catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(gui,
                    "CATALOG.XMLファイルの読み込みに失敗しました。バックアップして新規作成します。", 
                    "ERROR",JOptionPane.ERROR_MESSAGE);
            try {
                catalogBackup();
                catalog = new Catalog(fileManager);
                catalog.file = file.toFile();
                catalog.save();
            } catch(Exception ee) {
                ee.printStackTrace();;
            }
        }
        actionEditor = new A3eActionEditor(this);
    }

    void catalogBackup() throws IOException {
        A3eFile orgA3eFile = fileManager.listA3eFile(A3eFileType.CATALOG)[0];
        File orgFile = orgA3eFile.toFile();
        File bakFile = new File(orgFile.getParentFile(),orgFile.getName()+".bak");
        FileInputStream fis = new FileInputStream(orgFile);
        FileOutputStream fos = new FileOutputStream(bakFile);
        FileChannel orgChannel = fis.getChannel();
        FileChannel bakChannel = fos.getChannel();
        try {
            orgChannel.transferTo(0, orgChannel.size(), bakChannel);
        } finally {
            orgChannel.close();
            bakChannel.close();
        }
    }
}
