title: アクションの編集

[ヘルプTop](./help.html)

アクションの編集
========================================

![actionEditor.gif](../images/actionEditor.gif)

はじめに
----------------------------------------

このタブではAcerola3Dファイルに含めるための
複数のアクションを編集します．実のところこの
アクションの編集がこのA3Editorのメインの機能になっています．

ここでの作業を始める前にAcerola3Dフォーマットの
ファイルの構成がどのようになっているか，Acerola3D
のサンプルを表示して確認したり，Acerola3Dフォーマット
のチュートリアルを参照して確認しておくことをお勧めします．

* [Acerola3Dフォーマットのサンプル](http://acerola3d.sourceforge.jp/samples/)
* [テキストエディタでAcerola3Dファイルを作る(チュートリアル1)](http://acerola3d.sourceforge.jp/docs/format/tutorial1/)

複数のアクションの用意
----------------------------------------

まず，Acerola3Dフォーマットのファイルには複数のアクションを
含めることができ，このアクション自信の編集を画面左上の
「アクション」という枠でかこってある部分で行います．

* アクション名リストボックス
    + 複数のアクションがある場合に，そのアクションを
      切り替えます．編集したいアクション名を選択して下さい．
* 「このアクションを削除」ボタン
    + 現在表示しているアクションを削除するためのボタンです．
* 「アクション名の変更」ボタン
    + 現在表示しているアクションのアクション名を変更
      するためのボタンです．
* 「新しいアクションを追加」ボタン
    + 新しいアクションを追加するためのボタンです．

「新しいアクションを追加」ボタンについて，もうすこし詳しく
説明します．「新しいアクションを追加」ボタンを押すと以下の
ようなダイアログボックスが表示されます．

![newActionDialogbox.gif](../images/newActionDialogbox.gif)

ActionName:の欄に追加したいアクションの名前を指定して下さい(必須)．
同じ骨の形を持つキャラクタのアクションを複数編集する場合，
以下で説明する設定で，同じような設定を繰り返し行う必要がありますが
この作業を省略するためにベースとなるアクションを指定して
設定内容をコピーして新しいアクションを作成することができます．
「ベースとなるアクション」のリストボックスから設定をコピー
したいアクションを選択して下さい．ベースとなるアクションが無い
場合はデフォルトの「[none]」を選択しておいて下さい．
「BVH」リストボックスではアクションのモーションキャプチャデータを
選択します．もしベースとなるアクションを選択している場合には，
ここで選択したBVHファイルとベースとなるアクションに互換性があるか
どうか判定し，互換性が無い場合は新しいアクションの作成ができない
ようになっています．また，モーションの無い静物をアクションとして
作成する場合にはデフォルトの「[none]」を選択しておいて下さい．

モーションの設定
----------------------------------------

現在編集中のアクションのモーションに関する設定を
行います．

「BVH File」リストボックスでは現在編集中の
モーションキャプチャデータのファイルを変更します．
モーションキャプチャデータのファイルを変更すると，
そのアクションの他の設定項目が全てクリアされるので
気をつけて下さい．モーションの無い静物を作成する
場合は「[none]」を選択して下さい．

「ループ」チェックボックスでは，モーションを
繰り返し再生するかどうかを指定します．チェックを
入れるとループします．

「segno」と「dalsegno」はモーションをループさせる
場合に，繰り返さない最初の部分と，アクション終了時
だけ再生される最後の部分を指定する設定項目です．
単位は秒で，選択されているモーションキャプチャデータの
再生時間のどこで区切るかを指定します．
楽譜のセーニョとダルセーニョと似た感じの設定だと
考えると良いと思います．

サウンドの設定
----------------------------------------

効果音などのサウンドの設定をします．効果音を
発生させたい場合は，「ファイル」リストボックスから
効果音の入っているファイルを選択して下さい．

サウンドには「PointSound」「Background」「ConeSound」の
三種類のタイプがあります．タイプリストボックスで選択
して下さい．

「ループ」チェックボックスでサウンドの再生を
ループするかどうかを指定します．

「ゲイン」は再生するサウンドの大きさの設定です．1.0が
デフォルトの大きさです．

「継続」チェックボックスはモーションの再生が終了した
時でもサウンドの再生を継続させるかどうかの設定です．
デフォルトはONですが，OFFにするとサウンドファイルの
再生途中でもモーションが終了したらサウンドを打ち切ります．

また，サウンドの再生位置やConeSoundの場合のサウンドの向きの
編集に関しては下記「編集モード」の「サウンド」の説明を
参照して下さい．

サウンドのループに関しては少し注意点があります．
モーションの設定でモーションキャプチャファイルを
指定し，ループするように設定してある場合は，
そちらのループ設定が優先されます．例えばモーション
キャプチャデータの再生時間が2秒でサウンドの再生
時間が3秒だった場合，サウンドの2秒以降の音声は
再生されずにモーションと合うように0秒から2秒の
間が繰替えし再生されることになります．

編集モード
----------------------------------------

画面中央の3D表示部で実際の編集作業を行う時の
編集モードを選択します．

* 全部
    + BVHファイルが表す骨格とVRMLの位置や大きさなど全てを
      編集するモードです．
* 骨だけ
    + BVHファイルが表す骨格の位置や大きさなどを編集するモードです．
* 形すべて
    + 全てのVRMLの位置や回転などを編集するモードです．
* 一つの形
    + 下の対応付けで選択した骨に対応するVRMLファイル
      だけを編集するためのモードです．
* 上吹き出し
    + 上の吹き出しを表示する位置を指定するモードです．
* 下吹き出し
    + 下の吹き出しを表示する位置を指定するモードです．
* 右吹き出し
    + 右の吹き出しを表示する位置を指定するモードです．
* 左吹き出し
    + 左の吹き出しを表示する位置を指定するモードです．
* ラベル
    + ラベルを表示する場合の位置を指定するモードです．
* サウンド
    + サウンドで設定したサウンドが再生される
      場所を編集するモードです．ConeSoundの場合は
      その向きも編集できます．Backgroundの場合は，
      ここでの設定項目は無視されます．

「全部」「骨だけ」「形すべて」「一つの形」のモードの違いに
ついて補足します．「全部」のモードでは骨格と全ての形が編集
可能ですが，パーツが多い場合などは不要な物が選択されて
編集されてしまう場合があります．「骨だけ」のモードは，
VRMLの肉付けの表示をOFFにしてキャラクタ全体の位置や
大きさなどを編集するのに適しています．「形すべて」の
モードは骨を編集不可にし動かないようにして，パーツの
全体的な配置などを調節する場合に適しています．
「一つの形」は非常にたくさんのパーツがある場合などに
適しており，BVHの骨格と下の対応付け設定項目で選択した
骨に対応したVRMLだけを表示して細かな調整を行うことが
できます．

また，「メジャー」というチェックボックスがありますが，
このチェックボックスにチェックを入れると座標が表示
されます．位置や大きさを確認したい時に使用して下さい．

対応付け
----------------------------------------

モーションの設定で選択したモーションキャプチャデータ中の
骨と，それに対応付けて表示させたいVRMLの組合せを指定します．
「bone:」リストボックスから骨の名前を選択して，それに対応
するVRMLファイルを，その下の「？？？のvrml:」リストボックス
で指定してやります．

骨の名前に「[none]」という物がありますが，これはモーション
キャプチャデータと無関係に動かないVRMLファイルを設定したい
場合に使用します．

アンドゥ・リドゥ
----------------------------------------

画面の一番右下のところに「undo」と「redo」という
ボタンがありアンドゥ・リドゥの機能を提供します．
ただし現在のところ，全ての編集操作には対応しておらず，
以下の編集操作に対してのみアンドゥ・リドゥが可能です．

* マウスによる骨の編集
* マウスによるパーツ編集
* 骨に対するVRMLファイルの変更

また，編集履歴は，アクションの切り替え，BVHファイルの変更
タブの切り替えなどの操作でリセットされます．
アンドゥ・リドゥ機能はキーボードショートカットでも
呼び出すことができます(下記参照)．


3D表示部
----------------------------------------

BVHファイルで指定されている骨格や，それぞれの骨に対応付ける
パーツの位置・大きさ・回転を編集する部分です．まず，上部の
ボタンの説明です．

* top
    + 真上からの視点に切り替えます．
* front
    + 正面からの視点に切り替えます．
* side
    + 右からの視点に切り替えます
* cam
    + 自由な視点から編集対象を観覧できるモードにします．
      このモードでは編集は行えません．
* adjust
    + 編集対象が全て表示されるように視点を自動調節します．
* `+`
    + 表示領域を拡大します
* `-`
    + 表示領域を縮小して視界を広くします
* `^`
    + 表示領域を上にずらします
* `<`
    + 表示領域を左にずらします
* `>`
    + 表示領域を右にずらします
* `v`
    + 表示領域を下にずらします

top，front，sideの視点で表示している時には，
マウスで以下の操作が行えます．

* 左ドラッグ
    + ドラッグしている物の位置を調節します．
* 右ドラッグ
    + ドラッグしている物を回転して調節します．
* 真ん中ドラッグ
    + ドラッグしている物の大きさを調節します．

-----

### キーボードショートカット

* `1`
    + 正面からの視点に切り替えます．
* `3`
    + 右からの視点に切り替えます
* `7`
    + 真上からの視点に切り替えます．
* `Ctrl+z`
    + Undo
* `Ctrl+y`
    + Redo

----------------------------------------

[ヘルプTop](./help.html)

