package a3test.subcanvas;

import jp.sourceforge.acerola3d.a3.*;

import javax.swing.JFrame;
import java.awt.*;
import java.awt.event.*;

public class A3SubCanvasPickingTest extends MouseAdapter {
    //A3SubCanvas subCanvas;
    JA3SubCanvas subCanvas;
    public A3SubCanvasPickingTest() throws Exception {
        //A3Canvas mainCanvas = A3Canvas.createA3Canvas(300,300);
        JA3Canvas mainCanvas = JA3Canvas.createJA3Canvas(300,300);

        //subCanvas = A3SubCanvas.createA3SubCanvas(300,300);
        subCanvas = JA3SubCanvas.createJA3SubCanvas(300,300);
        subCanvas.addMouseListener(this);

        JFrame f = new JFrame("A3SubCanvasPickingTest");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setLayout(new GridLayout(1,2));
        f.add(mainCanvas);
        f.add(subCanvas);
        f.pack();
        f.setVisible(true);

        mainCanvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        mainCanvas.addA3SubCanvas(subCanvas);
        Action3D a3 = new Action3D("x-res:///axis.a3");
        mainCanvas.add(a3);

        subCanvas.setCameraLoc(10.0,0.0,10.0);
        subCanvas.setCameraRot(0.0,Math.PI/4.0,0.0);
    }
    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        A3Object a3 = subCanvas.pickA3(x,y);
        if (a3 instanceof Action3D) {
            ((Action3D)a3).change("spin");
        }
    }
    public static void main(String args[]) throws Exception {
        new A3SubCanvasPickingTest();
    }
}
