package a3test.debug;

import jp.sourceforge.acerola3d.a3.*;


/**
 * RZipURLConnectionのキャッシュが働いているかどうかの
 * チェック用サンプル．
 */
public class RZipCacheTest {
    public static void main(String args[]) throws Exception {
        //String url = "http://acerola3d.sourceforge.jp/samples/a3/axis.a3";
        //String url = "http://acerola3d.sourceforge.jp/samples/a3/vesma9.a3";
        //String url = "http://acerola3d.sourceforge.jp/samples/a3/ExpAtCE.a3";
        String url = "x-res:///vesma9.a3";

        //Action3Dの最初のインスタンスでは初期化に時間がかかるので
        //(1)の一行を入れて空読みさせている．でも，それでも完全には
        //1回目のロードにかかる時間が2回目以降より長くなる．謎．
        //なのでl(2)の一行も追加。
        new Action3D("x-res:///axis.a3"); // (1)
        System.out.printf("start\n");
        long startTime = System.currentTimeMillis();
        new Action3D(url);                // (2)
        long endTime = System.currentTimeMillis();
        double tt = ((double)(endTime - startTime))/1000.0;
        System.out.printf("%d: %8.2f drop\n\n",0,tt);

        int COUNT=3; //実験回数
        double t[] = new double[COUNT];

        double sum = 0.0;
        for (int i=0;i<COUNT;i++) {
            Action3D.clearCash();
            startTime = System.currentTimeMillis();
            new Action3D(url);
            endTime = System.currentTimeMillis();
            t[i] = ((double)(endTime - startTime))/1000.0;
            sum = sum + t[i];
            System.out.printf("%d: %8.2f\n",i+1,t[i]);
        }
        double ave = sum/((double)COUNT);
        System.out.printf("average : %8.2f\n",ave);

        double var = 0.0;
        for (int i=0;i<COUNT;i++) {
            var = var + (t[i]-ave)*(t[i]-ave);
        }
        var = var / (COUNT-1);
        System.out.printf("variance: %8.2f\n",var);

        System.out.printf("???: %8.2f\n",tt-ave);
    }
}
