package a3test.debug;

import jp.sourceforge.acerola3d.a3.*;
import javax.swing.JFrame;
import java.awt.*;

/*
 * なんかSubCanvasを大量に使うと上手く表示されない場合があるので調査。
 * 結果、少しおちついてからA3CanvasInterface.add(A3Object)を
 * 実行しなければならないということが判明。下のプログラムのDEBUG4の位置
 * でもダメでDEBUG5の場所でないといけない。なんとなく問題はJava3Dの中
 * みたいなので簡単に対処できなさそう。さらにはSceneのadd(A3Object)と
 * del(A3Object)の新し実装(Group.addChildやdetach()をBehavior
 * 内のスレッドで処理する実装)では表示されないだけでなくプログラム
 * 全体がフリーズする。
 * 
 * 今のところの結論としては「こういうこともあるので注意して下さい」ですかね?
 */
public class A3SubCanvasDebug {
    public static void main(String args[]) throws Exception {
        A3Canvas mainCanvas = A3Canvas.createA3Canvas(300,300);
        Action3D a3 = new Action3D("x-res:///axis.a3");
        //mainCanvas.add(a3); //DEBUG1
        mainCanvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        mainCanvas.setProjectionMode(ProjectionMode.PERSPECTIVE);
        mainCanvas.setFieldOfView(Math.PI/4.0);

        A3SubCanvas subCanvas1 = A3SubCanvas.createA3SubCanvas(300,300);
        mainCanvas.addA3SubCanvas(subCanvas1);
        subCanvas1.setProjectionMode(ProjectionMode.PARALLEL);
        subCanvas1.setCanvasWidthInPWorld(10.0);
        subCanvas1.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        subCanvas1.setCameraLoc(0.0,100.0,0.0);
        subCanvas1.setCameraRot(-Math.PI/2.0,0.0,0.0);

        A3SubCanvas subCanvas2 = A3SubCanvas.createA3SubCanvas(300,300);
        mainCanvas.addA3SubCanvas(subCanvas2);
        subCanvas2.setProjectionMode(ProjectionMode.PARALLEL);
        subCanvas2.setCanvasWidthInPWorld(10.0);
        subCanvas2.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        subCanvas2.setCameraLoc(0.0,0.0,100.0);
        subCanvas2.setCameraRot(0.0,0.0,0.0);

        A3SubCanvas subCanvas3 = A3SubCanvas.createA3SubCanvas(300,300);
        mainCanvas.addA3SubCanvas(subCanvas3);
        subCanvas3.setProjectionMode(ProjectionMode.PARALLEL);
        subCanvas3.setCanvasWidthInPWorld(10.0);
        subCanvas3.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        subCanvas3.setCameraLoc(100.0,100.0,0.0);
        subCanvas3.setCameraRot(0.0,Math.PI/2.0,0.0);

        //mainCanvas.add(a3); //DEBUG2

        JFrame f = new JFrame("A3SubCanvasTest");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setLayout(new GridLayout(2,2));
        f.add(subCanvas1);
        f.add(mainCanvas);
        f.add(subCanvas2);
        f.add(subCanvas3);
        f.pack();
        f.setVisible(true);

        //mainCanvas.add(a3); //DEBUG3

        subCanvas1.setCameraLoc(3.0,0.0,3.0);
        subCanvas1.setCameraRot(0.0,Math.PI/4.0,0.0);
        subCanvas2.setCameraLoc(3.0,0.0,3.0);
        subCanvas2.setCameraRot(0.0,Math.PI/4.0,0.0);
        subCanvas3.setCameraLoc(3.0,0.0,3.0);
        subCanvas3.setCameraRot(0.0,Math.PI/4.0,0.0);

        //mainCanvas.add(a3); //DEBUG4
        Thread.sleep(100);
        mainCanvas.add(a3); //DEBUG5
    }
}
