/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.atto.js;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.atto.AttoParser;
import net.morilib.lisp.atto.AttoTraverser;
import net.morilib.lisp.atto.Callback;
import net.morilib.lisp.atto.Cell;
import net.morilib.lisp.atto.Environment;
import net.morilib.lisp.atto.Keyword;
import net.morilib.lisp.atto.LispAtto;
import net.morilib.lisp.atto.RegexWrapper;
import net.morilib.lisp.atto.Symbol;

public class JSCallback
implements Callback {
    PrintWriter out;

    public JSCallback(PrintWriter writer) {
        this.out = writer;
    }

    @Override
    public void init(Environment env) {
    }

    @Override
    public void initCPS(Environment env) {
    }

    @Override
    public Object find(Environment env, Object o) {
        if (o instanceof Symbol) {
            this.out.print(" ");
            this.out.print("$env.find('");
            this.out.print(((Symbol)o).getName());
            this.out.print("')");
            this.out.print(" ");
        } else {
            this.value(env, o);
        }
        this.out.print(" ");
        return this;
    }

    private void printstr(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\"') {
                this.out.print("\\\"");
            } else if (c == '\'') {
                this.out.print("\\'");
            } else if (c == '\\') {
                this.out.print("\\\\");
            } else if (c == '\b') {
                this.out.print("\\b");
            } else if (c == '\t') {
                this.out.print("\\t");
            } else if (c == '\n') {
                this.out.print("\\n");
            } else if (c == '\f') {
                this.out.print("\\f");
            } else if (c == '\r') {
                this.out.print("\\r");
            } else if (c < ' ' || c >= '\u007f') {
                this.out.format("\\u%4d", c);
            } else {
                this.out.print(c);
            }
            ++i;
        }
    }

    @Override
    public Object value(Environment env, Object o) {
        this.out.print(" ");
        if (o instanceof Number) {
            this.out.print(((Number)o).doubleValue());
        } else if (o.equals(LispAtto.UNDEF)) {
            this.out.print("undefined");
        } else if (o instanceof Symbol) {
            this.out.print("$mille.getSymbol('");
            this.out.print(((Symbol)o).getName());
            this.out.print("')");
        } else if (o instanceof String) {
            this.out.print('\"');
            this.printstr((String)o);
            this.out.print('\"');
        } else if (o instanceof Boolean) {
            this.out.print(o);
        } else if (o instanceof Character) {
            this.out.print((int)((Character)o).charValue());
        } else if (o.equals(Cell.NIL)) {
            this.out.print("$mille.nil");
        } else if (o instanceof List) {
            List l = (List)o;
            this.out.print("[");
            int i = 0;
            while (i < l.size()) {
                if (i > 0) {
                    this.out.print(",");
                }
                this.value(env, l.get(i));
                ++i;
            }
            this.out.print("]");
        } else if (o instanceof Cell) {
            this.out.print("$mille.cons(");
            this.value(env, ((Cell)o).car);
            this.out.print(",");
            this.value(env, ((Cell)o).cdr);
            this.out.print(")");
        } else if (o instanceof Double[]) {
            this.out.print("$mille.c.make(");
            this.out.print(((Double[])o)[0]);
            this.out.print(",");
            this.out.print(((Double[])o)[1]);
            this.out.print(")");
        } else if (o instanceof RegexWrapper) {
            this.out.print("(/");
            this.out.print(((RegexWrapper)o).getRegex());
            this.out.print("/");
            this.out.print(((RegexWrapper)o).getFlags());
            this.out.print(")");
        } else if (o instanceof Keyword) {
            this.out.print("$mille.getKeyword('");
            this.out.print(((Keyword)o).getName());
            this.out.print("')");
        } else if (o == AttoParser.NULL) {
            this.out.print("(null)");
        } else {
            this.out.print("#<object>");
        }
        this.out.print(" ");
        return this;
    }

    private String getKeyword(Object o) {
        if (o instanceof Keyword) {
            return ((Keyword)o).getName();
        }
        return null;
    }

    private void outapplyargs(Environment env, Object ... args) {
        String d = "";
        int i = 0;
        while (i < args.length) {
            if (this.getKeyword(args[i]) != null) break;
            this.out.print(',');
            AttoTraverser.traverse(this, env, args[i]);
            ++i;
        }
        if (i < args.length) {
            this.out.print(",{");
            while (i < args.length) {
                String s = this.getKeyword(args[i]);
                if (i + 1 >= args.length || s == null) break;
                this.out.print(d);
                this.out.print(s);
                this.out.print(':');
                AttoTraverser.traverse(this, env, args[i + 1]);
                d = ",";
                i += 2;
            }
            this.out.print('}');
        }
    }

    @Override
    public Object apply(Environment env, Object f, Object ... args) {
        String s;
        if (args.length >= 1 && f instanceof Symbol && (s = ((Symbol)f).getName()).length() >= 2 && s.startsWith(".")) {
            this.out.print("$mille.applyObject('");
            this.out.print(s.substring(1));
            this.out.print("'");
            this.outapplyargs(env, args);
            this.out.print(')');
        } else if (f instanceof Symbol && ((Symbol)f).getName().indexOf(46) > 0) {
            this.out.print("$env.applySymbol('");
            this.out.print(((Symbol)f).getName());
            this.out.print("'");
            this.outapplyargs(env, args);
            this.out.print(')');
        } else {
            this.out.print("$mille.apply(");
            AttoTraverser.traverse(this, env, f);
            this.outapplyargs(env, args);
            this.out.print(')');
        }
        return this;
    }

    @Override
    public Object doIf(Environment env, Object cond, Object dotrue) {
        this.out.print("(!((");
        AttoTraverser.traverse(this, env, cond);
        this.out.print(")===false) ? ");
        AttoTraverser.traverse(this, env, dotrue);
        this.out.print(" : undefined)");
        return this;
    }

    @Override
    public Object doIf(Environment env, Object cond, Object dotrue, Object dofalse) {
        this.out.print("(!((");
        AttoTraverser.traverse(this, env, cond);
        this.out.print(")===false) ? ");
        AttoTraverser.traverse(this, env, dotrue);
        this.out.print(" : ");
        AttoTraverser.traverse(this, env, dofalse);
        this.out.print(')');
        return this;
    }

    @Override
    public Object doDefine(Environment env, Object sym, Object tobound) {
        if (sym instanceof Symbol) {
            this.out.print("$env.bind('");
            this.out.print(((Symbol)sym).getName());
            this.out.print("', ");
            AttoTraverser.traverse(this, env, tobound);
            this.out.print(")");
            return this;
        }
        throw new IllegalArgumentException(sym.toString());
    }

    private void toarray(int l, Symbol r) {
        this.out.print("var a = $mille.a.toArray(arguments,");
        this.out.print(l + 1);
        this.out.print(");");
        this.out.print("$env.bind('");
        this.out.print(r.getName());
        this.out.print("',$mille.listToCell(a));");
    }

    @Override
    public Object doLambda(Environment env, Object args, Object ... body) {
        if (args instanceof Cell) {
            ArrayList<Symbol> l = new ArrayList<Symbol>();
            Object o = args;
            Symbol r = null;
            while (!Cell.NIL.equals(o)) {
                if (o instanceof Cell) {
                    if (((Cell)o).car instanceof Symbol) {
                        l.add((Symbol)((Cell)o).car);
                        o = ((Cell)o).cdr;
                        continue;
                    }
                    throw new IllegalArgumentException(((Cell)o).car.toString());
                }
                if (o instanceof Symbol) {
                    r = (Symbol)o;
                    break;
                }
                throw new IllegalArgumentException(o.toString());
            }
            this.out.print("$mille.closure($env, this, function($env");
            int i = 0;
            while (i < l.size()) {
                this.out.print(',');
                this.out.print("a");
                this.out.print(i);
                ++i;
            }
            this.out.print(") {");
            i = 0;
            while (i < l.size()) {
                this.out.print("$env.bind('");
                this.out.print(((Symbol)l.get(i)).getName());
                this.out.print("', a");
                this.out.print(i);
                this.out.print(" === undefined ? null : a");
                this.out.print(i);
                this.out.print(");");
                ++i;
            }
            if (r != null) {
                this.toarray(l.size(), r);
            }
        } else if (args instanceof Symbol) {
            this.out.print("$mille.closure($env, this, function($env) {");
            this.toarray(0, (Symbol)args);
        } else {
            throw new IllegalArgumentException(args.toString());
        }
        this.out.print("return ");
        this.doBegin(env, body);
        this.out.print(";})");
        return this;
    }

    @Override
    public Object doSet(Environment env, Object sym, Object toset) {
        if (!(sym instanceof Symbol)) {
            throw new IllegalArgumentException(sym.toString());
        }
        this.out.print("($env.set('");
        this.out.print(((Symbol)sym).getName());
        this.out.print("',");
        AttoTraverser.traverse(this, env, toset);
        this.out.print("), undefined)");
        return this;
    }

    @Override
    public Object doBegin(Environment env, Object ... body) {
        this.out.print("(");
        int i = 0;
        while (i < body.length) {
            if (i > 0) {
                this.out.print(',');
            }
            this.out.print("(");
            AttoTraverser.traverse(this, env, body[i]);
            this.out.print(")");
            ++i;
        }
        this.out.print(")");
        return this;
    }

    @Override
    public Object doDelay(Environment env, Object a) {
        this.out.print("$mille.delay(function(){return(");
        AttoTraverser.traverse(this, env, a);
        this.out.print(");})");
        return null;
    }
}

