/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.atto;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import net.morilib.lisp.atto.AttoParser;
import net.morilib.lisp.atto.AttoTraverser;
import net.morilib.lisp.atto.Callback;
import net.morilib.lisp.atto.Cell;
import net.morilib.lisp.atto.Environment;
import net.morilib.lisp.atto.SimpleEngine;
import net.morilib.lisp.atto.Symbol;

public class LispAtto {
    public static final Object UNDEF = new Serializable(){

        public String toString() {
            return "#<undef>";
        }
    };
    private static final Cell CONTK = new Cell(Symbol.get("lambda"), new Cell(new Cell(Symbol.get("k"), Cell.NIL), new Cell(Symbol.get("k"), Cell.NIL)));
    Environment macroenv;
    Environment env;
    Environment cps;
    private boolean init = false;

    public LispAtto() {
        try {
            this.macroenv = new Environment();
            SimpleEngine.INSTANCE.init(this.macroenv);
            LispAtto.eval((Callback)SimpleEngine.INSTANCE, this.macroenv, LispAtto.class.getResourceAsStream("macro-atto.scm"));
            this.cps = new Environment();
            SimpleEngine.INSTANCE.init(this.cps);
            this.eval(this.cps, LispAtto.class.getResourceAsStream("lib.scm"));
            this.eval(this.cps, LispAtto.class.getResourceAsStream("cps.scm"));
            this.init = true;
            this.env = new Environment();
            SimpleEngine.INSTANCE.initCPS(this.env);
            this.eval(LispAtto.class.getResourceAsStream("lib.scm"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object eval(Callback b, Environment v, Reader rd) throws IOException {
        Object o;
        Object p = null;
        b.init(v);
        while ((o = AttoParser.read(rd)) != null) {
            p = AttoTraverser.traverse(b, v, o);
        }
        return p;
    }

    public static Object eval(Callback b, Environment v, InputStream ins) throws IOException {
        return LispAtto.eval(b, v, new InputStreamReader(ins));
    }

    private Object cps(Object o) {
        Object p = o;
        p = new Cell(Symbol.get("quote"), new Cell(p, Cell.NIL));
        p = new Cell(Symbol.get("cps"), new Cell(p, Cell.NIL));
        return p;
    }

    public Object eval(Environment env, Object p) {
        Object o = p;
        o = new Cell(Symbol.get("eval-macro"), new Cell(new Cell(Symbol.QUOTE, new Cell(o, Cell.NIL)), Cell.NIL));
        o = AttoTraverser.traverse(SimpleEngine.INSTANCE, this.macroenv, o);
        if (this.init && p instanceof Cell) {
            if (((Cell)p).car.equals(Symbol.get("define"))) {
                o = AttoTraverser.traverse(SimpleEngine.INSTANCE, this.cps, this.cps(o));
            } else {
                o = new Cell(Symbol.get("lambda"), new Cell(Cell.NIL, new Cell(o, Cell.NIL)));
                o = AttoTraverser.traverse(SimpleEngine.INSTANCE, this.cps, this.cps(o));
                o = new Cell(o, new Cell(CONTK, Cell.NIL));
            }
        }
        o = AttoTraverser.traverse(SimpleEngine.INSTANCE, env, o);
        return o;
    }

    public Object eval(Environment env, Reader rd) throws IOException {
        Object p = UNDEF;
        Object o;
        while ((o = AttoParser.read(rd)) != null) {
            p = this.eval(env, o);
        }
        return p;
    }

    public Object eval(Environment env, InputStream in) throws IOException {
        return this.eval(env, new InputStreamReader(in));
    }

    public Object eval(Object p) {
        return this.eval(this.env, p);
    }

    public Object eval(Reader rd) throws IOException {
        return this.eval(this.env, rd);
    }

    public Object eval(InputStream in) throws IOException {
        return this.eval(this.env, in);
    }

    public static void main(String[] args) {
        LispAtto s = new LispAtto();
        Object p = UNDEF;
        InputStreamReader rd = new InputStreamReader(System.in);
        System.out.print(" >");
        while (true) {
            try {
                while (true) {
                    Object o;
                    if ((o = AttoParser.read(rd)) == null) {
                        System.exit(0);
                    } else {
                        if (o == AttoParser.INVALIDTOKEN) continue;
                        p = s.eval(o);
                        System.out.println(p);
                    }
                    System.out.print(" >");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (ArithmeticException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

