/*
 * Copyright 2014 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.atto;

import java.io.Reader;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * The parser of Schluessel Atto.
 * This class is generated by Nina graphical plugin.
 * 
 * @author Yuichiro MORIGUCHI
 */
public class AttoParser   {

	/* @@@-PARSER-CODE-START-@@@ */
	static class TokenException extends RuntimeException {
	}

	static abstract class Engine {
		abstract int step(Object c) throws java.io.IOException;
		abstract boolean accepted();
		abstract boolean isDead();
		abstract boolean isEmptyTransition();
		abstract int execaction(Object c);
		abstract boolean isend();
		abstract int recover(Exception e);
		abstract int deadState();
		abstract int stateSize();
		abstract int finallyState();
	}
	static final Object INVALIDTOKEN = new Object();
	private static final Object NINA_BEGIN = new Object();
	private static final int NINA_EOF = -1;
	private static final int NINA_ACCEPT = -8;
	private static final int NINA_FAIL = -9;
	private static final int NINA_HALT_ACCEPT = -91;
	private static final int NINA_HALT_REJECT = -72;
	private static final int NINA_YIELD = -85;
	private static final int NINA_STACKLEN = 72;
	static final int NINA_DISCARDSTATE = 0x40000000;
	static final int INITIAL = 0;
	static final int INDENT = 1;

	private int STATE;
	private int[] __sts = new int[NINA_STACKLEN];
	private Engine[] __stk = new Engine[NINA_STACKLEN];
	private Object[][] __stv = new Object[NINA_STACKLEN][];
	private int __slen = 0;
	private Object unread = null;

	Object _;
	java.util.List<Object> _l;
	Object yieldObject;
	Throwable exception;

	StringBuffer $buffer;
	int $int;
	java.math.BigInteger $bigint;
	Number $num;

	java.util.Stack<java.io.Reader> streamStack =
			new java.util.Stack<java.io.Reader>();

	void _initlist() {
		_l = new java.util.ArrayList<Object>();
	}

	void _addlist(Object x) {
		_l.add(x);
	}


	private int _unreadl = -1;

	void INCLUDE(java.io.Reader rd) {
		streamStack.push(rd);
	}

	void INCLUDE(String name) throws java.io.IOException {
		java.io.InputStream ins;

		ins = new java.io.FileInputStream(name);
		INCLUDE(new java.io.InputStreamReader(ins));
	}

	int _read1l() throws java.io.IOException {
		int c;

		while(streamStack.size() > 0) {
			if((c = streamStack.peek().read()) >= 0) {
				return c;
			} else if(streamStack.size() > 1) {
				streamStack.pop().close();
			} else {
				streamStack.pop();
			}
		}
		return NINA_EOF;
	}

	int lexer_step(int $c) {
		switch(STATE) {
		case 0:
			if(($c == '.')) {
				STATE = 1;
				return 1;
			} else if(($c == '+') || ($c == '-')) {
				STATE = 2;
				return 1;
			} else if(($c == ',')) {
				STATE = 3;
				return 1;
			} else if(($c == '"')) {
				STATE = 4;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 5;
				return 1;
			} else if(($c == ';')) {
				STATE = 6;
				return 1;
			} else if(($c == '#')) {
				STATE = 7;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c == '*') || ($c == '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			} else if(($c >= '(' && $c <= ')')) {
				STATE = 9;
				return 1;
			} else if(($c == '\'') || ($c == '^') || ($c == '`')) {
				STATE = 10;
				return 1;
			} else if(($c >= '0' && $c <= '9')) {
				STATE = 11;
				return 1;
			}
			return 0;
		case 11:
			if(($c == 'i')) {
				STATE = 12;
				return 1;
			} else if(($c == '+') || ($c == '-')) {
				STATE = 13;
				return 1;
			} else if(($c == '.')) {
				STATE = 14;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c == '*') || ($c == '/') || ($c == ':') || ($c >= '<' && $c <= 'D') || ($c >= 'F' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 'd') || ($c >= 'f' && $c <= 'h') || ($c >= 'j' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			} else if(($c == 'E') || ($c == 'e')) {
				STATE = 15;
				return 1;
			} else if(($c >= '0' && $c <= '9')) {
				STATE = 11;
				return 1;
			}
			return 0;
		case 15:
			if(($c >= '0' && $c <= '9')) {
				STATE = 16;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c == '*') || ($c >= '.' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			} else if(($c == '+') || ($c == '-')) {
				STATE = 17;
				return 1;
			}
			return 0;
		case 17:
			if(($c >= '0' && $c <= '9')) {
				STATE = 16;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 16:
			if(($c == 'i')) {
				STATE = 12;
				return 1;
			} else if(($c == '+') || ($c == '-')) {
				STATE = 13;
				return 1;
			} else if(($c >= '0' && $c <= '9')) {
				STATE = 16;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c == '*') || ($c >= '.' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 'h') || ($c >= 'j' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 14:
			if(($c >= '0' && $c <= '9')) {
				STATE = 18;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 18:
			if(($c == 'i')) {
				STATE = 12;
				return 1;
			} else if(($c == '+') || ($c == '-')) {
				STATE = 13;
				return 1;
			} else if(($c >= '0' && $c <= '9')) {
				STATE = 18;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c == '*') || ($c >= '.' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= 'D') || ($c >= 'F' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 'd') || ($c >= 'f' && $c <= 'h') || ($c >= 'j' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			} else if(($c == 'E') || ($c == 'e')) {
				STATE = 15;
				return 1;
			}
			return 0;
		case 13:
			if(($c == '.')) {
				STATE = 19;
				return 1;
			} else if(($c >= '0' && $c <= '9')) {
				STATE = 20;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c == '*') || ($c == '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			} else if(($c == '+') || ($c == '-')) {
				STATE = 21;
				return 1;
			}
			return 0;
		case 21:
			if(($c == '.')) {
				STATE = 19;
				return 1;
			} else if(($c >= '0' && $c <= '9')) {
				STATE = 20;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c == '-') || ($c == '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 20:
			if(($c == '.')) {
				STATE = 19;
				return 1;
			} else if(($c == 'i')) {
				STATE = 12;
				return 1;
			} else if(($c == 'E') || ($c == 'e')) {
				STATE = 22;
				return 1;
			} else if(($c >= '0' && $c <= '9')) {
				STATE = 20;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c == '-') || ($c == '/') || ($c == ':') || ($c >= '<' && $c <= 'D') || ($c >= 'F' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 'd') || ($c >= 'f' && $c <= 'h') || ($c >= 'j' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 22:
			if(($c >= '0' && $c <= '9')) {
				STATE = 23;
				return 1;
			} else if(($c == '+') || ($c == '-')) {
				STATE = 24;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c == '*') || ($c >= '.' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 24:
			if(($c >= '0' && $c <= '9')) {
				STATE = 23;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 23:
			if(($c == 'i')) {
				STATE = 12;
				return 1;
			} else if(($c >= '0' && $c <= '9')) {
				STATE = 23;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 'h') || ($c >= 'j' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 19:
			if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			} else if(($c >= '0' && $c <= '9')) {
				STATE = 25;
				return 1;
			}
			return 0;
		case 25:
			if(($c == 'i')) {
				STATE = 12;
				return 1;
			} else if(($c == 'E') || ($c == 'e')) {
				STATE = 22;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= 'D') || ($c >= 'F' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 'd') || ($c >= 'f' && $c <= 'h') || ($c >= 'j' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			} else if(($c >= '0' && $c <= '9')) {
				STATE = 25;
				return 1;
			}
			return 0;
		case 12:
			if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 10:
			return 0;
		case 9:
			return 0;
		case 8:
			if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 7:
			if(($c == 'X') || ($c == 'x')) {
				STATE = 26;
				return 1;
			} else if(($c == 'O') || ($c == 'o')) {
				STATE = 27;
				return 1;
			} else if(($c == '/')) {
				STATE = 28;
				return 1;
			} else if(($c == 'B') || ($c == 'b')) {
				STATE = 29;
				return 1;
			} else if(($c == '\\')) {
				STATE = 30;
				return 1;
			} else if(($c == '(')) {
				STATE = 31;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '.') || ($c >= '0' && $c <= ':') || ($c >= '<' && $c <= 'A') || ($c >= 'C' && $c <= 'N') || ($c >= 'P' && $c <= 'W') || ($c >= 'Y' && $c <= '[') || ($c == ']') || ($c == '_') || ($c == 'a') || ($c >= 'c' && $c <= 'n') || ($c >= 'p' && $c <= 'w') || ($c >= 'y' && $c <= 2147483647)) {
				STATE = 32;
				return 1;
			}
			return 0;
		case 32:
			if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 32;
				return 1;
			}
			return 0;
		case 31:
			return 0;
		case 30:
			if(($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 33;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ') || ($c >= '"' && $c <= '#') || ($c >= '\'' && $c <= ')') || ($c == ',') || ($c == ';') || ($c == '^') || ($c == '`')) {
				STATE = 34;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= ':') || ($c >= '<' && $c <= '@') || ($c >= '[' && $c <= ']') || ($c == '_') || ($c >= '{' && $c <= 2147483647)) {
				STATE = 35;
				return 1;
			}
			return 0;
		case 35:
			if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 32;
				return 1;
			}
			return 0;
		case 34:
			return 0;
		case 33:
			if(($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 36;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= ':') || ($c >= '<' && $c <= '@') || ($c >= '[' && $c <= ']') || ($c == '_') || ($c >= '{' && $c <= 2147483647)) {
				STATE = 32;
				return 1;
			}
			return 0;
		case 36:
			if(($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 36;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= ':') || ($c >= '<' && $c <= '@') || ($c >= '[' && $c <= ']') || ($c == '_') || ($c >= '{' && $c <= 2147483647)) {
				STATE = 32;
				return 1;
			}
			return 0;
		case 29:
			if(($c >= '0' && $c <= '1')) {
				STATE = 37;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c >= '2' && $c <= ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 32;
				return 1;
			}
			return 0;
		case 37:
			if(($c >= '0' && $c <= '1')) {
				STATE = 37;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c >= '2' && $c <= ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 32;
				return 1;
			}
			return 0;
		case 28:
			if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 38;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ') || ($c >= '"' && $c <= '#') || ($c >= '\'' && $c <= ')') || ($c == ',') || ($c == ';') || ($c == '^') || ($c == '`')) {
				STATE = 39;
				return 1;
			}
			return 0;
		case 39:
			if(($c == '/')) {
				STATE = 40;
				return 1;
			} else if(($c == '\\')) {
				STATE = 41;
				return 1;
			} else if(($c >= 0 && $c <= '.') || ($c >= '0' && $c <= '[') || ($c >= ']' && $c <= 2147483647)) {
				STATE = 39;
				return 1;
			}
			return 0;
		case 41:
			if(($c == '\\')) {
				STATE = 41;
				return 1;
			} else if(($c >= 0 && $c <= '.') || ($c >= '0' && $c <= '[') || ($c >= ']' && $c <= 2147483647)) {
				STATE = 39;
				return 1;
			} else if(($c == '/')) {
				STATE = 42;
				return 1;
			}
			return 0;
		case 42:
			if(($c == '/')) {
				STATE = 40;
				return 1;
			} else if(($c == '\\')) {
				STATE = 41;
				return 1;
			} else if(($c >= 0 && $c <= '.') || ($c >= '0' && $c <= '[') || ($c >= ']' && $c <= '`') || ($c >= '{' && $c <= 2147483647)) {
				STATE = 39;
				return 1;
			} else if(($c >= 'a' && $c <= 'z')) {
				STATE = 42;
				return 1;
			}
			return 0;
		case 40:
			if(($c >= 'a' && $c <= 'z')) {
				STATE = 40;
				return 1;
			}
			return 0;
		case 38:
			if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '.') || ($c >= '0' && $c <= ':') || ($c >= '<' && $c <= '[') || ($c == ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 38;
				return 1;
			} else if(($c == '\\')) {
				STATE = 43;
				return 1;
			} else if(($c == '/')) {
				STATE = 44;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ') || ($c >= '"' && $c <= '#') || ($c >= '\'' && $c <= ')') || ($c == ',') || ($c == ';') || ($c == '^') || ($c == '`')) {
				STATE = 39;
				return 1;
			}
			return 0;
		case 44:
			if(($c >= 'a' && $c <= 'z')) {
				STATE = 44;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= '{' && $c <= 2147483647)) {
				STATE = 32;
				return 1;
			}
			return 0;
		case 43:
			if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '.') || ($c >= '0' && $c <= ':') || ($c >= '<' && $c <= '[') || ($c == ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 38;
				return 1;
			} else if(($c == '\\')) {
				STATE = 43;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ') || ($c >= '"' && $c <= '#') || ($c >= '\'' && $c <= ')') || ($c == ',') || ($c == ';') || ($c == '^') || ($c == '`')) {
				STATE = 39;
				return 1;
			} else if(($c == '/')) {
				STATE = 45;
				return 1;
			}
			return 0;
		case 45:
			if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '.') || ($c >= '0' && $c <= ':') || ($c >= '<' && $c <= '[') || ($c == ']') || ($c == '_') || ($c >= '{' && $c <= 2147483647)) {
				STATE = 38;
				return 1;
			} else if(($c == '\\')) {
				STATE = 43;
				return 1;
			} else if(($c == '/')) {
				STATE = 44;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ') || ($c >= '"' && $c <= '#') || ($c >= '\'' && $c <= ')') || ($c == ',') || ($c == ';') || ($c == '^') || ($c == '`')) {
				STATE = 39;
				return 1;
			} else if(($c >= 'a' && $c <= 'z')) {
				STATE = 45;
				return 1;
			}
			return 0;
		case 27:
			if(($c >= '0' && $c <= '7')) {
				STATE = 46;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c >= '8' && $c <= ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 32;
				return 1;
			}
			return 0;
		case 46:
			if(($c >= '0' && $c <= '7')) {
				STATE = 46;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c >= '8' && $c <= ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 32;
				return 1;
			}
			return 0;
		case 26:
			if(($c >= '0' && $c <= '9') || ($c >= 'A' && $c <= 'F') || ($c >= 'a' && $c <= 'f')) {
				STATE = 47;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= '@') || ($c >= 'G' && $c <= ']') || ($c == '_') || ($c >= 'g' && $c <= 2147483647)) {
				STATE = 32;
				return 1;
			}
			return 0;
		case 47:
			if(($c >= '0' && $c <= '9') || ($c >= 'A' && $c <= 'F') || ($c >= 'a' && $c <= 'f')) {
				STATE = 47;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= '@') || ($c >= 'G' && $c <= ']') || ($c == '_') || ($c >= 'g' && $c <= 2147483647)) {
				STATE = 32;
				return 1;
			}
			return 0;
		case 6:
			if(($c >= 0 && $c <= 9) || ($c >= 11 && $c <= 2147483647)) {
				STATE = 6;
				return 1;
			}
			return 0;
		case 5:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 5;
				return 1;
			}
			return 0;
		case 4:
			if(($c >= 0 && $c <= '!') || ($c >= '#' && $c <= '[') || ($c >= ']' && $c <= 2147483647)) {
				STATE = 4;
				return 1;
			} else if(($c == '\\')) {
				STATE = 48;
				return 1;
			} else if(($c == '"')) {
				STATE = 49;
				return 1;
			}
			return 0;
		case 49:
			return 0;
		case 48:
			if(($c >= 0 && $c <= 't') || ($c >= 'v' && $c <= 'w') || ($c >= 'y' && $c <= 2147483647)) {
				STATE = 4;
				return 1;
			} else if(($c == 'u') || ($c == 'x')) {
				STATE = 50;
				return 1;
			}
			return 0;
		case 50:
			if(($c >= 0 && $c <= '!') || ($c >= '#' && $c <= '/') || ($c >= ':' && $c <= '@') || ($c >= 'G' && $c <= '[') || ($c >= ']' && $c <= '`') || ($c >= 'g' && $c <= 2147483647)) {
				STATE = 4;
				return 1;
			} else if(($c >= '0' && $c <= '9') || ($c >= 'A' && $c <= 'F') || ($c >= 'a' && $c <= 'f')) {
				STATE = 51;
				return 1;
			} else if(($c == '\\')) {
				STATE = 48;
				return 1;
			} else if(($c == '"')) {
				STATE = 49;
				return 1;
			}
			return 0;
		case 51:
			if(($c >= 0 && $c <= '!') || ($c >= '#' && $c <= '/') || ($c >= ':' && $c <= '@') || ($c >= 'G' && $c <= '[') || ($c >= ']' && $c <= '`') || ($c >= 'g' && $c <= 2147483647)) {
				STATE = 4;
				return 1;
			} else if(($c >= '0' && $c <= '9') || ($c >= 'A' && $c <= 'F') || ($c >= 'a' && $c <= 'f')) {
				STATE = 51;
				return 1;
			} else if(($c == '\\')) {
				STATE = 48;
				return 1;
			} else if(($c == '"')) {
				STATE = 49;
				return 1;
			}
			return 0;
		case 3:
			if(($c == '@')) {
				STATE = 52;
				return 1;
			}
			return 0;
		case 52:
			return 0;
		case 2:
			if(($c >= '0' && $c <= '9')) {
				STATE = 53;
				return 1;
			} else if(($c == '.')) {
				STATE = 14;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c == '-') || ($c == '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 53:
			if(($c >= '0' && $c <= '9')) {
				STATE = 53;
				return 1;
			} else if(($c == 'i')) {
				STATE = 12;
				return 1;
			} else if(($c == '+') || ($c == '-')) {
				STATE = 13;
				return 1;
			} else if(($c == '.')) {
				STATE = 14;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c == '*') || ($c == '/') || ($c == ':') || ($c >= '<' && $c <= 'D') || ($c >= 'F' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 'd') || ($c >= 'f' && $c <= 'h') || ($c >= 'j' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			} else if(($c == 'E') || ($c == 'e')) {
				STATE = 15;
				return 1;
			}
			return 0;
		case 1:
			if(($c >= '0' && $c <= '9')) {
				STATE = 18;
				return 1;
			} else if(($c >= 0 && $c <= 8) || ($c >= 11 && $c <= 31) || ($c == '!') || ($c >= '$' && $c <= '&') || ($c >= '*' && $c <= '+') || ($c >= '-' && $c <= '/') || ($c == ':') || ($c >= '<' && $c <= ']') || ($c == '_') || ($c >= 'a' && $c <= 2147483647)) {
				STATE = 8;
				return 1;
			}
			return 0;
		}
		return 0;
	}

	boolean lexer_accepted() {
		return (STATE == 1 ||
				STATE == 2 ||
				STATE == 3 ||
				STATE == 5 ||
				STATE == 6 ||
				STATE == 8 ||
				STATE == 9 ||
				STATE == 10 ||
				STATE == 11 ||
				STATE == 12 ||
				STATE == 13 ||
				STATE == 14 ||
				STATE == 15 ||
				STATE == 17 ||
				STATE == 16 ||
				STATE == 19 ||
				STATE == 18 ||
				STATE == 21 ||
				STATE == 20 ||
				STATE == 23 ||
				STATE == 22 ||
				STATE == 25 ||
				STATE == 24 ||
				STATE == 27 ||
				STATE == 26 ||
				STATE == 29 ||
				STATE == 28 ||
				STATE == 31 ||
				STATE == 30 ||
				STATE == 34 ||
				STATE == 35 ||
				STATE == 32 ||
				STATE == 33 ||
				STATE == 38 ||
				STATE == 36 ||
				STATE == 37 ||
				STATE == 42 ||
				STATE == 43 ||
				STATE == 40 ||
				STATE == 46 ||
				STATE == 47 ||
				STATE == 44 ||
				STATE == 45 ||
				STATE == 49 ||
				STATE == 53 ||
				STATE == 52);
	}

	Object lexer_gettoken(StringBuffer b) {
		String $$ = b.toString();

		switch(STATE) {
		case 35:
			// State23        
return ch1($$);
		case 5:
			// State9      
return null;
		case 21:
			// State11         
return sget($$);
		case 49:
			// State2         
return str($$);
		case 20:
			// State11         
return sget($$);
		case 11:
			// State12         
return _int($$);
		case 23:
			// State11         
return sget($$);
		case 42:
			// State47        
return reg($$);
		case 9:
			// State27   
return $$;
		case 36:
			// State24        
return chn($$);
		case 33:
			// State25        
return ch1($$);
		case 29:
			// State6         
return shp($$);
		case 46:
			// State36        
return oct($$);
		case 19:
			// State11         
return sget($$);
		case 34:
			// State23        
return ch1($$);
		case 14:
			// State11         
return sget($$);
		case 31:
			// State10   
return $$;
		case 30:
			// State6         
return shp($$);
		case 16:
			// State13        
return dbl($$);
		case 17:
			// State11         
return sget($$);
		case 37:
			// State32        
return bin($$);
		case 13:
			// State11         
return sget($$);
		case 43:
			// State6         
return shp($$);
		case 22:
			// State11         
return sget($$);
		case 45:
			// State47        
return reg($$);
		case 44:
			// State47        
return reg($$);
		case 8:
			// State11         
return sget($$);
		case 25:
			// State11         
return sget($$);
		case 24:
			// State11         
return sget($$);
		case 18:
			// State13        
return dbl($$);
		case 40:
			// State47        
return reg($$);
		case 10:
			// State20           
return MT.get($$);
		case 47:
			// State34        
return hex($$);
		case 1:
			// State27   
return $$;
		case 2:
			// State11         
return sget($$);
		case 27:
			// State6         
return shp($$);
		case 52:
			// State21       
return MT.UNS;
		case 26:
			// State6         
return shp($$);
		case 28:
			// State6         
return shp($$);
		case 32:
			// State6         
return shp($$);
		case 3:
			// State20           
return MT.get($$);
		case 53:
			// State13        
return dbl($$);
		case 12:
			// State40        
return cmp($$);
		case 38:
			// State6         
return shp($$);
		case 6:
			// State7      
return null;
		case 15:
			// State11         
return sget($$);
		default:  return null;
		}
	}

	boolean lexer_isdead() {
return (false || STATE == 49 || STATE == 9 || STATE == 34 || STATE == 31 || STATE == 10 || STATE == 52);
	}

	int _read1ul() throws java.io.IOException {
		int c;

		if(_unreadl != -1) {
			c = _unreadl;
			_unreadl = -1;
		} else if((c = _read1l()) == '\r' && (c = _read1l()) != '\n') {
			_unreadl = c;
			c = '\r';
		}
		return c;
	}

	Object _read1() throws java.io.IOException {
		StringBuffer b = new StringBuffer();
		Object o = null;
		boolean f;
		int a;
		int s;

		s = STATE;  STATE = 0;
		f = lexer_accepted();
		while(o == null) {
			if((a = _read1ul()) == -1) {
				o = lexer_gettoken(b);
				break;
			} else if(lexer_step(a) == 0) {
				if(f) {
					_unreadl = a;
					o = lexer_gettoken(b);
					b = new StringBuffer();
					STATE = 0;
					f = lexer_accepted();
				} else {
					o = INVALIDTOKEN;  break;
				}
			} else {
				b.appendCodePoint(a);
				if(f = lexer_accepted()) {
					if(lexer_isdead()) {
						o = lexer_gettoken(b);
						b = new StringBuffer();
						STATE = 0;
						f = lexer_accepted();
					}
				} else if(lexer_isdead()) {
					o = INVALIDTOKEN;  break;
				}
			}
		}
		STATE = s;
		return o;
	}

	private Object _read() throws java.io.IOException {
		Object c;

		while(true) {
			if(unread != null) {

				c = unread;
				unread = null;
				__logprint("Read unread: ", c);
			} else if((c = _read1()) != null) {
				__logprint("Read: ", c);
			} else {
				__logprint("Read end-of-file");
			}
			return c;
		}
	}

	void UNGET(Object c) {
		unread = c;
		__logprint("Set unread: ", c);
	}

	void __sleep(int m) {
		try {
			Thread.sleep(m);
		} catch(InterruptedException e) {
			throw new RuntimeException(e);
		}
	}

	private void __logprint(String s, Object c) {
	}

	private void __logopen() {
	}

	private void __logprint(String s) {
	}

	private void __logclose() {
	}

	private void __puttrace() {
	}


	private int AttoParser_step(Object  $c)  throws java.io.IOException {
		switch(STATE) {
		case 0:
			if($c == null) {
				STATE = 1;
				return 1;
			} else if($c != null) {
				UNGET($c);
				STATE = 1;
				return 1;
			}
		case 1:
			if(Character.valueOf('(').equals($c)) {
			} else if("(".equals($c)) {
				STATE = 2;
				return 1;
			} else if("#(".equals($c)) {
				STATE = 3;
				return 1;
			} else if($c instanceof MT) {
				STATE = 4;
				return 1;
			} else if($c instanceof Object) {
				STATE = 5;
				return 1;
			}
			return 0;
		case 5:
			return 0;
		case 4:
				STATE = 6;
				return 1;
		case 6:
			if($c != null) {
				__stkpush(7, ENGINE_AttoParser);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		case 7:
				STATE = 8;
				return 1;
		case 8:
			return 0;
		case 3:
			if(Character.valueOf(')').equals($c)) {
			} else if(")".equals($c)) {
				STATE = 9;
				return 1;
			} else if($c == null) {
				STATE = 10;
				return 1;
			} else if($c != null) {
				UNGET($c);
				STATE = 10;
				return 1;
			}
		case 10:
			if($c != null) {
				__stkpush(11, ENGINE_AttoParser);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		case 11:
				STATE = 12;
				return 1;
		case 12:
			if(Character.valueOf(')').equals($c)) {
			} else if(")".equals($c)) {
				STATE = 13;
				return 1;
			} else if($c == null) {
				STATE = 10;
				return 1;
			} else if($c != null) {
				UNGET($c);
				STATE = 10;
				return 1;
			}
		case 13:
			return 0;
		case 9:
			return 0;
		case 2:
			if(Character.valueOf(')').equals($c)) {
			} else if(")".equals($c)) {
				STATE = 14;
				return 1;
			} else if($c == null) {
				STATE = 15;
				return 1;
			} else if($c != null) {
				UNGET($c);
				STATE = 15;
				return 1;
			}
		case 15:
			if($c != null) {
				__stkpush(16, ENGINE_AttoParser);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		case 16:
				STATE = 17;
				return 1;
		case 17:
			if(Character.valueOf(')').equals($c)) {
			} else if(")".equals($c)) {
				STATE = 18;
				return 1;
			} else if(Character.valueOf('.').equals($c)) {
			} else if(".".equals($c)) {
				STATE = 19;
				return 1;
			} else if($c == null) {
				STATE = 15;
				return 1;
			} else if($c != null) {
				UNGET($c);
				STATE = 15;
				return 1;
			}
		case 19:
			if($c != null) {
				__stkpush(20, ENGINE_AttoParser);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		case 20:
			if(Character.valueOf(')').equals($c)) {
			} else if(")".equals($c)) {
				STATE = 21;
				return 1;
			}
			return 0;
		case 21:
			return 0;
		case 18:
			return 0;
		case 14:
			return 0;
		}
		return 0;
	}

	private boolean AttoParser_accepted() {
		return (STATE == 0 ||
				STATE == 1 ||
				STATE == 18 ||
				STATE == 21 ||
				STATE == 5 ||
				STATE == 8 ||
				STATE == 9 ||
				STATE == 13 ||
				STATE == 14);
	}

	@SuppressWarnings("unchecked")
	int AttoParser_execaction(Object  $c) {
		switch(STATE) {
		case 6:
			break;
		case 14:
			// State37      
			_ = Cell.NIL;
			break;
		case 2:
			// lst                                      
			(__stv[__slen - 1][2]) = new java.util.ArrayList<Object>();
			break;
		case 11:
			break;
		case 8:
			// State17             
			_ = mta(((MT)(__stv[__slen - 1][4])), _);
			break;
		case 5:
			// State19     
			_ = unw($c);
			break;
		case 0:
			break;
		case 7:
			break;
		case 15:
			break;
		case 20:
			break;
		case 12:
			// State9        
			((java.util.List<Object>)(__stv[__slen - 1][3])).add(_);
			break;
		case 19:
			break;
		case 16:
			break;
		case 3:
			// vec                                      
			(__stv[__slen - 1][3]) = new java.util.ArrayList<Object>();
			break;
		case 1:
			// State8   
			_ = null;
			break;
		case 10:
			break;
		case 4:
			// meta      
			(__stv[__slen - 1][4]) = $c;
			break;
		case 18:
			// State6          
			_ = lst(((java.util.List<Object>)(__stv[__slen - 1][2])));
			break;
		case 13:
			// State10         
			_ = vec(((java.util.List<Object>)(__stv[__slen - 1][3])));
			break;
		case 17:
			// State5        
			((java.util.List<Object>)(__stv[__slen - 1][2])).add(_);
			break;
		case 21:
			// State13            
			_ = lst(((java.util.List<Object>)(__stv[__slen - 1][2])), _);
			break;
		case 9:
			// State38         
			_ = vec(((java.util.List<Object>)(__stv[__slen - 1][3])));
			break;
		}
		return 1;
	}

	boolean AttoParser_isend() {
		return (STATE == 17 ||
				STATE == 0 ||
				STATE == 16 ||
				STATE == 2 ||
				STATE == 3 ||
				STATE == 4 ||
				STATE == 7 ||
				STATE == 11 ||
				STATE == 12);
	}

	private final Engine ENGINE_AttoParser = new Engine() {

		int step(Object c) throws java.io.IOException {
			return AttoParser_step(c);
		}

		boolean accepted() {
			return AttoParser_accepted();
		}

		int execaction(Object c) {
			return AttoParser_execaction(c);
		}

		boolean isend() {
			return AttoParser_isend();
		}

		int recover(Exception e) {
			return -1;
		}

		int deadState() {
			return -1;
		}

		int stateSize() {
			return 22;
		}

		int finallyState() {
			return -1;
		}

		boolean isDead() {
		return (STATE == 18 ||
				STATE == 21 ||
				STATE == 5 ||
				STATE == 8 ||
				STATE == 9 ||
				STATE == 13 ||
				STATE == 14);
		}

		boolean isEmptyTransition() {
		return (STATE == 16 ||
				STATE == 4 ||
				STATE == 7 ||
				STATE == 11);
		}

		public String toString() {
			return "AttoParser";
		}

	};

	void __stkpush(int st, Engine en) {
		Object[][] c;
		Engine[] b;
		int[] a;

		if(__slen >= __sts.length) {
			a = new int[__sts.length * 2];
			b = new Engine[__stk.length * 2];
			c = new Object[__stk.length * 2][];
			System.arraycopy(__sts, 0, a, 0, __sts.length);
			System.arraycopy(__stk, 0, b, 0, __stk.length);
			System.arraycopy(__stv, 0, c, 0, __stv.length);
			__sts = a;
			__stk = b;
			__stv = c;
		}
		__sts[__slen] = st;
		__stk[__slen] = en;
		__stv[__slen++] = new Object[en.stateSize()];
	}

	private Object _parse(Object x, Boolean rt, boolean skip,
			int[] st) throws java.io.IOException {
		boolean b = false, p = skip;
		Object c = x;
		Engine en;
		int a;

		b = __stk[__slen - 1].accepted();
		if(rt.booleanValue()) {
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_ACCEPT:
				__logprint("accept " + __stk[__slen - 1]);
				st[0] = NINA_ACCEPT;  return null;
			case NINA_FAIL:
				__logprint("match failed: begin");
				__puttrace();
				st[0] = NINA_FAIL;  return null;
			case NINA_HALT_ACCEPT:
				__logprint("machine halted: begin");
				st[0] = NINA_HALT_ACCEPT;  return null;
			case NINA_HALT_REJECT:
				__logprint("machine halted: begin");
				st[0] = NINA_HALT_REJECT;  return null;
			case NINA_YIELD:
				__logprint("machine yielded: ", c);
				st[0] = NINA_YIELD;  return null;
			}
		}

		try {
			do {
				en = __stk[__slen - 1];
				if(p) {
					p = false;
				} else if((a = en.step(c)) > 0) {
					__logprint("transit to state " + STATE + ": ", c);
					b = en.accepted();
					switch(en.execaction(c)) {
					case NINA_ACCEPT:
						__logprint("accept " + __stk[__slen - 1]);
						UNGET(c);
						st[0] = NINA_ACCEPT;  return null;
					case NINA_FAIL:
						__logprint("match failed: ", c);
						__puttrace();
						UNGET(c);
						st[0] = NINA_FAIL;  return null;
					case NINA_HALT_ACCEPT:
						__logprint("machine halted: ", c);
						st[0] = NINA_HALT_ACCEPT;  return null;
					case NINA_HALT_REJECT:
						__logprint("machine halted: ", c);
						st[0] = NINA_HALT_REJECT;  return null;
					case NINA_YIELD:
						__logprint("machine yielded: ", c);
						st[0] = NINA_YIELD;  return null;
					}
				} else if(a < 0) {
					__logprint("entering " + __stk[__slen - 1]);
					return c;
				} else if(b) {
					__logprint("accept " + __stk[__slen - 1]);
					UNGET(c);
					st[0] = NINA_ACCEPT;  return null;
				} else if(c == null) {
					if(!b)  throw new TokenException();
					st[0] = NINA_ACCEPT;
					return null;
				} else {
					__logprint("match failed: ", c);
					__puttrace();
					UNGET(c);
					st[0] = NINA_FAIL;  return null;
				}

				if(__stk[__slen - 1].isEmptyTransition()) {
					// do nothing
				} else if(!__stk[__slen - 1].isDead()) {
					c = _read();
				} else if(b) {
					__logprint("accept " + __stk[__slen - 1]);
					st[0] = NINA_ACCEPT;  return null;
				} else {
					__logprint("match failed: ", c);
					__puttrace();
					st[0] = NINA_FAIL;  return null;
				}
			} while(true);
		} catch(RuntimeException e) {
			UNGET(c);
			throw e;
		}
	}

	private Boolean execfinally() {
		int a, b;

		if((a = __stk[__slen - 1].finallyState()) >= 0) {
			b = STATE;  STATE = a;
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_HALT_ACCEPT:
				__slen = 0;
				return Boolean.TRUE;
			case NINA_HALT_REJECT:
				__slen = 0;
				return Boolean.FALSE;
			}
			STATE = b;
		}
		return null;
	}

	private int getdeadstate() {
		return __stk[__slen - 1].deadState();
	}

	private int getrecover(Exception e) {
		return __stk[__slen - 1].recover(e);
	}

	boolean parse(Engine entry) throws java.io.IOException {
		Boolean b = Boolean.FALSE;
		int[] a = new int[1];
		boolean skip = true;
		Object c = 0;

		__logopen();
		try {
			if(__slen == 0) {
				b = Boolean.TRUE;
				__stkpush(0, entry);
			}

			ot: while(true) {
				try {
					if((c = _parse(c, b, skip, a)) != null) {
						skip = false;
					} else if(a[0] == NINA_FAIL) {
						while((STATE = getdeadstate()) < 0) {
							if((b = execfinally()) != null)  break ot;
							if(__slen-- <= 1) {
								throw new TokenException();
							}
						}
						skip = true;
					} else if(a[0] == NINA_HALT_ACCEPT) {
						if((b = execfinally()) != null)  break;
						__slen = 0;
						b = Boolean.TRUE;  break;
					} else if(a[0] == NINA_HALT_REJECT) {
						if((b = execfinally()) != null)  break;
						__slen = 0;
						b = Boolean.FALSE;  break;
					} else if(a[0] == NINA_YIELD) {
						return false;
					} else if(__slen > 1) {
						if((b = execfinally()) != null)  break;
						STATE = __sts[--__slen];
						skip = true;
					} else {
						if((b = execfinally()) != null)  break;
						b = new Boolean(__stk[--__slen].accepted());
						break;
					}
				} catch(RuntimeException e) {
					exception = e;
					if(__slen <= 0)  throw e;
					while((STATE = getrecover(e)) < 0) {
						if((b = execfinally()) != null)  return b;
						if(__slen-- <= 1)  throw e;
					}
				}
				b = Boolean.TRUE;
			}
			if(!b.booleanValue())  throw new TokenException();
			return b.booleanValue();
		} finally {
			__logclose();
		}
	}

	boolean parse(java.io.Reader rd) throws java.io.IOException {
		streamStack.push(rd);
		return parse(ENGINE_AttoParser);
	}

	static boolean parseAll(java.io.Reader rd) throws java.io.IOException {
		AttoParser o = new AttoParser();

		return o.parse(rd);
	}

	void setStream(java.io.Reader rd) {
		if(streamStack.size() == 0) {
			throw new IllegalStateException();
		}
		yieldObject = rd;
		streamStack.push(rd);
	}

	Object parseNext() throws java.io.IOException {
		Object o;

		if(streamStack.size() == 0) {
			throw new IllegalStateException();
		} else if(yieldObject == null) {
			return null;
		} else if(parse(ENGINE_AttoParser)) {
			if(yieldObject == null)  throw new NullPointerException();
			o = yieldObject;  yieldObject = null;
			return o;
		} else {
			if(yieldObject == null)  throw new NullPointerException();
			return yieldObject;
		}
	}

	static void puts(String s) {
		System.out.println(s);
	}

	boolean parse(java.io.InputStream rd) throws java.io.IOException {
		return parse(new java.io.InputStreamReader(rd));
	}

	static boolean parseAll(
			java.io.InputStream rd) throws java.io.IOException {
		return parseAll(new java.io.InputStreamReader(rd));
	}

	/* @@@-PARSER-CODE-END-@@@ */
	private static enum MT {

		QUOTE("quote"), BQ("quasiquote"), UNQ("unquote"),
		UNS("unquote-splicing"), QLAMBDA("lambda");

		private String name;

		private MT(String s) {
			name = s;
		}

		private static MT get(String s) {
			if(s.equals("'")) {
				return QUOTE;
			} else if(s.equals("`")) {
				return BQ;
			} else if(s.equals(",")) {
				return UNQ;
			} else if(s.equals(",@")) {
				return UNS;
			} else if(s.equals("^")) {
				return QLAMBDA;
			} else {
				throw new RuntimeException();
			}
		}

	}

	static class StringWrapper {
		String wrap;

		StringWrapper(String w) {
			wrap = w;
		}
	}

	private static Object sget(String s) {
		if(s.charAt(0) == ':') {
			return Keyword.get(s.substring(1));
		} else {
			return Symbol.get(s);
		}
	}

	private static Character ch1(String s) {
		return Character.valueOf(s.charAt(2));
	}

	private static Character chn(String s) {
		String x = s.substring(2);

		if(x.equals("newline")) {
			return Character.valueOf('\n');
		} else if(x.equals("space")) {
			return Character.valueOf(' ');
		} else {
			throw new TokenException();
		}
	}

	private static Object str(String s) {
		StringBuilder b = new StringBuilder();
		int c;

		for(int k = 1; k < s.length() - 1; k++) {
			c = s.charAt(k);
			if(c != '\\') {
				b.append((char)c);
			} else if(k == s.length() - 2) {
				b.append('\\');
			} else if(s.charAt(++k) != 'u' && s.charAt(k) != 'x') {
				switch(s.charAt(k)) {
				case '"':  case '\\':  case '/':
					b.append(s.charAt(k));
					break;
				case 'a':  b.append('\u0007');  break;
				case 'b':  b.append('\b');  break;
				case 't':  b.append('\t');  break;
				case 'n':  b.append('\n');  break;
				case 'v':  b.append('\u000b');  break;
				case 'f':  b.append('\f');  break;
				case 'r':  b.append('\r');  break;
				default:   throw new TokenException();
				}
			} else {
				StringBuilder b2 = new StringBuilder();
				int x;

				while(++k < s.length() - 1) {
					c = s.charAt(k);
					if((c >= '0' && c <= '9') ||
							(c >= 'a' && c <= 'f') ||
							(c >= 'A' && c <= 'F')) {
						b2.append(s.charAt(k));
					} else {
						break;
					}
				}

				if(b2.length() == 0) {
					throw new TokenException();
				} else {
					x = Integer.parseInt(b2.toString(), 16);
					if(x > Character.MAX_VALUE) {
						throw new TokenException();
					} else {
						b.append((char)x);
					}
				}
			}
		}
		return new StringWrapper(b.toString());
	}

	public static final Object NULL = new Object();
	private static Object shp(String s) {
		String x = s.substring(1);

		if(x.equals("t")) {
			return Boolean.TRUE;
		} else if(x.equals("f")) {
			return Boolean.FALSE;
		} else if(x.equals("null")) {
			return NULL;
		} else {
			throw new TokenException();
		}
	}

	private static final Pattern CMP = Pattern.compile(
			"([\\-+]?.*)([\\-+].*)i");
	private static Double[] cmp(String s) {
		Matcher m;
		Double r, i;

		if((m = CMP.matcher(s)).matches()) {
			r = Double.valueOf(m.group(1));
			i = Double.valueOf(m.group(2));
		} else {
			r = new Double(0);
			i = Double.valueOf(s.substring(0, s.length() - 1));
		}
		return new Double[] { r, i };
	}

	private static final Pattern REG = Pattern.compile(
			"#/(([^/\\\\]|\\\\.)+)/(.*)");
	private static RegexWrapper reg(String s) {
		Matcher m;

		if(!(m = REG.matcher(s)).matches()) {
			throw new TokenException();
		} else if(m.group(3) == null || m.group(3).equals("")) {
			return new RegexWrapper(m.group(1), "");
		} else {
			return new RegexWrapper(m.group(1), m.group(3));
		}
	}

	private static Double dbl(String s) {
		return Double.valueOf(s);
	}

	private static Object toint(BigInteger x) {
		return AttoUtils.toObject(x);
	}

	private static Object bin(String s) {
		return toint(new BigInteger(s.substring(2), 2));
	}

	private static Object oct(String s) {
		return toint(new BigInteger(s.substring(2), 8));
	}

	private static Object _int(String s) {
		return toint(new BigInteger(s));
	}

	private static Object hex(String s) {
		return toint(new BigInteger(s.substring(2), 16));
	}

	private static Object unw(Object o) {
		return o;
	}

	private static Object mta(MT m, Object o) {
		if(m == MT.QLAMBDA) {
			return new Cell(Symbol.get(m.name),
					new Cell(Cell.NIL, new Cell(o, Cell.NIL)));
		} else {
			return new Cell(Symbol.get(m.name), new Cell(o, Cell.NIL));
		}
	}

	private static Object lst(java.util.List<Object> l, Object d) {
		Cell r, c;

		if(l.size() > 0) {
			r = c = null;
			for(Object o : l) {
				if(r == null) {
					r = c = new Cell(null, null);
				} else {
					c.cdr = new Cell(null, null);
					c = (Cell)c.cdr;
				}
				c.car = o;
			}
			c.cdr = d;
			return r;
		} else {
			return d;
		}
	}

	private static Object lst(java.util.List<Object> l) {
		return lst(l, Cell.NIL);
	}

	private static Object vec(java.util.List<Object> l) {
		return l;
	}

	/**
	 * 
	 * @param o
	 */
	public static boolean isInvaild(Object o) {
		return o == INVALIDTOKEN;
	}

	/**
	 * read from the given reader.
	 * 
	 * @return parsed objects
	 * @throws java.io.IOException
	 */
	public static Object read(Reader rd) throws java.io.IOException {
		AttoParser p;

		try {
			p = new AttoParser();
			p.parse(rd);
			return p._;
		} catch(TokenException e) {
			throw new ReaderException(e);
		}
	}

}
