/*
 * Copyright (c) 2015, Yuichiro MORIGUCHI
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the Yuichiro MORIGUCHI nor the names of its contributors 
 *   may be used to endorse or promote products derived from this software 
 *   without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Yuichiro MORIGUCHI BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var $mille={};var $env;if(!Function.prototype.bind){Function.prototype.bind=function(a){if(typeof this!=="function"){throw $mille.o.error("Function.prototype.bind - what is trying to be bound is not callable")}var f,e,c,d;f=Array.prototype.slice.call(arguments,1),e=this,c=function(){},d=function(){return e.apply(this instanceof c?this:a,f.concat(Array.prototype.slice.call(arguments)))};c.prototype=this.prototype;d.prototype=new c();return d}}$mille.a={};$mille.a.toArray=function(e){var a,c,d;a=arguments.length>1?arguments[1]:0;d=arguments.length>2?arguments[2].concat():[];for(c=a;c<e.length;c+=1){d.push(e[c])}return d};$mille.a.isArray=function(a){return(a&&typeof a==="object"&&a.constructor===Array)};$mille.a.fold=function(h,d,c){var e,g;g=c;for(e=0;e<d.length;e+=1){g=h(d[e],g)}return g};$mille.o={};$mille.o.isFunction=function(a){return(typeof a==="function")};$mille.o.isString=function(a){return(typeof a==="string")};$mille.o.isNumber=function(a){return(typeof a==="number")};$mille.o.isInteger=function(a){return(typeof a==="number"&&isFinite(a)&&a>-9007199254740992&&a<9007199254740992&&Math.floor(a)===a)};$mille.o.isObject=function(a){return(a instanceof Object&&!(a instanceof Array))};$mille.o.hasProperty=function(a){return a instanceof Object};$mille.o.error=function(a){throw a};$mille.o.mapEntries=function(e,d){var a=null,c;c=[];for(a in e){if(e.hasOwnProperty(a)){c.push(d(a,e[a]))}}return c};$mille.o.keys=function(a){return $mille.o.mapEntries(a,function(d,c){return d})};$mille.o.values=function(a){return $mille.o.mapEntries(a,function(d,c){return c})};$mille.o.entries=function(a){return $mille.o.mapEntries(a,function(d,c){return{key:d,value:c}})};$mille.r={};$mille.r.isNaN=function(a){return a!==a};$mille.r.isFinite=function(a){return isFinite(a)};$mille.r.isInfinite=function(a){return a===Infinity||a===-Infinity};$mille.r.hypot=function(a,c){return Math.sqrt(a*a+c*c)};$mille.r.sinh=function(a){return(Math.exp(a)-Math.exp(-a))/2};$mille.r.cosh=function(a){return(Math.exp(a)+Math.exp(-a))/2};$mille.r.tanh=function(a){return $mille.r.sinh(a)/$mille.r.cosh(a)};$mille.r.gcd=function(e,h){var f,d,g;if(e===0||h===0){return 0}else{d=Math.abs(e>h?e:h);g=Math.abs(e>h?h:e);do{f=d;d=g;g=f-d*Math.floor(f/d)}while(g!==0);return d}};$mille.f={};$mille.f.K=function(a){return a};$mille.c={};$mille.c.make=function(c,a){var d=new Datum("complex");var e=function(){return c===0&&a===0};d.getReal=function(){return c};d.getImag=function(){return a};d.getMagnitude=function(){return $mille.r.hypot(c,a)};d.getMagnitude2=function(){return c*c+a*a};d.getAngle=function(){return Math.atan2(a,c)};d.isReal=function(){return a===0};d.isNaN=function(){return $mille.r.isNaN(c)||$mille.r.isNaN(a)};d.isZero=function(){return e()};d.isOne=function(){return c===1&&a===0};d.add=function(f){return $mille.c.make(c+f.getReal(),a+f.getImag())};d.subtract=function(f){return $mille.c.make(c-f.getReal(),a-f.getImag())};d.multiply=function(f){return $mille.c.make(c*f.getReal()-a*f.getImag(),c*f.getImag()+a*f.getReal())};d.divide=function(f){var g;if(f.isZero()){return $mille.c.make(NaN,NaN)}else{g=f.getMagnitude2();return $mille.c.make((c*f.getReal()+a*f.getImag())/g,(a*f.getReal()-c*f.getImag())/g)}};d.equals=function(f){return c===f.getReal()&&a===f.getImag()};d.exp=function(){return $mille.c.make(Math.exp(c)*Math.cos(b),Math.exp(c)*Math.sin(b))};d.log=function(){var g,f;if(e()){return $mille.c.make(-Infinity,-Math.PI/2)}else{g=$mille.r.hypot(c,a);f=Math.atan2(a,c);return $mille.c.make(Math.log(g),f)}};d.sin=function(){var g,f;if(c===0){return $mille.c.make(0,$mille.r.sinh(a))}else{g=Math.sin(c)*$mille.r.cosh(a);f=Math.cos(c)*$mille.r.sinh(a);return $mille.c.make(g,f)}};d.cos=function(){var g,f;if(c===0){return $mille.c.make($mille.r.cosh(a),0)}else{g=Math.cos(c)*$mille.r.cosh(a);f=-(Math.sin(c)*$mille.r.sinh(a));return $mille.c.make(g,f)}};d.tan=function(){var f,g;if(c===0){return $mille.c.make(0,$mille.r.tanh(a))}else{if(a===Infinity){f=$mille.c.make(Math.tan(c),1);g=$mille.c.make(1,Math.tan(c));return f.divide(g)}else{if(a===-Infinity){f=$mille.c.make(Math.tan(c),-1);g=$mille.c.make(-1,-Math.tan(c));return f.divide(g)}else{return d.sin().div(d.cos())}}}};d.expt=function(j){var f,h,g,i;if(e()){return $mille.c.make(0,0)}else{if(j.isZero()){return $mille.c.make(1,0)}else{if(d.isOne()){return $mille.c.make(1,0)}else{if(j.isOne()){return d}else{f=$mille.r.hypot(c,a);h=Math.atan2(a,c);g=j.getReal()*Math.log(f)-h*j.getImag();i=j.getImag()*Math.log(f)+h*j.getReal();return $mille.c.make(Math.exp(g)*Math.cos(i),Math.exp(g)*Math.sin(i))}}}}};d.sqrt=function(){if(c>=0&&a===0){return $mille.c.make(Math.sqrt(c),0,0)}else{return d.expt($mille.c.make(0.5,0))}};d.asin=function(){var h,g,f;if(a===0&&c>=-1&&c<=1){return $mille.c.make(Math.asin(c),0)}else{if(c===Infinity){if(y<=0){return $mille.c.make(Math.PI/2,c)}else{return $mille.c.make(Math.PI/2,-c)}}else{if(c===-Infinity){if(y<=0){return $mille.c.make(-Math.PI/2,c)}else{return $mille.c.make(-Math.PI/2,-c)}}else{if(a===Infinity||a===-Infinity){return $mille.c.make(0,a)}else{h=$mille.c.I.multiply(d);g=$mille.c.ONE.subtract(d.multiply(d)).sqrt();f=h.add(g).log();return $mille.c.make(f.getImag(),-f.getReal())}}}}};d.acos=function(){if(a===0&&x>=-1&&x<=1){return $mille.c.make(Math.acos(x),0)}else{return $mille.c.HALFPI.subtract(d.asin())}};d.atan=function(){var h,g,f;if(a===0){return $mille.c.make(Math.atan(c),0)}else{if(a===Infinity||a===-Infinity){if(c===Infinity||c===-Infinity){return $mille.c.NaN}else{if(a>0){return $mille.c.make(Math.PI/2)}else{return $mille.c.make(-Math.PI/2)}}}else{if(c===0&&a===1){return $mille.c.make(0,Infinity)}else{if(c===0&&a===-1){return $mille.c.make(0,-Infinity)}else{h=$mille.c.ONE.add($mille.c.I.multiply(d));g=$mille.c.ONE.subtract($mille.c.I.multiply(d));f=h.log().subtract(g.log());return f.divide($mille.c.TWO_I)}}}}};return d};$mille.c.HALFPI=$mille.c.make(Math.PI/2);$mille.c.TWO_I=$mille.c.make(0,2);$mille.c.ZERO=$mille.c.make(0,0);$mille.c.ONE=$mille.c.make(1,0);$mille.c.I=$mille.c.make(0,1);$mille.c.NaN=$mille.c.make(NaN,NaN);$mille.c.isComplex=function(a){return $mille.datumTypeOf(a,"complex")};$mille.c.toComplex=function(a){if($mille.o.isNumber(a)){return $mille.c.make(a,0)}else{return a}};$mille.c.equals=function(c,a){if($mille.o.isComplex(c)&&$mille.o.isComplex(a)){return(c.getReal()==a.getReal()&&c.getImag()==a.getImag())}else{return c===a}};$mille.c.isNaN=function(a){if($mille.o.isNumber(a)){return $mille.r.isNaN(a)}else{if($mille.c.isComplex(a)){return($mille.r.isNaN(a.getReal())||$mille.r.isNaN(a.getImag()))}else{return false}}};$mille.c.isFinite=function(a){if($mille.o.isNumber(a)){return $mille.r.isFinite(a)}else{if($mille.c.isComplex(a)){return($mille.r.isFinite(a.getReal())&&$mille.r.isFinite(a.getImag()))}else{return false}}};$mille.c.isInfinite=function(a){if($mille.o.isNumber(a)){return $mille.r.isInfinite(a)}else{if($mille.c.isComplex(a)){return($mille.r.isInfinite(a.getReal())||$mille.r.isInfinite(a.getImag()))}else{return false}}};$mille.c.getReal=function(a){return $mille.o.isNumber(a)?a:a.getReal()};$mille.c.getImag=function(a){return $mille.o.isNumber(a)?0:a.getImag()};$mille.c.magnitude=function(a){return $mille.o.isNumber(a)?Math.abs(a):a.getMagnitude()};$mille.c.angle=function(a){if(!$mille.o.isNumber(a)){return a.getAngle()}else{if(a>=0){return 0}else{return Math.PI}}};$mille.c.add=function(e,a){var d,c;if($mille.o.isNumber(e)&&$mille.o.isNumber(a)){return e+a}d=$mille.c.toComplex(e);c=$mille.c.toComplex(a);return d.add(c)};$mille.c.subtract=function(e,a){var d,c;if($mille.o.isNumber(e)&&$mille.o.isNumber(a)){return e-a}d=$mille.c.toComplex(e);c=$mille.c.toComplex(a);return d.subtract(c)};$mille.c.multiply=function(e,a){var d,c;if($mille.o.isNumber(e)&&$mille.o.isNumber(a)){return e*a}d=$mille.c.toComplex(e);c=$mille.c.toComplex(a);return d.multiply(c)};$mille.c.divide=function(e,a){var d,c;if($mille.o.isNumber(e)&&$mille.o.isNumber(a)){return e/a}d=$mille.c.toComplex(e);c=$mille.c.toComplex(a);return d.divide(c)};$mille.c.equals=function(e,a){var d,c;if($mille.o.isNumber(e)&&$mille.o.isNumber(a)){return e===a}d=$mille.c.toComplex(e);c=$mille.c.toComplex(a);return d.equals(c)};$mille.c.notEquals=function(c,a){return !$mille.c.equals(c,a)};$mille.c.exp=function(a){if($mille.o.isNumber(a)){return Math.exp(a)}else{return a.exp()}};$mille.c.log=function(a){if($mille.o.isNumber(a)&&a>0){return Math.log(a)}else{return a.log()}};$mille.c.sin=function(a){if($mille.o.isNumber(a)){return Math.sin(a)}else{return a.sin()}};$mille.c.cos=function(a){if($mille.o.isNumber(a)){return Math.sin(a)}else{return a.cos()}};$mille.c.tan=function(a){if($mille.o.isNumber(a)){return Math.tan(a)}else{return a.tan()}};$mille.c.expt=function(c,a){if($mille.o.isNumber(c)&&$mille.o.isNumber(a)){return Math.pow(c,a)}else{return c.expt(a)}};$mille.c.sqrt=function(a){if($mille.o.isNumber(a)&&a>=0){return Math.sqrt(a)}else{return a.sqrt()}};$mille.c.asin=function(a){if($mille.o.isNumber(a)&&a>=-1&&a<=1){return Math.asin(a)}else{return a.asin()}};$mille.c.acos=function(a){if($mille.o.isNumber(a)&&a>=-1&&a<=1){return Math.acos(a)}else{return a.acos()}};$mille.c.atan=function(a){if($mille.o.isNumber(a)){return Math.atan(a)}else{return a.atan()}};function Datum(a){this.typ=function(){return a}}Datum.prototype.toString=function(){var a;a=this[this.typ()+"ToString"];if(a===undefined){return"#<"+this.typ()+">"}else{return a.call(this)}};Datum.prototype.symbolToString=function(){return this.name};Datum.prototype.keywordToString=function(){return":"+this.name};Datum.prototype.complexToString=function(){if(this.getImag()>0){return this.getReal()+"+"+this.getImag()+"i"}else{if(this.getImag()<0){return this.getReal()+""+this.getImag()+"i"}else{return this.getReal()+""}}};$mille.datumTypeOf=function(c,a){return((c instanceof Datum)&&c.typ()===a)};$mille.createMemo=function(){return{index:[],value:[]}};$mille.searchMemo=function(a,d){var c;for(c=0;c<a.index.length;c++){if(a.index[c]===d){return a.value[c]}}return undefined};$mille.setMemo=function(c,e,a){var d;for(d=0;d<c.index.length;d++){if(c.index[d]===e){c.value[d]=a}}c.index.push(e);c.value.push(a)};$mille.walkPair=function(f,d,e){var g,a=$mille.searchMemo(d,f);if(a===-1){$mille.setMemo(d,f,e);return e+1}else{if(a>0){return e}else{if($mille.isPair(f)){$mille.setMemo(d,f,-1);g=$mille.walkPair(f.car,d,e);g=$mille.walkPair(f.cdr,d,g);return g}else{return e}}}};$mille.cellToString=function(g,c,f){var h=g,d,e,a;if($mille.isAtom(h)){return h.toString()}else{if($mille.isNull(h)){return"()"}else{a=$mille.searchMemo(c,h);if(a===undefined||a===-1){d="("}else{if($mille.searchMemo(f,h)){return"#"+a+"#"}else{$mille.setMemo(f,h,true);d="#"+a+"=("}}for(e=0;true;e++){if($mille.isAtom(h)){if(e>0){d+=" "}d+=". "+h.toString()+")";return d}else{if($mille.isNull(h)){d+=")";return d}else{if(e>0){d+=" "}d+=$mille.cellToString(h.car,c,f);h=h.cdr;if($mille.searchMemo(f,h)){d+=" . #"+$mille.searchMemo(c,h)+"#)";return d}}}}}}};Datum.prototype.cellToString=function(){var a=$mille.createMemo(),c=$mille.createMemo();$mille.walkPair(this,a,1);return $mille.cellToString(this,a,c)};$mille.cons=function(f,e){var a;a=new Datum("cell");a.car=f;a.cdr=e;a.isNull=function(){return a.car===null};return a};$mille.nil=$mille.cons(null,null);$mille.isNull=function(a){return($mille.datumTypeOf(a,"cell")&&a.isNull())};$mille.isPair=function(a){return($mille.datumTypeOf(a,"cell")&&!a.isNull())};$mille.isAtom=function(a){return !$mille.datumTypeOf(a,"cell")};$mille.car=function(a){if($mille.datumTypeOf(a,"cell")&&a.car!==null){return a.car}else{$mille.o.error("Not cons: "+a)}};$mille.cdr=function(a){if($mille.datumTypeOf(a,"cell")&&a.cdr!==null){return a.cdr}else{$mille.o.error("Not cons: "+a)}};$mille.setCar=function(c,a){if($mille.datumTypeOf(c,"cell")&&c.car!==null){c.car=a;return undefined}else{$mille.o.error("Not cons: "+c)}};$mille.setCdr=function(c,a){if($mille.datumTypeOf(c,"cell")&&c.car!==null){c.cdr=a;return undefined}else{$mille.o.error("Not cons: "+c)}};$mille.listToCell=function(g){var a,h,f,e=undefined;if(!$mille.a.isArray(g)){return g}else{if(g.length>0){for(a=0;a<g.length;a+=1){f=$mille.cons($mille.listToCell(g[a]),$mille.nil);if(e===undefined){e=f}else{h.cdr=f}h=f}return e}else{return $mille.nil}}};$mille.cellToList=function(d,e){var c=[],f;f=e!==undefined?e:function(a){$mille.o.error("Not proper list: "+a)};while(true){if(!$mille.datumTypeOf(d,"cell")){return f(d)}else{if(d.isNull()){return c}else{c.push($mille.cellToList(d.car,function(a){return a}));d=d.cdr}}}};$mille.shallowCellToList=function(d,e){var c=[],f;f=e!==undefined?e:function(a){$mille.o.error("Not proper list: "+a)};while(true){if(!$mille.datumTypeOf(d,"cell")){return f(d)}else{if(d.isNull()){return c}else{c.push(d.car);d=d.cdr}}}};$mille.trampoline=function(a){return new Trampoline(a)};$mille.closure=function(d,a,c){return function(){var e=$mille.newenv(d,a);return c.apply(a,$mille.a.toArray(arguments,0,[e]))}};$mille.applya=function(d,c){if($mille.o.isFunction(d)){return d.apply(null,c)}};$mille.apply=function(d){var c;c=$mille.a.toArray(arguments,1);return $mille.applya(d,c)};$mille.applyCell=function(e,d){var c;c=$mille.cellToList(d);return $mille.applya(e,c)};$mille.newenv=function(g,d){var h={},f={},a,c;a=function(m,j,o){var l=m,k,e;e=o===undefined?0:o;for(k=e;k<j.length;k++){if((l=l[j[k]])===undefined){return l}}return l};c=function(m,j,o){var l=m,k,e;e=o===undefined?0:o;for(k=e;k<j.length-1;k++){if(!$mille.o.hasProperty(l=l[j[k]])){return l}}return l};h.find=function(j){var e,i;i=j.split(".");if(f["$"+i[0]]!==undefined){return a(f["$"+i[0]],i,1)}else{if(g!==undefined&&g!==null){return g.find(j)}else{if((e=a(d,i))!==undefined){return e}else{if((e=a($mille.global,i))!==undefined){return e}else{$mille.o.error("Unbound: "+j)}}}}};h.bind=function(e,i){f["$"+e]=i};h.set=function(j,m){var e,l,k;e=j.split(".");if(f["$"+e[0]]!==undefined){if(e.length===1){f["$"+e[0]]=m}else{l=c(f["$"+e[0]],e,1);if(!$mille.o.hasProperty(l)){$mille.o.error("Undefined Symbol "+j)}else{l[e[e.length-1]]=m}}}else{if(g!==undefined&&g!==null){g.set(j,m)}else{if($mille.o.hasProperty(l=c(d,e))){l[e[e.length-1]]=m}else{if($mille.o.hasProperty(l=c(d,e))){l[e[e.length-1]]=m}else{$mille.o.error("Undefined Symbol "+j)}}}}};h.apply=function(j,i){var e;e=h.find(j);if($mille.o.isFunction(e)){return e.apply(null,i)}else{$mille.o.error("Found no functions")}};h.call=function(e){return h.apply(e,$mille.a.toArray(arguments,1))};h.closure=function(e){return $mille.closure(h,d,e)};return h};$mille.applyObject=function(a,d){var c,e;if($mille.o.isFunction(c=d[a])){e=c.apply(d,$mille.a.toArray(arguments,2));return e}else{$mille.o.error("undefined property: "+a)}};$mille.getGlobal=function(){$mille.global=this};$mille.getGlobal();$mille.checkNumber=function(a){if(!$mille.isComplex(a)){$mille.o.error("the type of the object is not number:"+a)}};$mille.checkReal=function(a){if(!$mille.o.isNumber(a)){$mille.o.error("the type of the object is not real number:"+a)}};$mille.checkNonnegativeReal=function(a){if(!$mille.o.isNumber(a)||a<0){$mille.o.error("the type of the object is not non-negative real number:"+a)}};$mille.checkInteger=function(a){if(!$mille.o.isInteger(a)){$mille.o.error("the type of the object is not integer:"+a)}};$mille.checkNaturalNumber=function(a,c){if(!$mille.o.isInteger(a)||a<c){$mille.o.error("the type of the object is not natural number:"+a)}};$mille.checkString=function(a){if(!$mille.o.isString(a)){$mille.o.error("the type of the object is not string:"+a)}};$mille.checkLength=function(a,c){if(c<0||c>=a.length){$mille.o.error("Argument out of range:"+c)}};$mille.checkVector=function(a){if(!$mille.a.isArray(a)){$mille.o.error("the type of the object is not vector:"+a)}};$mille.checkList=function(a){if(!$mille.isPair(a)&&!$mille.isNull(a)){$mille.o.error("the type of the object is not list:"+a)}};$mille.checkInteger=function(a){if(!$mille.o.isInteger(a)){$mille.o.error("the type of the object is not integer:"+a)}};$mille.checkZero=function(a){if(a===0){$mille.o.error("divide by zero")}};$mille.checkObject=function(a){if(!$mille.o.isObject(a)){$mille.o.error("the type of the object is not object:"+a)}};$mille.checkSymbol=function(a){if(!$mille.datumTypeOf(a,"symbol")){$mille.o.error("the type of the object is not symbol:"+a)}};$mille.checkCharacter=function(a){if(!$mille.o.isInteger(a)||a<0||a>65535){$mille.o.error("the type of the object is not character:"+a)}};$mille.checkFunction=function(a){if(!$mille.o.isFunction(a)){$mille.o.error("the type of the object is not function:"+a)}};$mille.checkPromise=function(a){if(!$mille.datumTypeOf(a,"promise")){$mille.o.error("the type of the object is not promise:"+a)}};$mille.compare=function(d,a){var c;if(a===undefined){c=function(e){return true}}else{c=a}return function(){var f,e=null;for(f=0;f<arguments.length;f++){c(arguments[f]);if(e===null||d(e,arguments[f])){e=arguments[f]}else{return false}}return true}};$mille.compareNumber=function(a){return $mille.compare(a,$mille.checkReal)};$mille.eq=$mille.compare(function(a,c){return a===c});$mille.eqv=$mille.compare(function(a,c){if($mille.c.isComplex(a)&&$mille.c.isComplex(c)){return $mille.c.equals(a,c)}else{return a===c}});$mille.arith1=function(a,c){return function(){var e,d=c;for(e=0;e<arguments.length;e++){$mille.checkNumber(arguments[e]);d=a(d,arguments[e])}return d}};$mille.arith2=function(c,a){return function(){var e,d=undefined;if(arguments.length<1){$mille.o.error("Too few arguments")}else{if(arguments.length===1){return a(arguments[0])}else{d=arguments[0];for(e=1;e<arguments.length;e++){$mille.checkNumber(arguments[e]);d=c(d,arguments[e])}}}return d}};$mille.unary=function(a){return function(c){$mille.checkNumber(c);return a(c)}};$mille.substring=function(a,d,c){$mille.checkString(a);$mille.checkInteger(d);$mille.checkInteger(c);return a.substring(d,c)};$mille.stringRef=function(a,c){$mille.checkString(a);$mille.checkInteger(c);$mille.checkLength(a,c);return a.charCodeAt(c)};$mille.stringLength=function(a){$mille.checkString(a);return a.length};$mille.stringAppend=function(){var c,a="";for(c=0;c<arguments.length;c++){a+=arguments[c].toString()}return a};$mille.isString=function(a){return $mille.o.isString(a)};$mille.makeString=function(a,f){var g,e,d="";$mille.checkNaturalNumber(a,0);if(f!==undefined){$mille.checkCharacter(f)}g=String.fromCharCode(f===undefined?32:f);for(e=0;e<a;e++){d+=g}return d};$mille.string=function(){var c,a="";for(c=0;c<arguments.length;c++){$mille.checkCharacter(arguments[c]);a+=String.fromCharCode(arguments[c])}return a};$mille.compareString=function(a){return $mille.compare(a,$mille.checkString)};$mille.compareStringCi=function(a){return $mille.compare(function(d,f){var e=d.toUpperCase();var c=f.toUpperCase();return a(e,c)},$mille.checkString)};$mille.stringToList=function(f){var e,a,h,g,d=undefined;$mille.checkString(f);for(e=0;e<f.length;e++){a=f.charCodeAt(e);h=$mille.cons(a,$mille.nil);if(d===undefined){d=h}else{g.cdr=h}g=h}return d};$mille.listToString=function(a){var e,c,d="";$mille.checkList(a);c=$mille.cellToList(a);for(e=0;e<c.length;e++){$mille.checkCharacter(c[e]);d+=String.fromCharCode(c[e])}return d};$mille.symbols={};$mille.getSymbol=function(c){var a;a=$mille.symbols[c];if(a===undefined){a=new Datum("symbol");a.name=c;$mille.symbols[c]=a}return a};$mille.isSymbol=function(a){return $mille.datumTypeOf(a,"symbol")};$mille.stringToSymbol=function(a){$mille.checkString(a);return $mille.getSymbol(a)};$mille.symbolToString=function(a){$mille.checkSymbol(a);return a.name};$mille.keywords={};$mille.getKeyword=function(c){var a;a=$mille.keywords[c];if(a===undefined){a=new Datum("keyword");a.name=c;$mille.keywords[c]=a}return a};$mille.isKeyword=function(a){return $mille.datumTypeOf(a,"keyword")};$mille.isVector=function(a){return $mille.a.isArray(a)};$mille.makeVector=function(a,e){var d=[],c;for(c=0;c<a;c++){d.push(e)}return d};$mille.vector=function(){return $mille.a.toArray(arguments)};$mille.vectorLength=function(a){$mille.checkVector(a);return a.length};$mille.vectorRef=function(c,a){$mille.checkVector(c);$mille.checkLength(c,a);return c[a]};$mille.vectorSet=function(c,a,d){$mille.checkVector(c);$mille.checkLength(c,a);c[a]=d;return undefined};$mille.vectorToList=function(a){$mille.checkVector(a);return $mille.listToCell(a)};$mille.listToVector=function(a){$mille.checkList(a);return $mille.cellToList(a)};$mille.vectorFill=function(a,d){var c;$mille.checkVector(a);for(c=0;c<a.length;c++){a[c]=d}return undefined};$mille.numberToString=function(a){$mille.checkNumber(a);return a.toString()};$mille.stringToNumber=function(c){var f,e,d;$mille.checkString(c);f=/([\-+]?(?:[0-9]*\.[0-9]+|[0-9]+)(?:[eE][\-+]?[0-9]+)?)(?:([\-+](?:[0-9]*\.[0-9]+|[0-9]+)(?:[eE][\-+]?[0-9]+)?)i)?/;e=c.match(f);d=parseFloat(e[1]);if(e[0]===null){return false}else{if(e[2]===undefined){return d}else{return $mille.c.make(d,parseFloat(e[2]))}}};$mille.isProcedure=function(a){return $mille.o.isFunction(a)};$mille.not=function(a){return a===false?true:false};$mille.isBoolean=function(a){return a===true||a===false};$mille.isNumber=function(a){return $mille.isComplex(a)};$mille.isReal=function(a){return $mille.o.isNumber(a)};$mille.isInteger=function(a){return $mille.o.isInteger(a)};$mille.isExact=function(a){return $mille.o.isInteger(a)};$mille.isInexact=function(a){return !$mille.isExact(a)};$mille.abs=function(a){$mille.checkReal(a);return Math.abs(a)};$mille.quotient=function(a,d){var c;$mille.checkInteger(a);$mille.checkInteger(d);$mille.checkZero(d);c=a/d;return c>0?Math.floor(c):Math.ceil(c)};$mille.remainder=function(a,c){$mille.checkInteger(a);$mille.checkInteger(c);$mille.checkZero(c);return a%c};$mille.modulo=function(a,c){$mille.checkInteger(a);$mille.checkInteger(c);$mille.checkZero(c);if(a===0){return 0}else{if(a>0&&c>0){return a%c}else{if(a<0&&c<0){return -((-a)%(-c))}else{if(a<0&&c>0){return(a%c)+c}else{return(a%c)-c}}}}};$mille.gcd=function(){var c,d;if(arguments.length===0){return 0}else{$mille.checkNumber(arguments[0]);c=arguments[0];for(d=1;d<arguments.length;d++){$mille.checkNumber(arguments[d]);c=$mille.r.gcd(c,arguments[d])}return c}};$mille.lcm=function(){var d,c=1,a;d=$mille.gcd.apply(null,arguments);for(a=0;a<arguments.length;a++){c*=Math.abs(arguments[a])/d}return c*d};$mille.floor=function(a){$mille.checkReal(a);return Math.floor(a)};$mille.ceiling=function(a){$mille.checkReal(a);return Math.ceil(a)};$mille.truncate=function(a){$mille.checkReal(a);return a>0?Math.floor(a):Math.ceil(a)};$mille.round=function(a){$mille.checkReal(a);return Math.round(a)};$mille.isObject=function(a){return $mille.o.isObject(a)};$mille.objectRef=function(c,a){$mille.checkObject(c);return c[a]};$mille.objectSet=function(d,c,a){$mille.checkObject(d);d[c]=a;return undefined};$mille.objectKeys=function(a){$mille.checkObject(a);return $mille.listToCell($mille.o.keys(a))};$mille.objectValues=function(a){$mille.checkObject(a);return $mille.listToCell($mille.o.values(a))};$mille.objectToList=function(e){var c,d;if($mille.a.isArray(e)){c=[];for(d=0;d<e.length;d++){c[d]=$mille.objectToList(e[d])}return $mille.listToCell(c)}else{if($mille.o.isObject(e)){c=$mille.o.entries(e);for(d=0;d<c.length;d++){c[d]=$mille.cons($mille.objectToList(c[d].key),$mille.objectToList(c[d].value))}return $mille.listToCell(c)}else{return e}}};$mille.isEqual=function(e,d){var c,a=null;if($mille.isPair(e)){if($mille.isPair(d)){return($mille.isEqual(e.car,d.car)&&$mille.isEqual(e.cdr,d.cdr))}else{return false}}else{if($mille.isNull(e)){return $mille.isNull(d)}else{if($mille.a.isArray(e)){if(!$mille.a.isArray(d)){return false}else{if(e.length!==d.length){return false}else{for(c=0;c<e.length;c++){if(!$mille.isEqual(e[c],d[c])){return false}}return true}}}else{if($mille.o.isObject(e)){for(a in e){if(!e.hasOwnProperty(a)){}else{if(!d.hasOwnProperty(a)){return false}else{if(!$mille.isEqual(e[a],d[a])){return false}}}}return true}else{return e===d}}}}};$mille.isChar=function(a){return $mille.o.isInteger(a)&&a>=0&&a<65536};$mille.charUpcase=function(d){var a;$mille.checkCharacter(d);a=String.fromCharCode(d);a=a.toUpperCase();return a.charCodeAt(0)};$mille.charDowncase=function(d){var a;$mille.checkCharacter(d);a=String.fromCharCode(d);a=a.toUpperCase();return a.charCodeAt(0)};$mille.compareCharacter=function(a){return $mille.compare(a,$mille.checkCharacter)};$mille.compareCharacterCi=function(a){return $mille.compare(function(d,f){var e=$mille.charUpcase(d);var c=$mille.charUpcase(f);return a(e,c)},$mille.checkCharacter)};$mille.charToInteger=function(a){$mille.checkCharacter(a);return a};$mille.integerToChar=function(a){$mille.charToInteger(a);if(a<0||a>65535){$mille.o.error("character out of range:"+a)}return a};$mille.isCharLowerCase=function(a){$mille.checkCharacter(a);return $mille.charUpcase(a)!==a};$mille.isCharUpperCase=function(a){$mille.checkCharacter(a);return $mille.charDowncase(a)!==a};$mille.isCharAlphabetic=function(a){return $mille.isCharLowerCase(a)||$mille.isCharUpperCase(a)};$mille.regexmatch=function(c,d){var a;$mille.checkCharacter(d);a=String.fromCharCode(d);return c.test(a)};$mille.regexWhitespace=/^[\u0009-\u000d\u001c-\u0020\u1680\u180e\u2000-\u2006\u2008-\u200b\u2028-\u2029\u205f\u3000]$/;$mille.isCharWhitespace=function(a){return $mille.regexmatch($mille.regexWhitespace,a)};$mille.regexNumeric=/^[\u0030-\u0039\u0660-\u0669\u06f0-\u06f9\u0966-\u096f\u09e6-\u09ef\u0a66-\u0a6f\u0ae6-\u0aef\u0b66-\u0b6f\u0be7-\u0bef\u0c66-\u0c6f\u0ce6-\u0cef\u0d66-\u0d6f\u0e50-\u0e59\u0ed0-\u0ed9\u0f20-\u0f29\u1040-\u1049\u1369-\u1371\u17e0-\u17e9\u1810-\u1819\u1946-\u194f\uff10-\uff19]$/;$mille.isCharNumeric=function(a){return $mille.regexmatch($mille.regexNumeric,a)};$mille.isComplexOnly=function(a){return $mille.c.isComplex(a)};$mille.isComplex=function(a){return $mille.o.isNumber(a)||$mille.isComplexOnly(a)};$mille.isZero=function(a){$mille.checkNumber(a);return a===0};$mille.isPositive=function(a){$mille.checkNumber(a);return $mille.o.isNumber(a)&&a>0};$mille.isNegative=function(a){$mille.checkNumber(a);return $mille.o.isNumber(a)&&a<0};$mille.isOdd=function(a){$mille.checkNumber(a);return $mille.o.isInteger(a)&&a%2==1};$mille.isEven=function(a){$mille.checkNumber(a);return $mille.o.isInteger(a)&&a%2==0};$mille.max=function(){var c,a,d=-Infinity;for(c=0;c<arguments.length;c++){a=arguments[c];$mille.checkReal(a);if(a>d){d=a}}return d};$mille.min=function(){var c,a,d=Infinity;for(c=0;c<arguments.length;c++){a=arguments[c];$mille.checkReal(a);if(a<d){d=a}}return d};$mille.exp=function(a){$mille.checkNumber(a);return $mille.c.exp(a)};$mille.log=function(a){$mille.checkNumber(a);return $mille.c.log(a)};$mille.sin=function(a){$mille.checkNumber(a);return $mille.c.sin(a)};$mille.cos=function(a){$mille.checkNumber(a);return $mille.c.cos(a)};$mille.tan=function(a){$mille.checkNumber(a);return $mille.c.tan(a)};$mille.asin=function(a){$mille.checkNumber(a);return $mille.c.asin(a)};$mille.acos=function(a){$mille.checkNumber(a);return $mille.c.acos(a)};$mille.atan=function(a,c){if(c===undefined){$mille.checkNumber(a);return $mille.c.atan(a)}else{$mille.checkReal(a);$mille.checkReal(c);return Math.atan2(a,c)}};$mille.makeRectangular=function(a,c){$mille.checkReal(a);$mille.checkReal(c);$mille.c.make(a,c)};$mille.makePolar=function(c,a){$mille.checkNonnegativeReal(x);$mille.checkReal(y);$mille.c.make(c*Math.cos(a),c*Math.sin(a))};$mille.realPart=function(a){$mille.checkNumber(a);return $mille.c.getReal(a)};$mille.imagPart=function(a){$mille.checkNumber(a);return $mille.c.getImag(a)};$mille.magnitude=function(a){$mille.checkNumber(a);return $mille.c.magnitude(a)};$mille.angle=function(a){$mille.checkNumber(a);return $mille.c.angle(a)};$mille.values=function(){var d,c;if(arguments.length===0){throw $mille.o.error("multivalue must have one datum")}else{if(arguments.length===1){return arguments[0]}else{c=new Datum("multivalue");for(d=0;d<arguments.length;d++){c[d]=arguments[d];c["value"+d]=arguments[d]}c.length=arguments.length;return c}}};$mille.isMultivalue=function(a){return $mille.datumTypeOf(a,"multivalue")};$mille.callWithValues=function(d,e){var f,c;$mille.checkFunction(d);$mille.checkFunction(e);f=d.call(null);if($mille.isMultivalue(f)){c=$mille.a.toArray(f);return e.apply(null,c)}else{return e.call(null,f)}};Datum.prototype.multivalueToString=function(){var c,a="";for(c=0;c<this.length;c++){if(a!==""){a+="\n"}a+=this[c]}return a};$mille.delay=function(a){var c;c=new Datum("promise");c.memorized=false;c.value=a;return c};$mille.force=function(a){$mille.checkPromise(a);if(!a.memorized){a.value=a.value();a.memorized=true}return a.value};$mille.isProcedure=function(a){return $mille.o.isFunction(a)};$mille.isTruthy=function(a){return !!a};$mille.isFalsy=function(a){return !a};$mille.isNan=function(a){return $mille.c.isNaN(a)};$mille.isFinite=function(a){return $mille.c.isFinite(a)};$mille.isInfinite=function(a){return $mille.c.isInfinite(a)};$mille.isUndefined=function(a){return a===undefined};$mille.isJsnull=function(a){return a===null};$mille.stringConcat=function(){var c="",a;for(a=0;a<arguments.length;a++){c+=arguments[a].toString()}return c};$mille.newObject=function(a){return new (a.bind.apply(a,$mille.a.toArray(arguments,1,[null])))()};$mille.isInstance=function(a,d){return a instanceof d};$mille.objectJ=function(a){if(a===undefined){return{}}else{$mille.checkObject(a);return a}};$mille.readString=function(a){var d,c=0;$mille.checkString(a);d=new SExpression();d.parse(function(){if(c<a.length){return a.charCodeAt(c++)}else{if(c===a.length){c++;return 1}else{return null}}});return d._};$mille.readStringAll=function(a){var e,d=0,c=[];$mille.checkString(a);while(d<=a.length){e=new SExpression();e.parse(function(){if(d<a.length){return a.charCodeAt(d++)}else{if(d===a.length){d++;return 1}else{return null}}});c.push(e._);d=d>a.length?d:d-1}return c};$mille.evalbas=function(j,c){var d,a,e,h,f,g;e=function(k){var l,i;l=k[1];i=[];while(true){if($mille.isNull(l)){l=null;break}else{if($mille.isSymbol(l)){break}else{if($mille.isAtom(l)){$mille.o.error(l+" must be a symbol")}else{if($mille.isSymbol(l.car)){i.push(l.car);l=l.cdr}else{$mille.o.error(l.car+" must be a symbol")}}}}}return j.closure(function(o){var n,m;for(m=0;m<i.length;m++){o.bind(i[m].toString(),arguments[m+1])}if(l!==null){o.bind(l.toString(),$mille.listToCell($mille.a.toArray(arguments,m+1)))}for(m=2;m<k.length;m++){n=$mille.evalbas(o,k[m])}return n})};if($mille.isPair(c)){d=$mille.shallowCellToList(c);if(d[0]===$mille.getSymbol("if")){if(d.length===3){return $mille.evalbas(j,d[1])?$mille.evalbas(j,d[2]):undefined}else{if(d.length===4){return $mille.evalbas(j,d[1])?$mille.evalbas(j,d[2]):$mille.evalbas(j,d[3])}else{$mille.o.error("malformed if")}}}else{if(d[0]===$mille.getSymbol("lambda")){return e(d)}else{if(d[0]===$mille.getSymbol("quote")){if(d.length===2){return d[1]}else{$mille.o.error("malformed quote")}}else{if(d[0]===$mille.getSymbol("begin")){for(f=1;f<d.length;f++){h=$mille.evalbas(j,d[f])}return h}else{if(d[0]===$mille.getSymbol("define")){if(d.length!==3){$mille.o.error("malformed define")}else{if(!$mille.isSymbol(d[1])){$mille.o.error(d[1]+" must be a symbol")}else{j.bind(d[1].toString(),$mille.evalbas(j,d[2]));return undefined}}}else{if(d[0]===$mille.getSymbol("set!")){if(d.length!==3){$mille.o.error("malformed set!")}else{if(!$mille.isSymbol(d[1])){$mille.o.error(d[1]+" must be a symbol")}else{j.set(d[1].toString(),$mille.evalbas(j,d[2]));return undefined}}}else{if(d[0]===$mille.getSymbol("delay")){if(d.length===2){return $mille.delay(function(){return $mille.evalbas(j,$mille.evalbas(j,d[1]))})}else{$mille.o.error("malformed delay")}}else{h=d[0];g=function(i){var k;for(f=1;f<d.length;f++){if($mille.isKeyword(d[f])){break}i.push($mille.evalbas(j,d[f]))}if(f<d.length){k={};for(;f+1<d.length;f+=2){if(!$mille.isKeyword(d[f])){break}k[d[f].name]=$mille.evalbas(j,d[f+1])}i.push(k)}};if($mille.isSymbol(h)&&h.name.length>1&&h.name.charAt(0)==="."){a=[h.name.substring(1,h.name.length)];g(a);return $mille.applyObject.apply(null,a)}else{h=$mille.evalbas(j,h);if($mille.o.isFunction(h)){a=[];g(a);return h.apply(null,a)}else{$mille.o.error(h+" must be a function")}}}}}}}}}}else{if($mille.isSymbol(c)){return j.find(c.toString())}else{return c}}};$mille.genv=$mille.newenv(undefined,this);$mille.bindg=function(a,c){$mille.genv.bind(a,$mille.closure($mille.genv,this,function(d){return c.apply(null,$mille.a.toArray(arguments,1))}))};$mille.bindg("cons",$mille.cons);$mille.bindg("eq?",$mille.eq);$mille.bindg("eqv?",$mille.eqv);$mille.bindg("car",$mille.car);$mille.bindg("cdr",$mille.cdr);$mille.bindg("atom?",$mille.isAtom);$mille.bindg("null?",$mille.isNull);$mille.bindg("symbol?",$mille.isSymbol);$mille.bindg("error",$mille.o.error);$mille.bindg("set-car!",$mille.setCar);$mille.bindg("set-cdr!",$mille.setCdr);$mille.bindg("apply",$mille.applyCell);$mille.bindg("1+",$mille.unary(function(a){return a+1}));$mille.bindg("1-",$mille.unary(function(a){return a-1}));$mille.bindg(">",$mille.compareNumber(function(a,c){return a>c}));$mille.bindg("<",$mille.compareNumber(function(a,c){return a<c}));$mille.bindg("=",$mille.compare($mille.c.equals,$mille.checkNumber));$mille.bindg("+",$mille.arith1($mille.c.add,0));$mille.bindg("-",$mille.arith2($mille.c.subtract,function(a){return $mille.c.subtract(0,a)}));$mille.bindg("*",$mille.arith1($mille.c.multiply,1));$mille.bindg("/",$mille.arith2($mille.c.divide,function(a){return $mille.c.divide(1,a)}));$mille.bindg("string?",$mille.o.isString);$mille.bindg("substring",$mille.substring);$mille.bindg("string-ref",$mille.stringRef);$mille.bindg("string-length",$mille.stringLength);$mille.bindg("string-append",$mille.stringAppend);$mille.bindg("string?",$mille.isString);$mille.bindg("make-string",$mille.makeString);$mille.bindg("string",$mille.string);$mille.bindg("string>?",$mille.compareString(function(a,c){return a>c}));$mille.bindg("string<?",$mille.compareString(function(a,c){return a<c}));$mille.bindg("string=?",$mille.compareString(function(a,c){return a===c}));$mille.bindg("string>=?",$mille.compareString(function(a,c){return a>=c}));$mille.bindg("string<=?",$mille.compareString(function(a,c){return a<=c}));$mille.bindg("string-ci>?",$mille.compareStringCi(function(a,c){return a>c}));$mille.bindg("string-ci<?",$mille.compareStringCi(function(a,c){return a<c}));$mille.bindg("string-ci=?",$mille.compareStringCi(function(a,c){return a===c}));$mille.bindg("string-ci>=?",$mille.compareStringCi(function(a,c){return a>=c}));$mille.bindg("string-ci<=?",$mille.compareStringCi(function(a,c){return a<=c}));$mille.bindg("string->list",$mille.stringToList);$mille.bindg("list->string",$mille.listToString);$mille.bindg("string->symbol",$mille.stringToSymbol);$mille.bindg("symbol->string",$mille.symbolToString);$mille.bindg("vector?",$mille.isVector);$mille.bindg("number->string",$mille.numberToString);$mille.bindg("make-vector",$mille.makeVector);$mille.bindg("vector-length",$mille.vectorLength);$mille.bindg("vector-ref",$mille.vectorRef);$mille.bindg("vector-set!",$mille.vectorSet);$mille.bindg("vector->list",$mille.vectorToList);$mille.bindg("list->vector",$mille.listToVector);$mille.bindg("vector-fill!",$mille.vectorFill);$mille.bindg("not",$mille.not);$mille.bindg("boolean?",$mille.isBoolean);$mille.bindg(">=",$mille.compareNumber(function(a,c){return a>=c}));$mille.bindg("<=",$mille.compareNumber(function(a,c){return a<=c}));$mille.bindg("number?",$mille.isNumber);$mille.bindg("real?",$mille.isReal);$mille.bindg("integer?",$mille.isInteger);$mille.bindg("exact?",$mille.isExact);$mille.bindg("inexact?",$mille.isInexact);$mille.bindg("abs",$mille.abs);$mille.bindg("remainder",$mille.remainder);$mille.bindg("quotient",$mille.quotient);$mille.bindg("modulo",$mille.modulo);$mille.bindg("gcd",$mille.gcd);$mille.bindg("lcm",$mille.lcm);$mille.bindg("floor",$mille.floor);$mille.bindg("ceiling",$mille.ceiling);$mille.bindg("truncate",$mille.truncate);$mille.bindg("round",$mille.round);$mille.bindg("object?",$mille.isObject);$mille.bindg("object-ref",$mille.objectRef);$mille.bindg("object-set!",$mille.objectSet);$mille.bindg("object-keys",$mille.objectKeys);$mille.bindg("object-values",$mille.objectValues);$mille.bindg("object->list",$mille.objectToList);$mille.bindg("char?",$mille.isChar);$mille.bindg("char>?",$mille.compareCharacter(function(a,c){return a>c}));$mille.bindg("char<?",$mille.compareCharacter(function(a,c){return a<c}));$mille.bindg("char=?",$mille.compareCharacter(function(a,c){return a===c}));$mille.bindg("char>=?",$mille.compareCharacter(function(a,c){return a>=c}));$mille.bindg("char<=?",$mille.compareCharacter(function(a,c){return a<=c}));$mille.bindg("char-ci>?",$mille.compareCharacterCi(function(a,c){return a>c}));$mille.bindg("char-ci<?",$mille.compareCharacterCi(function(a,c){return a<c}));$mille.bindg("char-ci=?",$mille.compareCharacterCi(function(a,c){return a===c}));$mille.bindg("char-ci>=?",$mille.compareCharacterCi(function(a,c){return a>=c}));$mille.bindg("char-ci<=?",$mille.compareCharacterCi(function(a,c){return a<=c}));$mille.bindg("char-alphabetic?",$mille.isCharAlphabetic);$mille.bindg("char-whitespace?",$mille.isCharWhitespace);$mille.bindg("char-numeric?",$mille.isCharNumeric);$mille.bindg("char-upper-case?",$mille.isCharUpperCase);$mille.bindg("char-lower-case?",$mille.isCharLowerCase);$mille.bindg("char->integer",$mille.charToInteger);$mille.bindg("integer->char",$mille.integerToChar);$mille.bindg("char-upcase",$mille.charUpcase);$mille.bindg("char-downcase",$mille.charDowncase);$mille.bindg("complex?",$mille.isComplex);$mille.bindg("zero?",$mille.isZero);$mille.bindg("positive?",$mille.isPositive);$mille.bindg("negative?",$mille.isNegative);$mille.bindg("odd?",$mille.isOdd);$mille.bindg("even?",$mille.isEven);$mille.bindg("max",$mille.max);$mille.bindg("min",$mille.min);$mille.bindg("exp",$mille.exp);$mille.bindg("log",$mille.log);$mille.bindg("sin",$mille.sin);$mille.bindg("cos",$mille.cos);$mille.bindg("tan",$mille.tan);$mille.bindg("asin",$mille.asin);$mille.bindg("acos",$mille.acos);$mille.bindg("atan",$mille.atan);$mille.bindg("make-rectangular",$mille.makeRectangular);$mille.bindg("make-polar",$mille.makePolar);$mille.bindg("real-part",$mille.realPart);$mille.bindg("imag-part",$mille.imagPart);$mille.bindg("magnitude",$mille.magnitude);$mille.bindg("angle",$mille.angle);$mille.bindg("string->number",$mille.stringToNumber);$mille.bindg("values",$mille.values);$mille.bindg("call-with-values",$mille.callWithValues);$mille.bindg("force",$mille.force);$mille.bindg("procedure?",$mille.isProcedure);$mille.bindg("truthy?",$mille.isTruthy);$mille.bindg("falsy?",$mille.isFalsy);$mille.bindg("nan?",$mille.isNan);$mille.bindg("finite?",$mille.isFinite);$mille.bindg("infinite?",$mille.isInfinite);$mille.bindg("undefined?",$mille.isUndefined);$mille.bindg("jsnull?",$mille.isJsnull);$mille.bindg("++",$mille.stringConcat);$mille.bindg("new",$mille.newObject);$mille.bindg("instance?",$mille.isInstance);$mille.bindg("J",$mille.objectJ);$mille.bindg("equal?",$mille.isEqual);$mille.bindg("read-string",$mille.readString);$mille.bindg("read-string-all",$mille.readStringAll);$env=$mille.genv;function SExpression(){this.__state=0;this.__sts=[];this.__stk=[];this.__stv=[];this.__slen=0;this._=null;this._l=null;this._initlist=function(){this._l=[]};this._addlist=function(a){this._l.push(a)};this.unread=null;this.yieldObject=null;this.befstream=null;this.exception=null;this.$buffer=null;this.$int=null;this.$num=null;this.__lookahead_state=0;this.__lookahead_mark=-1;this.__lookahead=null;this.__lookahead_ptr=-1;this.__lookaheadw=null;this.__lookaheadw_ptr=-1;this.__lookahead_ok=true;this.ENGINE_exp=SExpression.ENGINE_exp;this.ENGINE_sExpression=SExpression.ENGINE_sExpression;this.ENGINE_value=SExpression.ENGINE_value;this._unreadl=null}function SExpression_TokenException(){}SExpression.prototype._read1l=function(a){return a()};SExpression.prototype._read1=function(a){var d;if(this._unreadl!=null){d=this._unreadl;this._unreadl=null}else{if((d=this._read1l(a))==13&&(d=this._read1l(a))!=10){this._unreadl=d;d=13}}return d};SExpression.__SKIP__={};SExpression.__DUM__={};SExpression.prototype._read=function(a){var d;while(true){if(false){}else{if(this.unread!=null){d=this.unread;this.unread=null;this.__logprint("Read unread: ",d)}else{if(this.__lookahead_ptr>=0){if(this.__lookahead_ptr<this.__lookahead.length){d=this.__lookahead[this.__lookahead_ptr++]}else{this.__lookahead=null;this.__lookahead_ptr=-1;d=this._read(a)}this.__logprint("Read Lookahead: ",d)}else{if((d=this._read1(a))!=null){this.__logprint("Read: ",d)}else{this.__logprint("Read end-of-file")}}}}return d}};SExpression.prototype._f_UNGET=function(a){this.unread=a;this.__logprint("Set unread: ",a)};SExpression.prototype.__logprint=function(a,d){};SExpression.prototype.__logopen=function(){};SExpression.prototype.__logclose=function(){};SExpression.prototype.__puttrace=function(){};SExpression.prototype._f_LOOKAHEAD=function(a){if(this.__lookaheadw==null){this.__lookahead_state=this.__state;this.__lookaheadw=[];this.__lookaheadw_ptr=0;this.__lookaheadw[this.__lookaheadw_ptr++]=a}else{this.__lookaheadw[this.__lookaheadw_ptr++]=a}};SExpression.prototype.__copy_lookahead=function(e){var c,d;if(this.__lookahead_ptr>0){c=[];for(d=0;d<c.length;d++){c[d]=this.__lookaheadw[d+this.__lookahead_ptr]}__lookahead=c}if(this.__lookahead==null){c=[]}else{if(this.__lookaheadw_ptr<this.__lookahead.length-this.__lookahead_ptr){c=this.__lookahead}else{c=[]}}for(d=0;d<this.__lookaheadw_ptr;d++){c[d]=this.__lookaheadw[d]}this.__lookahead=c;this.__lookahead_ptr=e;this.__lookaheadw=null;this.__lookaheadw_ptr=-1};SExpression.prototype._f_LOOKAHEAD_COMMIT=function(){if(this.__lookahead_mark<0){this.__lookaheadw=null;this.__lookaheadw_ptr=-1}else{this.__copy_lookahead(this.__lookahead_mark)}this.__lookahead_mark=-1;this.__logprint("Commit Lookahead")};SExpression.prototype._f_LOOKAHEAD_RB=function(){this.__copy_lookahead(0);this.__state=this.__lookahead_state;this.__lookahead_ok=false;this.__lookahead_mark=-1;this.__logprint("Rollback Lookahead")};SExpression.prototype._f_LOOKAHEAD_MARK=function(){this.__lookahead_mark=this.__lookaheadw_ptr};SExpression.prototype._f_LOOKAHEAD_MARK_INIT=function(){this.__lookahead_mark=0};SExpression.ENGINE_exp={};SExpression.ENGINE_exp.step=function(e,a,d){var c=e.__lookahead_ok;e.__lookahead_ok=true;switch(e.__state){case 0:if(d!==null&&((c&&d===35))){e._f_LOOKAHEAD(d);e.__state=1;return 1}else{if(d!==null&&((d===94))){e.__state=2;return 1}else{if(d!==null&&((d===40))){e.initc();e.__state=3;return 1}else{if(d!==null&&((d>=9&&d<=10)||(d===32))){e.__state=0;return 1}else{if(d!==null&&((d===59))){e.__state=4;return 1}else{if(d!==null&&((d===39))){e.__state=5;return 1}else{if(d!==null&&((d===1))){e.__state=6;return 1}else{if(d!==null){e.__stkpush(7,e.ENGINE_value);e.__state=0;return -1}}}}}}}}return 0;case 7:return 0;case 6:return 0;case 5:if(d!==null&&((d>=9&&d<=10)||(d===32))){e.__state=5;return 1}else{if(d!==null){e.__stkpush(8,e.ENGINE_exp);e.__state=0;return -1}}return 0;case 8:return 0;case 4:if(d!==null&&((d===10))){e.__state=0;return 1}else{if(d!==null){e.__state=4;return 1}}return 0;case 3:if(d!==null&&((d===41))){e.__state=9;return 1}else{if(d!==null&&((d>=9&&d<=10)||(d===32))){e.__state=3;return 1}else{if(d!==null){e.__stkpush(10,e.ENGINE_exp);e.__state=0;return -1}}}return 0;case 10:if(d!==null&&((c&&d===46))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=11;return 1}else{if(d===null){e.__state=3;return 1}else{if(d!==null){e._f_UNGET(d);e.__state=3;return 1}}}return 0;case 11:if(d!==null&&((c&&d>=9&&d<=10)||(c&&d===32))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=12;return 1}return 0;case 12:if(d!==null&&((c&&d>=0&&d<=2147483647))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_COMMIT();e.__state=13;return 1}else{if(d===null){e._f_LOOKAHEAD_COMMIT();e.__state=13;return 1}}return 0;case 13:if(d!==null&&((d===46))){e._f_UNGET(d);e.$buffer="";e.__state=14;return 1}return 0;case 14:if(d!==null&&((d===46))){e.$buffer+=String.fromCharCode(d);e.__state=15;return 1}return 0;case 15:if(d!==null&&((d>=0&&d<=8)||(d>=11&&d<=31)||(d>=33&&d<=2147483647))){e._f_UNGET(d);e.__state=16;return 1}else{if(d!==null&&((d>=9&&d<=10)||(d===32))){e.$buffer+=String.fromCharCode(d);e.__state=17;return 1}else{if(d===null){e.__state=16;return 1}}}return 0;case 17:if(d!==null&&((d>=0&&d<=8)||(d>=11&&d<=31)||(d>=33&&d<=2147483647))){e._f_UNGET(d);e.__state=16;return 1}else{if(d!==null&&((d>=9&&d<=10)||(d===32))){e.$buffer+=String.fromCharCode(d);e.__state=17;return 1}else{if(d===null){e.__state=16;return 1}}}return 0;case 16:if(d!==null){e.__stkpush(18,e.ENGINE_exp);e.__state=0;return -1}return 0;case 18:if(d!==null&&((d===41))){e.__state=19;return 1}return 0;case 19:return 0;case 9:return 0;case 2:if(d!==null&&((d>=9&&d<=10)||(d===32))){e.__state=2;return 1}else{if(d!==null){e.__stkpush(20,e.ENGINE_exp);e.__state=0;return -1}}return 0;case 20:return 0;case 1:if(d!==null&&((d===40))){e._f_LOOKAHEAD_COMMIT();e.initv();e.__state=21;return 1}return 0;case 21:if(d!==null&&((d>=9&&d<=10)||(d===32))){e.__state=21;return 1}else{if(d!==null&&((d===41))){e.__state=22;return 1}else{if(d!==null){e.__stkpush(23,e.ENGINE_exp);e.__state=0;return -1}}}return 0;case 23:e.__state=21;return 1;case 22:return 0}return 0};SExpression.ENGINE_exp.accepted=function(a){return(a.__state===19||a.__state===20||a.__state===22||a.__state===7||a.__state===8||a.__state===9)};SExpression.ENGINE_exp.execaction=function(c,a){switch(c.__state){case 4:break;case 13:break;case 7:break;case 20:c._=c.qlambda(c._);break;case 3:break;case 0:break;case 18:break;case 2:break;case 6:break;case 22:c._=c.endv();break;case 21:break;case 12:break;case 19:c._=c.endc(c._);break;case 10:c.addc(c._);break;case 15:break;case 5:break;case 17:break;case 8:c._=c.quote(c._);break;case 14:break;case 1:break;case 16:break;case 9:c._=c.endc($mille.nil);break;case 23:c.addv(c._);break;case 11:break}return 1};SExpression.ENGINE_exp.isend=function(a){return(a.__state===17||a.__state===23||a.__state===10||a.__state===12||a.__state===15)};SExpression.ENGINE_exp.recover=function(c,a){return -1};SExpression.ENGINE_exp.deadState=function(a){return -1};SExpression.ENGINE_exp.stateSize=function(a){return 24};SExpression.ENGINE_exp.finallyState=function(a){return -1};SExpression.ENGINE_exp.dead=function(a){return(a.__state===19||a.__state===20||a.__state===6||a.__state===22||a.__state===7||a.__state===8||a.__state===9)};SExpression.ENGINE_exp.emptyTransition=function(a){return(a.__state===23)};SExpression.ENGINE_exp.toString=function(){return"exp"};SExpression.ENGINE_sExpression={};SExpression.ENGINE_sExpression.step=function(e,a,d){var c=e.__lookahead_ok;e.__lookahead_ok=true;switch(e.__state){case 0:if(d!==null&&((d===41))){e.__state=1;return 1}else{if(d!==null){e.__stkpush(2,e.ENGINE_exp);e.__state=0;return -1}}return 0;case 2:if(d!==null&&((d===59))){e.__state=3;return 1}else{if(d!==null&&((d===1)||(d>=9&&d<=10)||(d===32))){e.__state=2;return 1}}return 0;case 3:if(d!==null&&((d===10))){e.__state=2;return 1}else{if(d!==null){e.__state=3;return 1}}return 0;case 1:return 0}return 0};SExpression.ENGINE_sExpression.accepted=function(a){return(a.__state===2||a.__state===3)};SExpression.ENGINE_sExpression.execaction=function(c,a){switch(c.__state){case 1:break;case 2:break;case 0:break;case 3:break}return 1};SExpression.ENGINE_sExpression.isend=function(a){return false};SExpression.ENGINE_sExpression.recover=function(c,a){return -1};SExpression.ENGINE_sExpression.deadState=function(a){return -1};SExpression.ENGINE_sExpression.stateSize=function(a){return 4};SExpression.ENGINE_sExpression.finallyState=function(a){return -1};SExpression.ENGINE_sExpression.dead=function(a){return(a.__state===1)};SExpression.ENGINE_sExpression.emptyTransition=function(a){return false};SExpression.ENGINE_sExpression.toString=function(){return"sExpression"};SExpression.ENGINE_value={};SExpression.ENGINE_value.step=function(e,a,d){var c=e.__lookahead_ok;e.__lookahead_ok=true;switch(e.__state){case 0:if(d!==null&&((c&&d===46))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=1;return 1}else{if(d!==null&&((c&&d===43)||(c&&d===45))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=2;return 1}else{if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=3;return 1}else{if(d!==null&&((d>=9&&d<=10)||(d===32))){e.__state=0;return 1}else{if(d!==null&&((d===1))){e.__state=4;return 1}else{if(d!==null&&((d===59))){e.__state=5;return 1}else{if(d!==null&&((d===35))){e.__state=6;return 1}else{if(d!==null&&((d===34))){e.clearbuf();e.__state=7;return 1}else{if(d!==null){e.clearbuf();e.__state=8;return 1}}}}}}}}}return 0;case 8:if(d!==null&&((d===0)||(d>=2&&d<=8)||(d>=11&&d<=31)||(d===33)||(d>=36&&d<=38)||(d>=42&&d<=43)||(d>=45&&d<=58)||(d>=60&&d<=95)||(d>=97&&d<=2147483647))){e.__state=8;return 1}else{if(d===null){e.__state=9;return 1}else{if(d!==null){e._f_UNGET(d);e.__state=9;return 1}}}return 0;case 9:return 0;case 7:if(d!==null&&((d===34))){e.__state=10;return 1}else{if(d!==null&&((d===92))){e.__state=11;return 1}else{if(d!==null){e.__state=7;return 1}}}return 0;case 11:if(d!==null){e.__state=7;return 1}return 0;case 10:return 0;case 6:if(d!==null&&((d===79)||(d===111))){e.__state=12;return 1}else{if(d!==null&&((d===88)||(d===120))){e.__state=13;return 1}else{if(d!==null&&((d===66)||(d===98))){e.__state=14;return 1}else{if(d!==null&&((d===92))){e.__state=15;return 1}else{if(d!==null&&((d===0)||(d>=2&&d<=8)||(d>=11&&d<=31)||(d===33)||(d>=36&&d<=38)||(d>=42&&d<=43)||(d>=45&&d<=46)||(d>=48&&d<=58)||(d>=60&&d<=65)||(d>=67&&d<=78)||(d>=80&&d<=87)||(d>=89&&d<=91)||(d===93)||(d===95)||(d===97)||(d>=99&&d<=110)||(d>=112&&d<=119)||(d>=121&&d<=2147483647))){e.__state=16;return 1}else{if(d!==null&&((d===47))){e.__state=17;return 1}}}}}}return 0;case 17:if(d!==null&&((d===92))){e.__state=18;return 1}else{if(d!==null&&((d===47))){e.re=e.buf;e.clearbuf();e.__state=19;return 1}else{if(d!==null){e.addbuf(d);e.__state=17;return 1}}}return 0;case 19:if(d!==null&&((d>=97&&d<=122))){e.addbuf(d);e.__state=19;return 1}else{if(d===null){e.__state=20;return 1}else{if(d!==null){e._f_UNGET(d);e.__state=20;return 1}}}return 0;case 20:return 0;case 18:if(d!==null){e.addbuf(d);e.__state=17;return 1}return 0;case 16:if(d!==null&&((d===0)||(d>=2&&d<=8)||(d>=11&&d<=31)||(d===33)||(d>=36&&d<=38)||(d>=42&&d<=43)||(d>=45&&d<=58)||(d>=60&&d<=95)||(d>=97&&d<=2147483647))){e.__state=16;return 1}else{if(d===null){e.__state=21;return 1}else{if(d!==null){e._f_UNGET(d);e.__state=21;return 1}}}return 0;case 21:return 0;case 15:if(d!==null&&((d>=65&&d<=90)||(d>=97&&d<=122))){e.__state=22;return 1}else{if(d!==null){e.__state=23;return 1}}return 0;case 23:return 0;case 22:if(d!==null&&((d>=65&&d<=90)||(d>=97&&d<=122))){e.addch();e.__state=24;return 1}return 0;case 24:if(d!==null&&((d>=65&&d<=90)||(d>=97&&d<=122))){e.__state=24;return 1}else{if(d===null){e.__state=25;return 1}else{if(d!==null){e._f_UNGET(d);e.__state=25;return 1}}}return 0;case 25:return 0;case 14:if(d!==null&&((d>=48&&d<=49))){e.__state=26;return 1}return 0;case 26:if(d!==null&&((d>=48&&d<=49))){e.__state=26;return 1}else{if(d===null){e.__state=27;return 1}else{if(d!==null){e._f_UNGET(d);e.__state=27;return 1}}}return 0;case 27:return 0;case 13:if(d!==null&&((d>=48&&d<=57)||(d>=65&&d<=70)||(d>=97&&d<=102))){e.__state=28;return 1}return 0;case 28:if(d!==null&&((d>=48&&d<=57)||(d>=65&&d<=70)||(d>=97&&d<=102))){e.__state=28;return 1}else{if(d===null){e.__state=29;return 1}else{if(d!==null){e._f_UNGET(d);e.__state=29;return 1}}}return 0;case 29:return 0;case 12:if(d!==null&&((d>=48&&d<=55))){e.__state=30;return 1}return 0;case 30:if(d!==null&&((d>=48&&d<=55))){e.__state=30;return 1}else{if(d===null){e.__state=31;return 1}else{if(d!==null){e._f_UNGET(d);e.__state=31;return 1}}}return 0;case 31:return 0;case 5:if(d!==null&&((d===10))){e.__state=0;return 1}else{if(d!==null){e.__state=5;return 1}}return 0;case 4:return 0;case 3:if(d!==null&&((c&&d===46))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=1;return 1}else{if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=3;return 1}else{if(d!==null&&((c&&d===43)||(c&&d===45))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=32;return 1}else{if(d!==null&&((c&&d===105))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=33;return 1}else{if(d!==null&&((c&&d===69)||(c&&d===101))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=34;return 1}else{if(d!==null&&((c&&d===1)||(c&&d>=9&&d<=10)||(c&&d===32)||(c&&d>=34&&d<=35)||(c&&d>=39&&d<=41)||(c&&d===44)||(c&&d===59)||(c&&d===96))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=35;return 1}}}}}}return 0;case 35:if(d!==null&&((c&&d>=0&&d<=2147483647))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_COMMIT();e.__state=36;return 1}else{if(d===null){e._f_LOOKAHEAD_COMMIT();e.__state=36;return 1}}return 0;case 36:if(d!==null&&((d===46))){e.$buffer="";e.$buffer+=String.fromCharCode(d);e.__state=37;return 1}else{if(d!==null&&((d>=48&&d<=57))){e.$buffer="";e.$buffer+=String.fromCharCode(d);e.__state=38;return 1}else{if(d!==null&&((d===43))){e.$buffer="";e.__state=39;return 1}else{if(d!==null&&((d===45))){e.$buffer="";e.$buffer+=String.fromCharCode(d);e.__state=39;return 1}}}}return 0;case 39:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=38;return 1}else{if(d!==null&&((d===46))){e.$buffer+=String.fromCharCode(d);e.__state=37;return 1}}return 0;case 38:if(d!==null&&((d===69)||(d===101))){e.$buffer+=String.fromCharCode(d);e.__state=40;return 1}else{if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=38;return 1}else{if(d!==null&&((d===46))){e.$buffer+=String.fromCharCode(d);e.__state=37;return 1}else{if(d===null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=41;return 1}else{if(d!==null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=41;return 1}}}}}return 0;case 41:if(d!==null&&((d===105))){e.__state=42;return 1}else{if(d!==null&&((d===45))){e.__state=43;return 1}else{if(d!==null&&((d===43))){e.__state=44;return 1}}}return 0;case 44:if(d!==null&&((d===46))){e.$buffer="";e.$buffer+=String.fromCharCode(d);e.__state=45;return 1}else{if(d!==null&&((d===43))){e.$buffer="";e.__state=46;return 1}else{if(d!==null&&((d>=48&&d<=57))){e.$buffer="";e.$buffer+=String.fromCharCode(d);e.__state=47;return 1}else{if(d!==null&&((d===45))){e.$buffer="";e.$buffer+=String.fromCharCode(d);e.__state=46;return 1}}}}return 0;case 47:if(d!==null&&((d===46))){e.$buffer+=String.fromCharCode(d);e.__state=45;return 1}else{if(d!==null&&((d===69)||(d===101))){e.$buffer+=String.fromCharCode(d);e.__state=48;return 1}else{if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=47;return 1}else{if(d===null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=49;return 1}else{if(d!==null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=49;return 1}}}}}return 0;case 49:if(d!==null&&((d===105))){e.__state=50;return 1}return 0;case 50:return 0;case 48:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=51;return 1}else{if(d!==null&&((d===43)||(d===45))){e.$buffer+=String.fromCharCode(d);e.__state=52;return 1}}return 0;case 52:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=51;return 1}return 0;case 51:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=51;return 1}else{if(d===null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=49;return 1}else{if(d!==null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=49;return 1}}}return 0;case 46:if(d!==null&&((d===46))){e.$buffer+=String.fromCharCode(d);e.__state=45;return 1}else{if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=47;return 1}}return 0;case 45:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=53;return 1}return 0;case 53:if(d!==null&&((d===69)||(d===101))){e.$buffer+=String.fromCharCode(d);e.__state=48;return 1}else{if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=53;return 1}else{if(d===null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=49;return 1}else{if(d!==null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=49;return 1}}}}return 0;case 43:if(d!==null&&((d===45))){e.$buffer="";e.$buffer+=String.fromCharCode(d);e.__state=54;return 1}else{if(d!==null&&((d===43))){e.$buffer="";e.__state=54;return 1}else{if(d!==null&&((d===46))){e.$buffer="";e.$buffer+=String.fromCharCode(d);e.__state=55;return 1}else{if(d!==null&&((d>=48&&d<=57))){e.$buffer="";e.$buffer+=String.fromCharCode(d);e.__state=56;return 1}}}}return 0;case 56:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=56;return 1}else{if(d!==null&&((d===46))){e.$buffer+=String.fromCharCode(d);e.__state=55;return 1}else{if(d!==null&&((d===69)||(d===101))){e.$buffer+=String.fromCharCode(d);e.__state=57;return 1}else{if(d===null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=58;return 1}else{if(d!==null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=58;return 1}}}}}return 0;case 58:if(d!==null&&((d===105))){e.__state=59;return 1}return 0;case 59:return 0;case 57:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=60;return 1}else{if(d!==null&&((d===43)||(d===45))){e.$buffer+=String.fromCharCode(d);e.__state=61;return 1}}return 0;case 61:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=60;return 1}return 0;case 60:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=60;return 1}else{if(d===null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=58;return 1}else{if(d!==null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=58;return 1}}}return 0;case 55:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=62;return 1}return 0;case 62:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=62;return 1}else{if(d!==null&&((d===69)||(d===101))){e.$buffer+=String.fromCharCode(d);e.__state=57;return 1}else{if(d===null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=58;return 1}else{if(d!==null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=58;return 1}}}}return 0;case 54:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=56;return 1}else{if(d!==null&&((d===46))){e.$buffer+=String.fromCharCode(d);e.__state=55;return 1}}return 0;case 42:return 0;case 40:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=63;return 1}else{if(d!==null&&((d===43)||(d===45))){e.$buffer+=String.fromCharCode(d);e.__state=64;return 1}}return 0;case 64:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=63;return 1}return 0;case 63:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=63;return 1}else{if(d===null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=41;return 1}else{if(d!==null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=41;return 1}}}return 0;case 37:if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=65;return 1}return 0;case 65:if(d!==null&&((d===69)||(d===101))){e.$buffer+=String.fromCharCode(d);e.__state=40;return 1}else{if(d!==null&&((d>=48&&d<=57))){e.$buffer+=String.fromCharCode(d);e.__state=65;return 1}else{if(d===null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=41;return 1}else{if(d!==null){e._f_UNGET(d);e.$num=parseFloat(e.$buffer);e.__state=41;return 1}}}}return 0;case 34:if(d!==null&&((c&&d===43)||(c&&d===45))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=66;return 1}else{if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=67;return 1}}return 0;case 67:if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=67;return 1}else{if(d!==null&&((c&&d===43)||(c&&d===45))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=32;return 1}else{if(d!==null&&((c&&d===105))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=33;return 1}else{if(d!==null&&((c&&d===1)||(c&&d>=9&&d<=10)||(c&&d===32)||(c&&d>=34&&d<=35)||(c&&d>=39&&d<=41)||(c&&d===44)||(c&&d===59)||(c&&d===96))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=35;return 1}}}}return 0;case 66:if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=67;return 1}return 0;case 33:if(d!==null&&((c&&d===1)||(c&&d>=9&&d<=10)||(c&&d===32)||(c&&d>=34&&d<=35)||(c&&d>=39&&d<=41)||(c&&d===44)||(c&&d===59)||(c&&d===96))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=35;return 1}return 0;case 32:if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=68;return 1}else{if(d!==null&&((c&&d===46))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=69;return 1}}return 0;case 69:if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=70;return 1}return 0;case 70:if(d!==null&&((c&&d===69)||(c&&d===101))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=71;return 1}else{if(d!==null&&((c&&d===105))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=72;return 1}else{if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=70;return 1}}}return 0;case 72:if(d!==null&&((c&&d===1)||(c&&d>=9&&d<=10)||(c&&d===32)||(c&&d>=34&&d<=35)||(c&&d>=39&&d<=41)||(c&&d===44)||(c&&d===59)||(c&&d===96))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=35;return 1}return 0;case 71:if(d!==null&&((c&&d===43)||(c&&d===45))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=73;return 1}else{if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=74;return 1}}return 0;case 74:if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=74;return 1}else{if(d!==null&&((c&&d===105))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=72;return 1}}return 0;case 73:if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=74;return 1}return 0;case 68:if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=68;return 1}else{if(d!==null&&((c&&d===69)||(c&&d===101))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=71;return 1}else{if(d!==null&&((c&&d===46))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=69;return 1}else{if(d!==null&&((c&&d===105))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=72;return 1}}}}return 0;case 2:if(d!==null&&((c&&d===46))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=1;return 1}else{if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=3;return 1}}return 0;case 1:if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=75;return 1}return 0;case 75:if(d!==null&&((c&&d>=48&&d<=57))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=75;return 1}else{if(d!==null&&((c&&d===43)||(c&&d===45))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=32;return 1}else{if(d!==null&&((c&&d===105))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=33;return 1}else{if(d!==null&&((c&&d===69)||(c&&d===101))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=34;return 1}else{if(d!==null&&((c&&d===1)||(c&&d>=9&&d<=10)||(c&&d===32)||(c&&d>=34&&d<=35)||(c&&d>=39&&d<=41)||(c&&d===44)||(c&&d===59)||(c&&d===96))){e._f_LOOKAHEAD(d);e._f_LOOKAHEAD_MARK_INIT();e.__state=35;return 1}}}}}return 0}return 0};SExpression.ENGINE_value.accepted=function(a){return(a.__state===42||a.__state===9||a.__state===10||a.__state===41||a.__state===50||a.__state===21||a.__state===20||a.__state===23||a.__state===59||a.__state===25||a.__state===27||a.__state===29||a.__state===31)};SExpression.ENGINE_value.execaction=function(c,a){switch(c.__state){case 45:break;case 50:c._=$mille.c.make(c._,c.$num);break;case 1:break;case 8:c.addbuf(a);break;case 7:c.addbuf(a);break;case 42:c._=$mille.c.make(0,c._);break;case 43:break;case 69:break;case 4:break;case 46:break;case 10:c._=c.str(c.buf);break;case 56:break;case 67:break;case 71:break;case 27:c._=parseInt(c.buf,2);break;case 28:c.addbuf(a);break;case 54:break;case 59:c._=$mille.c.make(c._,-c.$num);break;case 3:break;case 70:break;case 24:c.addbuf(a);break;case 58:break;case 48:break;case 2:break;case 13:break;case 49:break;case 30:c.addbuf(a);break;case 34:break;case 41:c._=c.$num;break;case 63:break;case 16:c.addbuf(a);break;case 47:break;case 55:break;case 15:break;case 65:break;case 61:break;case 40:break;case 53:break;case 39:break;case 75:break;case 52:break;case 19:break;case 20:c._=c.newre();break;case 44:break;case 64:break;case 21:c._=c.sharp(c.buf);break;case 51:break;case 9:c._=c.sym(c.buf);break;case 31:c._=parseInt(c.buf,8);break;case 32:break;case 72:break;case 36:break;case 0:break;case 14:break;case 29:c._=parseInt(c.buf,16);break;case 12:break;case 73:break;case 38:break;case 6:c.clearbuf();break;case 26:c.addbuf(a);break;case 17:break;case 5:break;case 22:c.ch=a;break;case 25:c._=c.chrname(c.buf);break;case 57:break;case 62:break;case 33:break;case 60:break;case 23:c._=a;break;case 18:c.addbuf(a);break;case 68:break;case 74:break;case 35:break;case 11:c.addbuf(a);break;case 66:break;case 37:break}return 1};SExpression.ENGINE_value.isend=function(a){return(a.__state===35||a.__state===38||a.__state===65||a.__state===8||a.__state===47||a.__state===51||a.__state===16||a.__state===19||a.__state===53||a.__state===24||a.__state===26||a.__state===56||a.__state===63||a.__state===62||a.__state===28||a.__state===60||a.__state===30)};SExpression.ENGINE_value.recover=function(c,a){return -1};SExpression.ENGINE_value.deadState=function(a){return -1};SExpression.ENGINE_value.stateSize=function(a){return 76};SExpression.ENGINE_value.finallyState=function(a){return -1};SExpression.ENGINE_value.dead=function(a){return(a.__state===4||a.__state===42||a.__state===9||a.__state===10||a.__state===50||a.__state===21||a.__state===20||a.__state===23||a.__state===59||a.__state===25||a.__state===27||a.__state===29||a.__state===31)};SExpression.ENGINE_value.emptyTransition=function(a){return false};SExpression.ENGINE_value.toString=function(){return"value"};SExpression.prototype.__stkpush=function(c,a){this.__sts[this.__slen]=c;this.__stk[this.__slen]=a;this.__stv[this.__slen++]=[]};SExpression.prototype._parse=function(m,k,f,l){var i=false;var h=k,j;var d;i=this.__stk[this.__slen-1].accepted(this);if(m==null){throw new SExpression_TokenException("can not recurse")}else{if(f){switch(this.__stk[this.__slen-1].execaction(this,-2)){case -1:this.__logprint("accept "+this.__stk[this.__slen-1]);l[0]=-1;return null;case -9:this.__logprint("match failed: begin");this._puttrace();l[0]=-9;return null;case -91:this.__logprint("machine halted: begin");l[0]=-91;return null;case -72:this.__logprint("machine halted: begin");l[0]=-72;return null;case -85:this.__logprint("machine yielded: ",h);l[0]=-85;return null}}}try{do{d=this.__stk[this.__slen-1];if(h===SExpression.__SKIP__){h=SExpression.__DUM__}else{if((j=d.step(this,m,h))>0){this.__logprint("transit to state "+this.__state+": ",h);i=d.accepted(this);switch(d.execaction(this,h)){case -1:this.__logprint("accept "+this.__stk[this.__slen-1].toString());this._f_UNGET(h);l[0]=-1;return null;case -9:this.__logprint("match failed: ",h);this.__puttrace();this._f_UNGET(h);l[0]=-9;return null;case -91:this.__logprint("machine halted: ",h);l[0]=-91;return null;case -72:this.__logprint("machine halted: ",h);l[0]=-72;return null;case -85:this.__logprint("machine yielded: ",h);l[0]=-85;return null}}else{if(j<0){this.__logprint("entering "+this.__stk[this.__slen-1].toString());return h}else{if(i){this.__logprint("accept "+this.__stk[this.__slen-1].toString());this._f_UNGET(h);l[0]=-1;return null}else{if(this.__lookaheadw_ptr>=0){this.__logprint("match failed: try lookahead: ",h);this._f_LOOKAHEAD(h);this._f_LOOKAHEAD_RB();i=d.accepted(this)}else{if(h==null){if(!i){throw"TokenException"}l[0]=-1;return null}else{this.__logprint("match failed: ",h);this.__puttrace();this._f_UNGET(h);l[0]=-9;return null}}}}}}if(this.__stk[this.__slen-1].emptyTransition(this)){}else{if(!this.__stk[this.__slen-1].dead(this)){h=this._read(m)}else{if(i){this.__logprint("accept "+this.__stk[this.__slen-1].toString());l[0]=-1;return null}else{if(this.__lookaheadw_ptr>=0){this.__logprint("match failed: try lookahead: ",h);this._f_LOOKAHEAD_RB();i=d.accepted(this)}else{if(h==null){if(!i){throw"TokenException"}l[0]=-1;return null}else{this.__logprint("match failed: ",h);this.__puttrace();l[0]=-9;return null}}}}}}while(true)}catch(g){this._f_UNGET(h);throw g}};SExpression.prototype.execfinally=function(){var d,c;if((d=this.__stk[this.__slen-1].finallyState(this))>=0){c=this.__state;this.__state=d;switch(this.__stk[this.__slen-1].execaction(this,-2)){case -91:this.__slen=0;return true;case -72:this.__slen=0;return false}this.__state=c}return null};SExpression.prototype.getdeadstate=function(){return this.__stk[this.__slen-1].deadState(this)};SExpression.prototype.getrecover=function(a){return this.__stk[this.__slen-1].recover(this,a)};SExpression.prototype.parse_generic=function(h,g){var j=SExpression.__SKIP__;var d=false;var f=[];this.__logopen();try{if(this.__slen==0){d=true;this.__stkpush(0,g)}ot:while(true){try{if((j=this._parse(h,j,d,f))!=null){}else{if(f[0]==-9){while((this.__state=this.getdeadstate())<0){if((d=this.execfinally())!=null){break ot}if(this.__slen--<=1){throw new SExpression_TokenException()}}j=SExpression.__SKIP__}else{if(f[0]==-91){if((d=this.execfinally())!=null){break}this.__slen=0;d=true;break}else{if(f[0]==-72){if((d=this.execfinally())!=null){break}this.__slen=0;d=false;break}else{if(f[0]==-85){return false}else{if(this.__slen>1){if((d=this.execfinally())!=null){break}this.__state=this.__sts[--this.__slen];j=SExpression.__SKIP__}else{if((d=this.execfinally())!=null){break}d=this.__stk[--this.__slen].accepted(this);break}}}}}}}catch(i){this.exception=i;if(this.__slen<=0){throw i}while((this.__state=this.getrecover(i))<0){if((d=this.execfinally())!=null){return d}if(this.__slen--<=1){throw i}}}d=true}if(!d){throw new SExpression_TokenException()}return d}finally{this.__logclose()}};SExpression.prototype.parse=function(a){return this.parse_generic(a,this.ENGINE_sExpression)};SExpression.prototype.setStream=function(a){if(this.befstream!=null){throw"IllegalStateException"}this.yieldObject=this.befstream=a};SExpression.prototype.parseNext=function(){var a;if(this.befstream==null){throw"IllegalStateException"}else{if(this.yieldObject==null){return null}else{if(this.parse(this.befstream,this.ENGINE_sExpression)){if(this.yieldObject==null){throw"NullPointerException"}a=this.yieldObject;this.yieldObject=null;return a}else{if(this.yieldObject==null){throw"NullPointerException"}return this.yieldObject}}}};SExpression.parseAll=function(a){return new SExpression().parse(a)};SExpression.parseStream=function(a){return SExpression.parseAll(function(){var d;d=a.read();return d<0?null:d})};SExpression.parseString=function(a){var c=0;return SExpression.parseAll(function(){return c<a.length?a.charCodeAt(c++):null})};SExpression.parseStdin=function(){return SExpression.parseStream(new java.io.InputStreamReader(java.lang.System["in"]))};function puts(a){java.lang.System.out.println(a)}SExpression.sharpHash={t:true,f:false};SExpression.charnameHash={newline:"\n".charCodeAt(0),space:" ".charCodeAt(0)};SExpression.prototype.initc=function(){if(this.sstack===undefined){this.sstack=[]}this.sstack.push({exp:undefined,ptr:undefined})};SExpression.prototype.addc=function(a){var c=this.sstack.pop();if(c.exp===undefined){c.exp=c.ptr=$mille.cons(a,$mille.nil)}else{c.ptr.cdr=$mille.cons(a,$mille.nil);c.ptr=c.ptr.cdr}this.sstack.push(c)};SExpression.prototype.endc=function(a){var c=this.sstack.pop();if(c.exp===undefined){return $mille.nil}else{c.ptr.cdr=a;return c.exp}};SExpression.prototype.initv=function(){if(this.sstack===undefined){this.sstack=[]}this.sstack.push([])};SExpression.prototype.addv=function(a){var c=this.sstack.pop();c.push(a);this.sstack.push(c)};SExpression.prototype.endv=function(a){return this.sstack.pop()};SExpression.prototype.quote=function(a){return $mille.cons($mille.getSymbol("quote"),$mille.cons(a,$mille.nil))};SExpression.prototype.qlambda=function(a){return $mille.cons($mille.getSymbol("lambda"),$mille.cons($mille.nil,$mille.cons(a,$mille.nil)))};SExpression.prototype.clearbuf=function(){this.buf=""};SExpression.prototype.addbuf=function(a){this.buf+=String.fromCharCode(a)};SExpression.prototype.str=function(e){var g,d,f="",a;for(d=1;d<e.length;d++){g=e.charAt(d);if(g!=="\\"){f+=g}else{if(d+1===e.length){$mille.o.error("Token exception")}else{if((g=e.charAt(++d))==="\\"){f+="\\\\"}else{if(g==='"'){f+='"'}else{if(g==="a"){f+="\u0007"}else{if(g==="b"){f+="\b"}else{if(g==="t"){f+="\t"}else{if(g==="n"){f+="\n"}else{if(g==="v"){f+="\u0008"}else{if(g==="f"){f+="\u000c"}else{if(g==="r"){f+="\r"}else{if(g==="x"||g==="u"){a="";while(++d<e.length){g=e.charAt(d);if((g>="0"&&g<="9")||(g>="a"&&g<="f")||(g>="A"&&g<="F")){a+=g}else{break}}if(a.length===0){$mille.o.error("Token Exception")}else{if((g=parseInt(a,16))>65535){$mille.o.error("invalid unicode")}else{f+=String.fromCharCode(g)}}}else{$mille.o.error("Invalid escape sequence")}}}}}}}}}}}}}return f};SExpression.prototype.sharp=function(c){var a;if((a=SExpression.sharpHash[c])!==undefined){return a}else{$mille.o.error("unknown sharp: "+c)}};SExpression.prototype.chrname=function(c){var a;if((a=SExpression.charnameHash[c])!==undefined){return a}else{$mille.o.error("unknown character name: "+c)}};SExpression.prototype.addch=function(a){this.buf+=String.fromCharCode(this.ch)};SExpression.prototype.sym=function(a){if(a.charAt(0)===":"){return $mille.getKeyword(a.substring(1))}else{return $mille.getSymbol(a)}};SExpression.prototype.newre=function(){if(this.buf===""){return new RegExp(this.re)}else{return new RegExp(this.re,this.buf)}};$mille.macroenv=$mille.newenv($env,this);$mille.macroenv.bind("macroenv",$mille.cons($mille.nil,$mille.nil));$mille.macroenv.bind("pattern-id",0);$mille.macroenv.bind("consf",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("y",a===undefined?null:a);return(((!((d.find("x"))===false)?(!((d.find("y"))===false)?$mille.apply(d.find("cons"),d.find("x"),d.find("y")):$mille.nil):false)))}));$mille.macroenv.bind("cdrf",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!((c.find("x"))===false)?$mille.apply(c.find("cdr"),c.find("x")):false)))}));$mille.macroenv.bind("ap2",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("y",a===undefined?null:a);return(((!(((!((d.find("x"))===false)?d.find("y"):false))===false)?(!(($mille.apply(d.find("null?"),d.find("x")))===false)?d.find("y"):$mille.apply(d.find("cons"),$mille.apply(d.find("car"),d.find("x")),$mille.apply(d.find("ap2"),$mille.apply(d.find("cdr"),d.find("x")),d.find("y")))):false)))}));$mille.macroenv.bind("pair?",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!(($mille.apply(c.find("null?"),c.find("x")))===false)?false:(!(($mille.apply(c.find("atom?"),c.find("x")))===false)?false:true))))}));$mille.macroenv.bind("gen-sym-id",0);$mille.macroenv.bind("gen-sym",$mille.closure($mille.macroenv,this,function(a){return(((a.set("gen-sym-id",$mille.apply(a.find("1+"),a.find("gen-sym-id"))),undefined)),($mille.apply(a.find("string->symbol"),$mille.apply(a.find("string-append"),"#",a.find("gen-sym-id")))))}));$mille.macroenv.bind("gen-sym?",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!(($mille.apply(c.find("symbol?"),c.find("x")))===false)?$mille.apply(c.find("eqv?"),$mille.apply(c.find("string-ref"),$mille.apply(c.find("symbol->string"),c.find("x")),0),35):false)))}));$mille.macroenv.bind("memq",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("o",c===undefined?null:c);d.bind("l",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("l")))===false)?false:(!(($mille.apply(d.find("eq?"),d.find("o"),$mille.apply(d.find("car"),d.find("l"))))===false)?d.find("l"):$mille.apply(d.find("memq"),d.find("o"),$mille.apply(d.find("cdr"),d.find("l")))))))}));$mille.macroenv.bind("assq",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("lis",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("lis")))===false)?false:(!(($mille.apply(d.find("eq?"),$mille.apply(d.find("car"),$mille.apply(d.find("car"),d.find("lis"))),d.find("x")))===false)?$mille.apply(d.find("car"),d.find("lis")):$mille.apply(d.find("assq"),d.find("x"),$mille.apply(d.find("cdr"),d.find("lis")))))))}));$mille.macroenv.bind("symbol-scoped?",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!(($mille.apply(c.find("symbol?"),c.find("x")))===false)?$mille.apply($mille.closure(c,this,function(e,d){e.bind("s",d===undefined?null:d);return(((!(($mille.apply(e.find(">"),$mille.apply(e.find("string-length"),e.find("s")),1))===false)?$mille.apply(e.find("eqv?"),$mille.apply(e.find("string-ref"),e.find("s"),0),58):false)))}),$mille.apply(c.find("symbol->string"),c.find("x"))):false)))}));$mille.macroenv.bind("add-scope",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!(((!(($mille.apply(c.find("symbol?"),c.find("x")))===false)?(!(($mille.apply(c.find("gen-sym?"),c.find("x")))===false)?true:$mille.apply(c.find("symbol-scoped?"),c.find("x"))):true))===false)?c.find("x"):$mille.apply(c.find("string->symbol"),$mille.apply(c.find("string-append"),":",c.find("pattern-id"),"#",$mille.apply(c.find("symbol->string"),c.find("x")))))))}));$mille.macroenv.bind("remove-scope-string",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("k",a===undefined?null:a);return(((!(($mille.apply(d.find("eqv?"),$mille.apply(d.find("string-ref"),d.find("x"),d.find("k")),35))===false)?$mille.apply(d.find("substring"),d.find("x"),$mille.apply(d.find("1+"),d.find("k")),$mille.apply(d.find("string-length"),d.find("x"))):$mille.apply(d.find("remove-scope-string"),d.find("x"),$mille.apply(d.find("1+"),d.find("k"))))))}));$mille.macroenv.bind("remove-scope",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!(((!(($mille.apply(c.find("gen-sym?"),c.find("x")))===false)?false:$mille.apply(c.find("symbol-scoped?"),c.find("x"))))===false)?$mille.apply(c.find("string->symbol"),$mille.apply(c.find("remove-scope-string"),$mille.apply(c.find("symbol->string"),c.find("x")),0)):c.find("x"))))}));$mille.macroenv.bind("remove-all-scope",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!(($mille.apply(c.find("null?"),c.find("x")))===false)?c.find("x"):(!(($mille.apply(c.find("pair?"),c.find("x")))===false)?$mille.apply(c.find("cons"),$mille.apply(c.find("remove-all-scope"),$mille.apply(c.find("car"),c.find("x"))),$mille.apply(c.find("remove-all-scope"),$mille.apply(c.find("cdr"),c.find("x")))):$mille.apply(c.find("remove-scope"),c.find("x"))))))}));$mille.macroenv.bind("compile-macro",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!(($mille.apply(c.find("null?"),c.find("x")))===false)?$mille.nil:(!(($mille.apply(c.find("pair?"),c.find("x")))===false)?(!(($mille.apply(c.find("eq?"),$mille.getSymbol("..."),$mille.apply(c.find("car"),c.find("x"))))===false)?$mille.apply(c.find("error"),"ellipse"):(!(($mille.apply(c.find("pair?"),$mille.apply(c.find("cdr"),c.find("x"))))===false)?(!(($mille.apply(c.find("eq?"),$mille.getSymbol("..."),$mille.apply(c.find("car"),$mille.apply(c.find("cdr"),c.find("x")))))===false)?$mille.apply(c.find("cons"),$mille.apply(c.find("cons"),$mille.getSymbol("..."),$mille.apply(c.find("compile-macro"),$mille.apply(c.find("car"),c.find("x")))),$mille.apply(c.find("compile-macro"),$mille.apply(c.find("cdr"),$mille.apply(c.find("cdr"),c.find("x"))))):$mille.apply(c.find("cons"),$mille.apply(c.find("compile-macro"),$mille.apply(c.find("car"),c.find("x"))),$mille.apply(c.find("compile-macro"),$mille.apply(c.find("cdr"),c.find("x"))))):$mille.apply(c.find("cons"),$mille.apply(c.find("compile-macro"),$mille.apply(c.find("car"),c.find("x"))),$mille.apply(c.find("compile-macro"),$mille.apply(c.find("cdr"),c.find("x")))))):c.find("x")))))}));$mille.macroenv.bind("match-pattern-ellipse-vec",$mille.closure($mille.macroenv,this,function(e,d,c,a,g,f){e.bind("x",d===undefined?null:d);e.bind("y",c===undefined?null:c);e.bind("k",a===undefined?null:a);e.bind("l",g===undefined?null:g);e.bind("res",f===undefined?null:f);return(((!(($mille.apply(e.find("eqv?"),e.find("k"),e.find("l")))===false)?$mille.nil:$mille.apply(e.find("consf"),$mille.apply(e.find("match-pattern"),e.find("x"),$mille.apply(e.find("vector-ref"),e.find("y"),e.find("k")),e.find("res")),$mille.apply(e.find("match-pattern-ellipse-vec"),e.find("x"),e.find("y"),$mille.apply(e.find("1+"),e.find("k")),e.find("l"),e.find("res"))))))}));$mille.macroenv.bind("vec-ellipse?",$mille.closure($mille.macroenv,this,function(e,d,c,a){e.bind("x",d===undefined?null:d);e.bind("k",c===undefined?null:c);e.bind("l",a===undefined?null:a);return(((!(($mille.apply(e.find("<"),e.find("k"),$mille.apply(e.find("1-"),e.find("l"))))===false)?$mille.apply(e.find("eq?"),$mille.apply(e.find("vector-ref"),e.find("x"),$mille.apply(e.find("1+"),e.find("k"))),$mille.getSymbol("...")):false)))}));$mille.macroenv.bind("match-pattern-vec",$mille.closure($mille.macroenv,this,function(e,d,c,a,g,f){e.bind("x",d===undefined?null:d);e.bind("y",c===undefined?null:c);e.bind("k",a===undefined?null:a);e.bind("l",g===undefined?null:g);e.bind("res",f===undefined?null:f);return(((!(($mille.apply(e.find("eqv?"),e.find("k"),e.find("l")))===false)?$mille.nil:(!(($mille.apply(e.find("vec-ellipse?"),e.find("x"),e.find("k"),e.find("l")))===false)?$mille.apply(e.find("cons"),$mille.apply(e.find("match-pattern-ellipse-vec"),$mille.apply(e.find("vector-ref"),e.find("x"),e.find("k")),e.find("y"),e.find("k"),e.find("l"),e.find("res")),$mille.nil):$mille.apply(e.find("ap2"),$mille.apply(e.find("match-pattern"),$mille.apply(e.find("vector-ref"),e.find("x"),e.find("k")),$mille.apply(e.find("vector-ref"),e.find("y"),e.find("k")),e.find("res")),$mille.apply(e.find("match-pattern-vec"),e.find("x"),e.find("y"),$mille.apply(e.find("1+"),e.find("k")),e.find("l"),e.find("res")))))))}));$mille.macroenv.bind("match-pattern-ellipse",$mille.closure($mille.macroenv,this,function(e,d,c,a){e.bind("x",d===undefined?null:d);e.bind("y",c===undefined?null:c);e.bind("res",a===undefined?null:a);return(((!(($mille.apply(e.find("null?"),e.find("y")))===false)?$mille.nil:$mille.apply(e.find("consf"),$mille.apply(e.find("match-pattern"),e.find("x"),$mille.apply(e.find("car"),e.find("y")),e.find("res")),$mille.apply(e.find("match-pattern-ellipse"),e.find("x"),$mille.apply(e.find("cdr"),e.find("y")),e.find("res"))))))}));$mille.macroenv.bind("match-pattern",$mille.closure($mille.macroenv,this,function(e,d,c,a){e.bind("x",d===undefined?null:d);e.bind("y",c===undefined?null:c);e.bind("res",a===undefined?null:a);return(((!(($mille.apply(e.find("null?"),e.find("x")))===false)?(!(($mille.apply(e.find("null?"),e.find("y")))===false)?$mille.nil:false):(!(($mille.apply(e.find("pair?"),e.find("x")))===false)?(!(((!(($mille.apply(e.find("pair?"),$mille.apply(e.find("car"),e.find("x"))))===false)?$mille.apply(e.find("eq?"),$mille.apply(e.find("car"),$mille.apply(e.find("car"),e.find("x"))),$mille.getSymbol("...")):false))===false)?(!(($mille.apply(e.find("pair?"),e.find("y")))===false)?$mille.apply(e.find("cons"),$mille.apply(e.find("match-pattern-ellipse"),$mille.apply(e.find("cdr"),$mille.apply(e.find("car"),e.find("x"))),e.find("y"),e.find("res")),$mille.nil):(!(($mille.apply(e.find("null?"),e.find("y")))===false)?$mille.nil:false)):(!(($mille.apply(e.find("pair?"),e.find("y")))===false)?$mille.apply(e.find("ap2"),$mille.apply(e.find("match-pattern"),$mille.apply(e.find("car"),e.find("x")),$mille.apply(e.find("car"),e.find("y")),e.find("res")),$mille.apply(e.find("match-pattern"),$mille.apply(e.find("cdr"),e.find("x")),$mille.apply(e.find("cdr"),e.find("y")),e.find("res"))):false)):(!(((!(($mille.apply(e.find("vector?"),e.find("x")))===false)?$mille.apply(e.find("vector?"),e.find("y")):false))===false)?$mille.apply(e.find("match-pattern-vec"),e.find("x"),e.find("y"),0,$mille.apply(e.find("vector-length"),e.find("y")),e.find("res")):(!(($mille.apply(e.find("string?"),e.find("x")))===false)?(!(((!(($mille.apply(e.find("string?"),e.find("y")))===false)?$mille.apply(e.find("eqv?"),e.find("x"),e.find("y")):false))===false)?$mille.nil:false):(!(((!(($mille.apply(e.find("symbol?"),e.find("x")))===false)?$mille.apply(e.find("memq"),e.find("x"),e.find("res")):true))===false)?(!(($mille.apply(e.find("eqv?"),e.find("x"),$mille.apply(e.find("remove-scope"),e.find("y"))))===false)?$mille.nil:false):$mille.apply(e.find("cons"),$mille.apply(e.find("cons"),e.find("x"),e.find("y")),$mille.nil))))))))}));$mille.macroenv.bind("extract-idx2",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("k",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("e")))===false)?$mille.nil:(!(($mille.apply(d.find("eqv?"),d.find("k"),0))===false)?$mille.apply(d.find("car"),d.find("e")):$mille.apply(d.find("extract-idx2"),$mille.apply(d.find("1-"),d.find("k")),$mille.apply(d.find("cdr"),d.find("e")))))))}));$mille.macroenv.bind("assoc-any?",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("s",c===undefined?null:c);d.bind("a",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("s")))===false)?false:(!(($mille.apply(d.find("assq"),$mille.apply(d.find("car"),d.find("s")),d.find("a")))===false)?true:$mille.apply(d.find("assoc-any?"),$mille.apply(d.find("cdr"),d.find("s")),d.find("a"))))))}));$mille.macroenv.bind("next-idx?",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("s",a===undefined?null:a);return(((!(($mille.apply(d.find("symbol?"),d.find("x")))===false)?false:(!(($mille.apply(d.find("pair?"),$mille.apply(d.find("car"),d.find("x"))))===false)?(!(($mille.apply(d.find("assoc-any?"),d.find("s"),d.find("x")))===false)?true:$mille.apply(d.find("pair?"),$mille.apply(d.find("car"),$mille.apply(d.find("car"),d.find("x"))))):$mille.apply(d.find("null?"),$mille.apply(d.find("car"),d.find("x")))))))}));$mille.macroenv.bind("extract-idx",$mille.closure($mille.macroenv,this,function(e,d,c,a){e.bind("m",d===undefined?null:d);e.bind("e",c===undefined?null:c);e.bind("s",a===undefined?null:a);return(((!(($mille.apply(e.find("null?"),e.find("e")))===false)?$mille.nil:(!(($mille.apply(e.find("null?"),$mille.apply(e.find("car"),e.find("e"))))===false)?$mille.apply(e.find("extract-idx"),e.find("m"),$mille.apply(e.find("cdr"),e.find("e")),e.find("s")):(!(($mille.apply(e.find("next-idx?"),$mille.apply(e.find("car"),$mille.apply(e.find("car"),e.find("e"))),e.find("s")))===false)?$mille.apply(e.find("ap2"),$mille.apply(e.find("extract-idx2"),e.find("m"),$mille.apply(e.find("car"),e.find("e"))),$mille.apply(e.find("extract-idx"),e.find("m"),$mille.apply(e.find("cdr"),e.find("e")),e.find("s"))):$mille.apply(e.find("extract-idx"),e.find("m"),$mille.apply(e.find("cdr"),e.find("e")),e.find("s")))))))}));$mille.macroenv.bind("extract-symbols-vec",$mille.closure($mille.macroenv,this,function(e,d,c,a){e.bind("x",d===undefined?null:d);e.bind("k",c===undefined?null:c);e.bind("l",a===undefined?null:a);return(((!(($mille.apply(e.find("eqv?"),e.find("k"),e.find("l")))===false)?$mille.nil:$mille.apply(e.find("ap2"),$mille.apply(e.find("extract-symbols"),$mille.apply(e.find("vector-ref"),e.find("x"),e.find("k"))),$mille.apply(e.find("extract-symbols-vec"),e.find("x"),$mille.apply(e.find("1+"),e.find("k")),e.find("l"))))))}));$mille.macroenv.bind("extract-symbols",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!(($mille.apply(c.find("null?"),c.find("x")))===false)?$mille.nil:(!(($mille.apply(c.find("pair?"),c.find("x")))===false)?$mille.apply(c.find("ap2"),$mille.apply(c.find("extract-symbols"),$mille.apply(c.find("car"),c.find("x"))),$mille.apply(c.find("extract-symbols"),$mille.apply(c.find("cdr"),c.find("x")))):(!(($mille.apply(c.find("vector?"),c.find("x")))===false)?$mille.apply(c.find("extract-symbols-vec"),c.find("x"),0,$mille.apply(c.find("vector-length"),c.find("x"))):(!(($mille.apply(c.find("symbol?"),c.find("x")))===false)?$mille.apply(c.find("cons"),c.find("x"),$mille.nil):$mille.nil))))))}));$mille.macroenv.bind("replace-pattern-ellipse1",$mille.closure($mille.macroenv,this,function(e,d,c,a,f){e.bind("x",d===undefined?null:d);e.bind("e",c===undefined?null:c);e.bind("k",a===undefined?null:a);e.bind("s",f===undefined?null:f);return(($mille.apply($mille.closure(e,this,function(h,g){h.bind("v",g===undefined?null:g);return(((!(($mille.apply(h.find("null?"),h.find("v")))===false)?$mille.nil:$mille.apply(h.find("cons"),$mille.apply(h.find("replace-pattern1"),h.find("x"),h.find("v")),$mille.apply(h.find("replace-pattern-ellipse1"),h.find("x"),h.find("e"),$mille.apply(h.find("1+"),h.find("k")),h.find("s"))))))}),$mille.apply(e.find("extract-idx"),e.find("k"),e.find("e"),e.find("s")))))}));$mille.macroenv.bind("replace-pattern-ellipse",$mille.closure($mille.macroenv,this,function(e,d,c,a){e.bind("x",d===undefined?null:d);e.bind("e",c===undefined?null:c);e.bind("k",a===undefined?null:a);return(($mille.apply(e.find("replace-pattern-ellipse1"),e.find("x"),e.find("e"),e.find("k"),$mille.apply(e.find("extract-symbols"),e.find("x")))))}));$mille.macroenv.bind("replace-pattern-ellipse-length1",$mille.closure($mille.macroenv,this,function(e,d,c,a){e.bind("e",d===undefined?null:d);e.bind("k",c===undefined?null:c);e.bind("s",a===undefined?null:a);return(($mille.apply($mille.closure(e,this,function(g,f){g.bind("v",f===undefined?null:f);return(((!(($mille.apply(g.find("null?"),g.find("v")))===false)?g.find("k"):$mille.apply(g.find("replace-pattern-ellipse-length1"),g.find("e"),$mille.apply(g.find("1+"),g.find("k")),g.find("s")))))}),$mille.apply(e.find("extract-idx"),e.find("k"),e.find("e"),e.find("s")))))}));$mille.macroenv.bind("replace-pattern-ellipse-length",$mille.closure($mille.macroenv,this,function(e,d,c,a){e.bind("x",d===undefined?null:d);e.bind("e",c===undefined?null:c);e.bind("k",a===undefined?null:a);return(($mille.apply(e.find("replace-pattern-ellipse-length1"),e.find("e"),e.find("k"),$mille.apply(e.find("extract-symbols"),e.find("x")))))}));$mille.macroenv.bind("replace-pattern-vec-length",$mille.closure($mille.macroenv,this,function(e,d,c,a,f){e.bind("x",d===undefined?null:d);e.bind("k",c===undefined?null:c);e.bind("l",a===undefined?null:a);e.bind("e",f===undefined?null:f);return(((!(($mille.apply(e.find("eqv?"),e.find("k"),e.find("l")))===false)?e.find("k"):(!(($mille.apply(e.find("vec-ellipse?"),e.find("x"),e.find("k"),e.find("l")))===false)?$mille.apply(e.find("replace-pattern-ellipse-length"),e.find("x"),e.find("e"),e.find("k")):$mille.apply(e.find("replace-pattern-vec-length"),e.find("x"),$mille.apply(e.find("1+"),e.find("k")),e.find("l"),e.find("e"))))))}));$mille.macroenv.bind("replace-pattern-ellipse-vec1",$mille.closure($mille.macroenv,this,function(e,d,c,a,g,f){e.bind("x",d===undefined?null:d);e.bind("e",c===undefined?null:c);e.bind("k",a===undefined?null:a);e.bind("s",g===undefined?null:g);e.bind("z",f===undefined?null:f);return(($mille.apply($mille.closure(e,this,function(i,h){i.bind("v",h===undefined?null:h);return(((!(($mille.apply(i.find("null?"),i.find("v")))===false)?i.find("z"):(($mille.apply(i.find("vector-set!"),i.find("z"),i.find("k"),$mille.apply(i.find("replace-pattern1"),i.find("x"),i.find("v")))),($mille.apply(i.find("replace-pattern-ellipse-vec1"),i.find("x"),i.find("e"),$mille.apply(i.find("1+"),i.find("k")),i.find("s"),i.find("z")))))))}),$mille.apply(e.find("extract-idx"),e.find("k"),e.find("e"),e.find("s")))))}));$mille.macroenv.bind("replace-pattern-ellipse-vec",$mille.closure($mille.macroenv,this,function(e,d,c,a,f){e.bind("x",d===undefined?null:d);e.bind("e",c===undefined?null:c);e.bind("k",a===undefined?null:a);e.bind("v",f===undefined?null:f);return(($mille.apply(e.find("replace-pattern-ellipse-vec1"),e.find("x"),e.find("e"),e.find("k"),$mille.apply(e.find("extract-symbols"),e.find("x")),e.find("v"))))}));$mille.macroenv.bind("replace-pattern-vec1",$mille.closure($mille.macroenv,this,function(e,d,c,a,g,f){e.bind("x",d===undefined?null:d);e.bind("k",c===undefined?null:c);e.bind("l",a===undefined?null:a);e.bind("e",g===undefined?null:g);e.bind("v",f===undefined?null:f);return(((!(($mille.apply(e.find("eqv?"),e.find("k"),e.find("l")))===false)?e.find("v"):(!(($mille.apply(e.find("vec-ellipse?"),e.find("x"),e.find("k"),e.find("l")))===false)?$mille.apply(e.find("replace-pattern-ellipse-vec"),$mille.apply(e.find("vector-ref"),e.find("x"),e.find("k")),e.find("e"),e.find("k"),e.find("v")):(($mille.apply(e.find("vector-set!"),e.find("v"),e.find("k"),$mille.apply(e.find("replace-pattern1"),$mille.apply(e.find("vector-ref"),e.find("x"),e.find("k")),e.find("e")))),($mille.apply(e.find("replace-pattern-vec1"),e.find("x"),$mille.apply(e.find("1+"),e.find("k")),e.find("l"),e.find("e"),e.find("v"))))))))}));$mille.macroenv.bind("replace-pattern-vec",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return((d.bind("l",$mille.apply(d.find("replace-pattern-vec-length"),d.find("x"),0,$mille.apply(d.find("vector-length"),d.find("x")),d.find("e")))),($mille.apply(d.find("replace-pattern-vec1"),d.find("x"),0,d.find("l"),d.find("e"),$mille.apply(d.find("make-vector"),d.find("l")))))}));$mille.macroenv.bind("replace-pattern1",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("x")))===false)?$mille.nil:(!(($mille.apply(d.find("pair?"),d.find("x")))===false)?(!(((!(($mille.apply(d.find("pair?"),$mille.apply(d.find("car"),d.find("x"))))===false)?$mille.apply(d.find("eq?"),$mille.apply(d.find("car"),$mille.apply(d.find("car"),d.find("x"))),$mille.getSymbol("...")):false))===false)?$mille.apply(d.find("ap2"),$mille.apply(d.find("replace-pattern-ellipse"),$mille.apply(d.find("cdr"),$mille.apply(d.find("car"),d.find("x"))),d.find("e"),0),$mille.apply(d.find("replace-pattern1"),$mille.apply(d.find("cdr"),d.find("x")),d.find("e"))):$mille.apply(d.find("cons"),$mille.apply(d.find("replace-pattern1"),$mille.apply(d.find("car"),d.find("x")),d.find("e")),$mille.apply(d.find("replace-pattern1"),$mille.apply(d.find("cdr"),d.find("x")),d.find("e")))):(!(($mille.apply(d.find("vector?"),d.find("x")))===false)?$mille.apply(d.find("replace-pattern-vec"),d.find("x"),d.find("e")):(!(($mille.apply(d.find("assq"),d.find("x"),d.find("e")))===false)?$mille.apply(d.find("cdr"),$mille.apply(d.find("assq"),d.find("x"),d.find("e"))):$mille.apply(d.find("add-scope"),d.find("x"))))))))}));$mille.macroenv.bind("replace-pattern",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(((d.set("pattern-id",$mille.apply(d.find("1+"),d.find("pattern-id"))),undefined)),($mille.apply(d.find("replace-pattern1"),d.find("x"),d.find("e"))))}));$mille.macroenv.bind("add-local-env-lambda",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("x")))===false)?d.find("e"):$mille.apply(d.find("cons"),$mille.apply(d.find("cons"),$mille.apply(d.find("car"),d.find("x")),$mille.apply(d.find("gen-sym"))),$mille.apply(d.find("add-local-env-lambda"),$mille.apply(d.find("cdr"),d.find("x")),d.find("e"))))))}));$mille.macroenv.bind("add-local-env-letrec",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("x")))===false)?d.find("e"):$mille.apply(d.find("cons"),$mille.apply(d.find("cons"),$mille.apply(d.find("car"),$mille.apply(d.find("car"),d.find("x"))),$mille.apply(d.find("gen-sym"))),$mille.apply(d.find("add-local-env-letrec"),$mille.apply(d.find("cdr"),d.find("x")),d.find("e"))))))}));$mille.macroenv.bind("replace-local-lambda",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(($mille.apply(d.find("replace-local-vals"),d.find("x"),$mille.apply(d.find("add-local-env-lambda"),$mille.apply(d.find("car"),d.find("x")),d.find("e")))))}));$mille.macroenv.bind("replace-local-letrec",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(($mille.apply(d.find("replace-local-vals"),d.find("x"),$mille.apply(d.find("add-local-env-letrec"),$mille.apply(d.find("car"),d.find("x")),d.find("e")))))}));$mille.macroenv.bind("replace-local-inst",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(((!(((!(($mille.apply(d.find("eq?"),$mille.getSymbol("lambda"),$mille.apply(d.find("remove-scope"),$mille.apply(d.find("car"),d.find("x")))))===false)?(!(($mille.apply(d.find("null?"),$mille.apply(d.find("cdr"),d.find("x"))))===false)?false:true):false))===false)?$mille.apply(d.find("cons"),$mille.getSymbol("lambda"),$mille.apply(d.find("replace-local-lambda"),$mille.apply(d.find("cdr"),d.find("x")),d.find("e"))):(!(($mille.apply(d.find("eq?"),$mille.getSymbol("letrec"),$mille.apply(d.find("remove-scope"),$mille.apply(d.find("car"),d.find("x")))))===false)?$mille.apply(d.find("cons"),$mille.getSymbol("letrec"),$mille.apply(d.find("replace-local-letrec"),$mille.apply(d.find("cdr"),d.find("x")),d.find("e"))):$mille.apply(d.find("cons"),$mille.apply(d.find("replace-local-vals"),$mille.apply(d.find("car"),d.find("x")),d.find("e")),$mille.apply(d.find("replace-local-vals"),$mille.apply(d.find("cdr"),d.find("x")),d.find("e")))))))}));$mille.macroenv.bind("replace-local-vals",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("x")))===false)?$mille.nil:(!(($mille.apply(d.find("assq"),d.find("x"),d.find("e")))===false)?$mille.apply(d.find("cdr"),$mille.apply(d.find("assq"),d.find("x"),d.find("e"))):(!(($mille.apply(d.find("pair?"),d.find("x")))===false)?$mille.apply(d.find("replace-local-inst"),d.find("x"),d.find("e")):d.find("x"))))))}));$mille.macroenv.bind("extract-level",$mille.closure($mille.macroenv,this,function(e,d,c,a){e.bind("x",d===undefined?null:d);e.bind("k",c===undefined?null:c);e.bind("e",a===undefined?null:a);return(((!(($mille.apply(e.find("null?"),e.find("x")))===false)?$mille.nil:(!(($mille.apply(e.find("pair?"),e.find("x")))===false)?(!(($mille.apply(e.find("eq?"),$mille.apply(e.find("car"),e.find("x")),$mille.getSymbol("...")))===false)?$mille.apply(e.find("extract-level"),$mille.apply(e.find("cdr"),e.find("x")),$mille.apply(e.find("1+"),e.find("k")),e.find("e")):$mille.apply(e.find("ap2"),$mille.apply(e.find("extract-level"),$mille.apply(e.find("car"),e.find("x")),e.find("k"),e.find("e")),$mille.apply(e.find("extract-level"),$mille.apply(e.find("cdr"),e.find("x")),e.find("k"),e.find("e")))):(!(($mille.apply(e.find("symbol?"),e.find("x")))===false)?$mille.apply(e.find("cons"),$mille.apply(e.find("cons"),e.find("x"),e.find("k")),$mille.nil):$mille.nil)))))}));$mille.macroenv.bind("eqv-assoc?",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("f",a===undefined?null:a);return(((!(($mille.apply(d.find("assq"),$mille.apply(d.find("car"),d.find("x")),d.find("f")))===false)?$mille.apply(d.find("eqv?"),$mille.apply(d.find("cdr"),$mille.apply(d.find("assq"),$mille.apply(d.find("car"),d.find("x")),d.find("f"))),$mille.apply(d.find("cdr"),d.find("x"))):true)))}));$mille.macroenv.bind("check-level-num?",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("e",c===undefined?null:c);d.bind("f",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("e")))===false)?true:(!(($mille.apply(d.find("eqv-assoc?"),$mille.apply(d.find("car"),d.find("e")),d.find("f")))===false)?$mille.apply(d.find("check-level-num?"),$mille.apply(d.find("cdr"),d.find("e")),d.find("f")):false))))}));$mille.macroenv.bind("check-level?",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("y",a===undefined?null:a);return(($mille.apply(d.find("check-level-num?"),$mille.apply(d.find("extract-level"),d.find("x"),0,$mille.nil),$mille.apply(d.find("extract-level"),d.find("y"),0,$mille.nil))))}));$mille.macroenv.bind("check-level-and-cons",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("y",a===undefined?null:a);return(((!(($mille.apply(d.find("check-level?"),d.find("x"),d.find("y")))===false)?$mille.apply(d.find("cons"),d.find("x"),d.find("y")):$mille.apply(d.find("error"),"level"))))}));$mille.macroenv.bind("eval-syntax-rules1",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!(($mille.apply(c.find("null?"),$mille.apply(c.find("cdr"),$mille.apply(c.find("cdr"),c.find("x")))))===false)?true:$mille.apply(c.find("error"),"syntax-rules"))),($mille.apply(c.find("check-level-and-cons"),$mille.apply(c.find("compile-macro"),$mille.apply(c.find("car"),c.find("x"))),$mille.apply(c.find("compile-macro"),$mille.apply(c.find("car"),$mille.apply(c.find("cdr"),c.find("x")))))))}));$mille.macroenv.bind("eval-syntax-rules-list",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!(($mille.apply(c.find("null?"),c.find("x")))===false)?$mille.nil:$mille.apply(c.find("cons"),$mille.apply(c.find("eval-syntax-rules1"),$mille.apply(c.find("car"),c.find("x"))),$mille.apply(c.find("eval-syntax-rules-list"),$mille.apply(c.find("cdr"),c.find("x")))))))}));$mille.macroenv.bind("eval-syntax-rules",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cons"),$mille.apply(c.find("car"),c.find("x")),$mille.apply(c.find("eval-syntax-rules-list"),$mille.apply(c.find("cdr"),c.find("x"))))))}));$mille.macroenv.bind("eval-syntax-spec",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!(($mille.apply(c.find("eq?"),$mille.getSymbol("syntax-rules"),$mille.apply(c.find("car"),c.find("x"))))===false)?$mille.apply(c.find("eval-syntax-rules"),$mille.apply(c.find("cdr"),c.find("x"))):$mille.apply(c.find("error"),"error"))))}));$mille.macroenv.bind("find-env",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("e")))===false)?false:(!(($mille.apply(d.find("assq"),d.find("x"),$mille.apply(d.find("car"),d.find("e"))))===false)?$mille.apply(d.find("assq"),d.find("x"),$mille.apply(d.find("car"),d.find("e"))):$mille.apply(d.find("find-env"),d.find("x"),$mille.apply(d.find("cdr"),d.find("e")))))))}));$mille.macroenv.bind("cons-env",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("a",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(($mille.apply(d.find("cons"),d.find("a"),d.find("e"))))}));$mille.macroenv.bind("eval-replace-list",$mille.closure($mille.macroenv,this,function(e,d,c,a){e.bind("x",d===undefined?null:d);e.bind("s",c===undefined?null:c);e.bind("l",a===undefined?null:a);return(((!(($mille.apply(e.find("null?"),e.find("l")))===false)?$mille.apply(e.find("error"),"malformed"):$mille.apply($mille.closure(e,this,function(g,f){g.bind("v",f===undefined?null:f);return(((!((g.find("v"))===false)?$mille.apply(g.find("replace-local-vals"),$mille.apply(g.find("replace-pattern"),$mille.apply(g.find("cdr"),$mille.apply(g.find("car"),g.find("l"))),g.find("v")),$mille.nil):$mille.apply(g.find("eval-replace-list"),g.find("x"),g.find("s"),$mille.apply(g.find("cdr"),g.find("l"))))))}),$mille.apply(e.find("match-pattern"),$mille.apply(e.find("car"),$mille.apply(e.find("car"),e.find("l"))),e.find("x"),e.find("s"))))))}));$mille.macroenv.bind("eval-replace1",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(($mille.apply($mille.closure(d,this,function(f,e){f.bind("v",e===undefined?null:e);return(((!((f.find("v"))===false)?$mille.apply(f.find("cons"),$mille.apply(f.find("eval-replace-list"),f.find("x"),$mille.apply(f.find("car"),$mille.apply(f.find("car"),f.find("v"))),$mille.apply(f.find("cdr"),$mille.apply(f.find("car"),f.find("v")))),$mille.apply(f.find("cdr"),f.find("v"))):false)))}),$mille.apply(d.find("cdrf"),$mille.apply(d.find("find-env"),$mille.apply(d.find("remove-scope"),$mille.apply(d.find("car"),d.find("x"))),d.find("e"))))))}));$mille.macroenv.bind("eval-replace",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(((!(($mille.apply(d.find("pair?"),d.find("x")))===false)?$mille.apply($mille.closure(d,this,function(f,e){f.bind("v",e===undefined?null:e);return(((!((f.find("v"))===false)?$mille.apply(f.find("eval-macro1"),$mille.apply(f.find("car"),f.find("v")),$mille.apply(f.find("cdr"),f.find("v"))):f.find("x"))))}),$mille.apply(d.find("eval-replace1"),d.find("x"),d.find("e"))):d.find("x"))))}));$mille.macroenv.bind("eval-define-syntax!",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(($mille.apply($mille.closure(d,this,function(f,e){f.bind("v",e===undefined?null:e);return(((!((f.find("v"))===false)?$mille.apply(f.find("set-cdr!"),f.find("v"),$mille.apply(f.find("cons"),$mille.apply(f.find("eval-syntax-spec"),$mille.apply(f.find("car"),$mille.apply(f.find("cdr"),f.find("x")))),f.find("e"))):$mille.apply(f.find("set-car!"),f.find("e"),$mille.apply(f.find("cons"),$mille.apply(f.find("cons"),$mille.apply(f.find("car"),f.find("x")),$mille.apply(f.find("cons"),$mille.apply(f.find("eval-syntax-spec"),$mille.apply(f.find("car"),$mille.apply(f.find("cdr"),f.find("x")))),f.find("e"))),$mille.apply(f.find("car"),f.find("e")))))))}),$mille.apply(d.find("find-env"),$mille.apply(d.find("car"),d.find("x")),d.find("e")))))}));$mille.macroenv.bind("eval-let-syntax",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("x")))===false)?$mille.nil:$mille.apply(d.find("cons"),$mille.apply(d.find("cons"),$mille.apply(d.find("car"),$mille.apply(d.find("car"),d.find("x"))),$mille.apply(d.find("cons"),$mille.apply(d.find("eval-syntax-spec"),$mille.apply(d.find("car"),$mille.apply(d.find("cdr"),$mille.apply(d.find("car"),d.find("x"))))),d.find("e"))),$mille.apply(d.find("eval-let-syntax"),$mille.apply(d.find("cdr"),d.find("x")),d.find("e"))))))}));$mille.macroenv.bind("eval-letrec-syntax!",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("x")))===false)?d.find("e"):(($mille.apply(d.find("set-car!"),d.find("e"),$mille.apply(d.find("cons"),$mille.apply(d.find("cons"),$mille.apply(d.find("car"),$mille.apply(d.find("car"),d.find("x"))),$mille.apply(d.find("cons"),$mille.apply(d.find("eval-syntax-spec"),$mille.apply(d.find("car"),$mille.apply(d.find("cdr"),$mille.apply(d.find("car"),d.find("x"))))),d.find("e"))),$mille.apply(d.find("car"),d.find("e"))))),($mille.apply(d.find("eval-letrec-syntax!"),$mille.apply(d.find("cdr"),d.find("x")),d.find("e")))))))}));$mille.macroenv.bind("eval-macro1",$mille.closure($mille.macroenv,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("e",a===undefined?null:a);return(($mille.apply($mille.closure(d,this,function(f,e){f.bind("v",e===undefined?null:e);return(((!(($mille.apply(f.find("pair?"),f.find("v")))===false)?(!(($mille.apply(f.find("eq?"),$mille.getSymbol("define-syntax"),$mille.apply(f.find("car"),f.find("v"))))===false)?$mille.apply(f.find("eval-define-syntax!"),$mille.apply(f.find("cdr"),f.find("v")),f.find("e")):(!(($mille.apply(f.find("eq?"),$mille.getSymbol("let-syntax"),$mille.apply(f.find("car"),f.find("v"))))===false)?$mille.apply(f.find("cons"),$mille.getSymbol("begin"),$mille.apply(f.find("eval-macro1"),$mille.apply(f.find("cdr"),$mille.apply(f.find("cdr"),f.find("v"))),$mille.apply(f.find("cons-env"),$mille.apply(f.find("eval-let-syntax"),$mille.apply(f.find("car"),$mille.apply(f.find("cdr"),f.find("v"))),f.find("e")),f.find("e")))):(!(($mille.apply(f.find("eq?"),$mille.getSymbol("letrec-syntax"),$mille.apply(f.find("car"),f.find("v"))))===false)?$mille.apply(f.find("cons"),$mille.getSymbol("begin"),$mille.apply(f.find("eval-macro1"),$mille.apply(f.find("cdr"),$mille.apply(f.find("cdr"),f.find("v"))),$mille.apply(f.find("eval-letrec-syntax!"),$mille.apply(f.find("car"),$mille.apply(f.find("cdr"),f.find("v"))),$mille.apply(f.find("cons-env"),$mille.nil,f.find("e"))))):$mille.apply(f.find("cons"),$mille.apply(f.find("eval-macro1"),$mille.apply(f.find("car"),f.find("v")),f.find("e")),$mille.apply(f.find("eval-macro1"),$mille.apply(f.find("cdr"),f.find("v")),f.find("e")))))):f.find("v"))))}),$mille.apply(d.find("eval-replace"),d.find("x"),d.find("e")))))}));$mille.macroenv.bind("eval-macro",$mille.closure($mille.macroenv,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("remove-all-scope"),$mille.apply(c.find("eval-macro1"),c.find("x"),c.find("macroenv")))))}));$mille.macroenv.call("eval-macro",$mille.readString("(define-syntax and		  (syntax-rules ()		    ((_) #t)		    ((_ e1) e1)		    ((_ e1 e2 ...) (if e1 (and e2 ...) #f))))"));$mille.macroenv.call("eval-macro",$mille.readString("(define-syntax or		  (syntax-rules ()		    ((_) #f)		    ((_ e1) e1)		    ((_ e1 e2 ...)		       (let ((x e1))		         (if x x (or e2 ...))))))"));$mille.macroenv.call("eval-macro",$mille.readString("(define-syntax cond		  (syntax-rules (else =>)		    ((_ (else r1 r2 ...)) (begin r1 r2 ...))		    ((_ (cd => r1))		      (let ((tm cd)) (if tm (r1 tm))))		    ((_ (cd => r1) c1 c2 ...)		      (let ((tm cd))		        (if tm		            (r1 tm)		            (cond c1 c2 ...))))		    ((_ (cd)) test)		    ((_ (cd) c1 c2 ...)		      (let ((tm cd))		        (if tm tm (cond c1 c2 ...))))		    ((_ (cd r1 r2 ...))		      (if cd (begin r1 r2 ...)))		    ((_ (cd r1 r2 ...) c1 c2 ...)		      (if cd		          (begin r1 r2 ...)		          (cond c1 c2 ...)))))"));$mille.macroenv.call("eval-macro",$mille.readString("(define-syntax case		  (syntax-rules (else)		    ((case (key ...) cs ...)		      (let ((ak (key ...)))		        (case ak cs ...)))		    ((case key (else r1 ...)) (begin r1 ...))		    ((case key ((atoms ...) r1 ...))		      (if (memv key '(atoms ...))		          (begin r1 ...)))		    ((case key ((atoms ...) r1 ...) cl ...)		      (if (memv key '(atoms ...))		          (begin r1 ...)		          (case key cl ...)))))"));$mille.macroenv.call("eval-macro",$mille.readString("(define-syntax let		  (syntax-rules ()		    ((let ((name val) ...)) (if #f #f))		    ((let ((name val) ...) body1 body2 ...)		      ((lambda (name ...) body1 body2 ...)		         val ...))		    ((let tag ((name val) ...) body1 body2 ...)		      ((let ((tag (if #f #f)))		        (set! tag (lambda (name ...) body1 body2 ...))		        tag) val ...))))"));$mille.macroenv.call("eval-macro",$mille.readString("(define-syntax let*		  (syntax-rules ()		    ((_ () e1 ...)		     (let () e1 ...))		    ((_ ((x1 v1) (x2 v2) ...) e1 ...)		     (let ((x1 v1))		       (let* ((x2 v2) ...) e1 ...)))))"));$mille.eval=function(c,a){var d;d=$mille.macroenv.call("eval-macro",a);return $mille.evalbas(c,d)};$env.bind("eval",$mille.closure($mille.genv,this,$mille.eval));$env.bind("caar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("car"),c.find("x")))))}));$env.bind("cadr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("cdr"),c.find("x")))))}));$env.bind("cdar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("car"),c.find("x")))))}));$env.bind("cddr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("cdr"),c.find("x")))))}));$env.bind("caaar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("caar"),c.find("x")))))}));$env.bind("caadr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("cadr"),c.find("x")))))}));$env.bind("cadar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("cdar"),c.find("x")))))}));$env.bind("caddr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("cddr"),c.find("x")))))}));$env.bind("cdaar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("caar"),c.find("x")))))}));$env.bind("cdadr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("cadr"),c.find("x")))))}));$env.bind("cddar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("cdar"),c.find("x")))))}));$env.bind("cdddr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("cddr"),c.find("x")))))}));$env.bind("caaaar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("caaar"),c.find("x")))))}));$env.bind("caaadr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("caadr"),c.find("x")))))}));$env.bind("caadar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("cadar"),c.find("x")))))}));$env.bind("caaddr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("caddr"),c.find("x")))))}));$env.bind("cadaar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("cdaar"),c.find("x")))))}));$env.bind("cadadr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("cdadr"),c.find("x")))))}));$env.bind("caddar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("cddar"),c.find("x")))))}));$env.bind("cadddr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("car"),$mille.apply(c.find("cdddr"),c.find("x")))))}));$env.bind("cdaaar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("caaar"),c.find("x")))))}));$env.bind("cdaadr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("caadr"),c.find("x")))))}));$env.bind("cdadar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("cadar"),c.find("x")))))}));$env.bind("cdaddr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("caddr"),c.find("x")))))}));$env.bind("cddaar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("cdaar"),c.find("x")))))}));$env.bind("cddadr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("cdadr"),c.find("x")))))}));$env.bind("cdddar",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("cddar"),c.find("x")))))}));$env.bind("cddddr",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply(c.find("cdr"),$mille.apply(c.find("cdddr"),c.find("x")))))}));$env.bind("not",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!((c.find("x"))===false)?false:true)))}));$env.bind("boolean?",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(($mille.apply($mille.closure(c,this,function(e,d){e.bind("#1",d===undefined?null:d);return(((!((e.find("#1"))===false)?e.find("#1"):$mille.apply(e.find("eq?"),e.find("x"),false))))}),$mille.apply(c.find("eq?"),c.find("x"),true))))}));$env.bind("pair?",$mille.closure($env,this,function(c,a){c.bind("x",a===undefined?null:a);return(((!(($mille.apply(c.find("null?"),c.find("x")))===false)?false:(!(($mille.apply(c.find("atom?"),c.find("x")))===false)?false:true))))}));$env.bind("member",$mille.closure($env,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("lis",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("lis")))===false)?((false)):(!(($mille.apply(d.find("equal?"),d.find("x"),$mille.apply(d.find("car"),d.find("lis"))))===false)?((d.find("lis"))):(($mille.apply(d.find("member"),d.find("x"),$mille.apply(d.find("cdr"),d.find("lis")))))))))}));$env.bind("assq",$mille.closure($env,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("lis",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("lis")))===false)?((false)):(!(($mille.apply(d.find("not"),$mille.apply(d.find("pair?"),$mille.apply(d.find("car"),d.find("lis")))))===false)?(($mille.apply(d.find("error"),$mille.apply(d.find("get-default-message"),"err.require.pair")))):(!(($mille.apply(d.find("eq?"),$mille.apply(d.find("caar"),d.find("lis")),d.find("x")))===false)?(($mille.apply(d.find("car"),d.find("lis")))):(($mille.apply(d.find("assq"),d.find("x"),$mille.apply(d.find("cdr"),d.find("lis"))))))))))}));$env.bind("assv",$mille.closure($env,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("lis",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("lis")))===false)?((false)):(!(($mille.apply(d.find("not"),$mille.apply(d.find("pair?"),$mille.apply(d.find("car"),d.find("lis")))))===false)?(($mille.apply(d.find("error"),$mille.apply(d.find("get-default-message"),"err.require.pair")))):(!(($mille.apply(d.find("eqv?"),$mille.apply(d.find("caar"),d.find("lis")),d.find("x")))===false)?(($mille.apply(d.find("car"),d.find("lis")))):(($mille.apply(d.find("assv"),d.find("x"),$mille.apply(d.find("cdr"),d.find("lis"))))))))))}));$env.bind("assoc",$mille.closure($env,this,function(d,c,a){d.bind("x",c===undefined?null:c);d.bind("lis",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("lis")))===false)?((false)):(!(($mille.apply(d.find("not"),$mille.apply(d.find("pair?"),$mille.apply(d.find("car"),d.find("lis")))))===false)?(($mille.apply(d.find("error"),$mille.apply(d.find("get-default-message"),"err.require.pair")))):(!(($mille.apply(d.find("equal?"),$mille.apply(d.find("caar"),d.find("lis")),d.find("x")))===false)?(($mille.apply(d.find("car"),d.find("lis")))):(($mille.apply(d.find("assoc"),d.find("x"),$mille.apply(d.find("cdr"),d.find("lis"))))))))))}));$env.bind("list",$mille.closure($env,this,function(d){var c=$mille.a.toArray(arguments,1);d.bind("l",$mille.listToCell(c));return(($mille.apply($mille.apply($mille.closure(d,this,function(e,a){e.bind("#2",a===undefined?null:a);return(((e.set("#2",$mille.closure(e,this,function(g,f){g.bind("#3",f===undefined?null:f);return(((!(($mille.apply(g.find("null?"),g.find("#3")))===false)?$mille.nil:$mille.apply(g.find("cons"),$mille.apply(g.find("car"),g.find("#3")),$mille.apply(g.find("#2"),$mille.apply(g.find("cdr"),g.find("#3")))))))})),undefined)),(e.find("#2")))}),(!((false)===false)?false:undefined)),d.find("l"))))}));$env.bind("length",$mille.closure($env,this,function(c,a){c.bind("l",a===undefined?null:a);return(($mille.apply($mille.apply($mille.closure(c,this,function(e,d){e.bind("#3",d===undefined?null:d);return(((e.set("#3",$mille.closure(e,this,function(h,g,f){h.bind("#4",g===undefined?null:g);h.bind("#5",f===undefined?null:f);return(((!(($mille.apply(h.find("null?"),h.find("#4")))===false)?h.find("#5"):$mille.apply(h.find("#3"),$mille.apply(h.find("cdr"),h.find("#4")),$mille.apply(h.find("1+"),h.find("#5"))))))})),undefined)),(e.find("#3")))}),(!((false)===false)?false:undefined)),c.find("l"),0)))}));$env.bind("list-ref",$mille.closure($env,this,function(d,c,a){d.bind("l",c===undefined?null:c);d.bind("n",a===undefined?null:a);return(((!(($mille.apply(d.find("<"),d.find("n"),0))===false)?$mille.apply(d.find("error"),"list-ref"):undefined)),((!(($mille.apply(d.find("not"),$mille.apply(d.find("pair?"),d.find("l"))))===false)?(($mille.apply(d.find("error"),"list-ref"))):(!(($mille.apply(d.find("<="),d.find("n"),0))===false)?(($mille.apply(d.find("car"),d.find("l")))):(($mille.apply(d.find("list-ref"),$mille.apply(d.find("cdr"),d.find("l")),$mille.apply(d.find("-"),d.find("n"),1))))))))}));$env.bind("list-tail",$mille.closure($env,this,function(d,c,a){d.bind("l",c===undefined?null:c);d.bind("n",a===undefined?null:a);return(((!(($mille.apply(d.find("<"),d.find("n"),0))===false)?$mille.apply(d.find("error"),"list-tail"):undefined)),((!(($mille.apply(d.find("<="),d.find("n"),0))===false)?((d.find("l"))):(!(($mille.apply(d.find("not"),$mille.apply(d.find("pair?"),d.find("l"))))===false)?(($mille.apply(d.find("error"),"list-tail"))):(($mille.apply(d.find("list-tail"),$mille.apply(d.find("cdr"),d.find("l")),$mille.apply(d.find("-"),d.find("n"),1))))))))}));$env.bind("append",$mille.closure($env,this,function(d){var c=$mille.a.toArray(arguments,1);d.bind("l",$mille.listToCell(c));return(($mille.apply($mille.apply($mille.closure(d,this,function(e,a){e.bind("#2",a===undefined?null:a);return(((e.set("#2",$mille.closure(e,this,function(g,f){g.bind("#3",f===undefined?null:f);return(((!(($mille.apply(g.find("null?"),g.find("#3")))===false)?(($mille.nil)):(!(($mille.apply(g.find("null?"),$mille.apply(g.find("cdr"),g.find("#3"))))===false)?(($mille.apply(g.find("car"),g.find("#3")))):(($mille.apply($mille.apply($mille.closure(g,this,function(i,h){i.bind("#5",h===undefined?null:h);return(((i.set("#5",$mille.closure(i,this,function(k,j){k.bind("#6",j===undefined?null:j);return(((!(($mille.apply(k.find("null?"),k.find("#6")))===false)?$mille.apply(k.find("#2"),$mille.apply(k.find("cdr"),k.find("#3"))):$mille.apply(k.find("cons"),$mille.apply(k.find("car"),k.find("#6")),$mille.apply(k.find("#5"),$mille.apply(k.find("cdr"),k.find("#6")))))))})),undefined)),(i.find("#5")))}),(!((false)===false)?false:undefined)),$mille.apply(g.find("car"),g.find("#3")))))))))})),undefined)),(e.find("#2")))}),(!((false)===false)?false:undefined)),d.find("l"))))}));$env.bind("reverse",$mille.closure($env,this,function(c,a){c.bind("l",a===undefined?null:a);return(((!(($mille.apply(c.find("pair?"),c.find("l")))===false)?$mille.apply($mille.apply($mille.closure(c,this,function(e,d){e.bind("#3",d===undefined?null:d);return(((e.set("#3",$mille.closure(e,this,function(h,g,f){h.bind("#4",g===undefined?null:g);h.bind("#5",f===undefined?null:f);return(((!(($mille.apply(h.find("null?"),h.find("#4")))===false)?h.find("#5"):$mille.apply(h.find("#3"),$mille.apply(h.find("cdr"),h.find("#4")),$mille.apply(h.find("cons"),$mille.apply(h.find("car"),h.find("#4")),h.find("#5"))))))})),undefined)),(e.find("#3")))}),(!((false)===false)?false:undefined)),c.find("l"),$mille.nil):c.find("l"))))}));$env.bind("memq",$mille.closure($env,this,function(d,c,a){d.bind("o",c===undefined?null:c);d.bind("l",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("l")))===false)?((false)):(!(($mille.apply(d.find("eq?"),d.find("o"),$mille.apply(d.find("car"),d.find("l"))))===false)?((d.find("l"))):(($mille.apply(d.find("memq"),d.find("o"),$mille.apply(d.find("cdr"),d.find("l")))))))))}));$env.bind("memv",$mille.closure($env,this,function(d,c,a){d.bind("o",c===undefined?null:c);d.bind("l",a===undefined?null:a);return(((!(($mille.apply(d.find("null?"),d.find("l")))===false)?((false)):(!(($mille.apply(d.find("eqv?"),d.find("o"),$mille.apply(d.find("car"),d.find("l"))))===false)?((d.find("l"))):(($mille.apply(d.find("memq"),d.find("o"),$mille.apply(d.find("cdr"),d.find("l")))))))))}));$env.bind("list?",$mille.closure($env,this,function(c,a){c.bind("l",a===undefined?null:a);return(($mille.apply($mille.apply($mille.closure(c,this,function(e,d){e.bind("#3",d===undefined?null:d);return(((e.set("#3",$mille.closure(e,this,function(h,g,f){h.bind("#4",g===undefined?null:g);h.bind("#5",f===undefined?null:f);return(((!(($mille.apply(h.find("null?"),h.find("#4")))===false)?((true)):(!(($mille.apply(h.find("memq"),h.find("#4"),h.find("#5")))===false)?((false)):(!(($mille.apply(h.find("pair?"),h.find("#4")))===false)?(($mille.apply(h.find("#3"),$mille.apply(h.find("cdr"),h.find("#4")),$mille.apply(h.find("cons"),h.find("#4"),h.find("#5"))))):((false)))))))})),undefined)),(e.find("#3")))}),(!((false)===false)?false:undefined)),c.find("l"),$mille.nil)))}));$env.bind("map",$mille.closure($env,this,function(e,d){e.bind("p",d===undefined?null:d);var c=$mille.a.toArray(arguments,2);e.bind("l1",$mille.listToCell(c));return((e.bind("cx",$mille.closure(e,this,function(g,f,a){g.bind("p",f===undefined?null:f);g.bind("l2",a===undefined?null:a);return(($mille.apply($mille.apply($mille.closure(g,this,function(i,h){i.bind("#2",h===undefined?null:h);return(((i.set("#2",$mille.closure(i,this,function(k,j){k.bind("#3",j===undefined?null:j);return(((!(($mille.apply(k.find("null?"),k.find("#3")))===false)?$mille.nil:$mille.apply(k.find("cons"),$mille.apply(k.find("p"),$mille.apply(k.find("car"),k.find("#3"))),$mille.apply(k.find("#2"),$mille.apply(k.find("cdr"),k.find("#3")))))))})),undefined)),(i.find("#2")))}),(!((false)===false)?false:undefined)),g.find("l2"))))}))),(e.bind("n?",$mille.closure(e,this,function(f,a){f.bind("l2",a===undefined?null:a);return(($mille.apply($mille.apply($mille.closure(f,this,function(h,g){h.bind("#5",g===undefined?null:g);return(((h.set("#5",$mille.closure(h,this,function(j,i){j.bind("#6",i===undefined?null:i);return(((!(($mille.apply(j.find("null?"),j.find("#6")))===false)?((false)):(!(($mille.apply(j.find("null?"),$mille.apply(j.find("car"),j.find("#6"))))===false)?((true)):(($mille.apply(j.find("#5"),$mille.apply(j.find("cdr"),j.find("#6")))))))))})),undefined)),(h.find("#5")))}),(!((false)===false)?false:undefined)),f.find("l2"))))}))),($mille.apply($mille.apply($mille.closure(e,this,function(f,a){f.bind("#8",a===undefined?null:a);return(((f.set("#8",$mille.closure(f,this,function(h,g){h.bind("#9",g===undefined?null:g);return(((!(($mille.apply(h.find("n?"),h.find("#9")))===false)?$mille.nil:$mille.apply(h.find("cons"),$mille.apply(h.find("apply"),h.find("p"),$mille.apply(h.find("cx"),h.find("car"),h.find("#9"))),$mille.apply(h.find("#8"),$mille.apply(h.find("cx"),h.find("cdr"),h.find("#9")))))))})),undefined)),(f.find("#8")))}),(!((false)===false)?false:undefined)),e.find("l1"))))}));$env.bind("for-each",$mille.closure($env,this,function(e,d){e.bind("p",d===undefined?null:d);var c=$mille.a.toArray(arguments,2);e.bind("l1",$mille.listToCell(c));return((e.bind("cx",$mille.closure(e,this,function(g,f,a){g.bind("p",f===undefined?null:f);g.bind("l2",a===undefined?null:a);return(($mille.apply($mille.apply($mille.closure(g,this,function(i,h){i.bind("#2",h===undefined?null:h);return(((i.set("#2",$mille.closure(i,this,function(k,j){k.bind("#3",j===undefined?null:j);return(((!(($mille.apply(k.find("null?"),k.find("#3")))===false)?$mille.nil:$mille.apply(k.find("cons"),$mille.apply(k.find("p"),$mille.apply(k.find("car"),k.find("#3"))),$mille.apply(k.find("#2"),$mille.apply(k.find("cdr"),k.find("#3")))))))})),undefined)),(i.find("#2")))}),(!((false)===false)?false:undefined)),g.find("l2"))))}))),(e.bind("n?",$mille.closure(e,this,function(f,a){f.bind("l2",a===undefined?null:a);return(($mille.apply($mille.apply($mille.closure(f,this,function(h,g){h.bind("#5",g===undefined?null:g);return(((h.set("#5",$mille.closure(h,this,function(j,i){j.bind("#6",i===undefined?null:i);return(((!(($mille.apply(j.find("null?"),j.find("#6")))===false)?((false)):(!(($mille.apply(j.find("null?"),$mille.apply(j.find("car"),j.find("#6"))))===false)?((true)):(($mille.apply(j.find("#5"),$mille.apply(j.find("cdr"),j.find("#6")))))))))})),undefined)),(h.find("#5")))}),(!((false)===false)?false:undefined)),f.find("l2"))))}))),($mille.apply($mille.apply($mille.closure(e,this,function(f,a){f.bind("#8",a===undefined?null:a);return(((f.set("#8",$mille.closure(f,this,function(h,g){h.bind("#9",g===undefined?null:g);return(((!(($mille.apply(h.find("n?"),h.find("#9")))===false)?$mille.nil:(($mille.apply(h.find("apply"),h.find("p"),$mille.apply(h.find("cx"),h.find("car"),h.find("#9")))),($mille.apply(h.find("#8"),$mille.apply(h.find("cx"),h.find("cdr"),h.find("#9"))))))))})),undefined)),(f.find("#8")))}),(!((false)===false)?false:undefined)),e.find("l1"))))}));if(!$mille){throw"Mille core library required"}$mille.w={};$mille.w.ajax=function(a){var g,f,c;g=new XMLHttpRequest();f=function(){if(a.dataXML){return g.responseXML}else{return g.responseText}};g.onreadystatechange=function(){var e;if(g.readyState===4){if(g.status===200){e=f();a.success(e)}else{a.error(g,g.status,false)}a.complete(g,g.status,false)}};try{g.open(a.type,a.url);if(a.type==="GET"){g.send()}else{c=a.contentType?a.contentType:"application/x-www-form-urlencoded";g.setRequestHeader("Content-Type",c);g.send(a.data)}}catch(d){a.error(g,false,d);a.complete(g,null)}return true};$mille.ajaxAny=function(c,g,a,d,h,f){var e={};e.type=d;e.url=c;e.success=function(i){var j=h(i);g(j)};e.error=a;e.data=f;$mille.w.ajax(e)};$mille.ajaxGet=function(c,d,a){$mille.checkString(c);$mille.checkFunction(d);$mille.checkFunction(a);$mille.ajaxAny(c,d,a,"GET",$mille.readString)};$mille.ajaxGetText=function(c,d,a){$mille.checkString(c);$mille.checkFunction(d);$mille.checkFunction(a);$mille.ajaxAny(c,d,a,"GET",$mille.f.K)};$mille.ajaxPost=function(c,d,e,a){$mille.checkString(c);$mille.checkString(d);$mille.checkFunction(e);$mille.checkFunction(a);$mille.ajaxAny(c,e,a,"POST",$mille.readString,d)};$mille.ajaxPostText=function(c,d,e,a){$mille.checkString(c);$mille.checkString(d);$mille.checkFunction(e);$mille.checkFunction(a);$mille.ajaxAny(c,e,a,"POST",$mille.f.K,d)};$mille.bindg("ajax-get",$mille.ajaxGet);$mille.bindg("ajax-get-text",$mille.ajaxGetText);$mille.bindg("ajax-post",$mille.ajaxPost);$mille.bindg("ajax-post-text",$mille.ajaxPostText);$mille.readMilia=function(){var x,i,j,p;x=document.getElementsByTagName("script");for(i=0;i<x.length;i++){if(x[i].type==="text/x-schluessel-milia"){p=$mille.readStringAll(x[i].text);for(j=0;j<p.length;j++){$mille.eval($env,p[j])}}}};if(window.addEventListener){window.addEventListener("load",$mille.readMilia,false)}else{if(window.attachEvent){window.attachEvent("onload",$mille.readMilia)}else{window.onload=$mille.readMilia}};