/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.atto.js;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.morilib.lisp.atto.AttoParser;
import net.morilib.lisp.atto.AttoTraverser;
import net.morilib.lisp.atto.Callback;
import net.morilib.lisp.atto.Cell;
import net.morilib.lisp.atto.Environment;
import net.morilib.lisp.atto.LispAtto;
import net.morilib.lisp.atto.ReaderException;
import net.morilib.lisp.atto.SimpleEngine;
import net.morilib.lisp.atto.Symbol;
import net.morilib.lisp.atto.js.JSCallback;

public class LispAttoJS {
    Environment macroenv;
    JSCallback jscall;
    PrintWriter pw;
    boolean basic;
    private static final Pattern SUFFIX = Pattern.compile("(.*)\\.[^\\.]+");

    public LispAttoJS(Writer wr, boolean basic) {
        try {
            this.basic = basic;
            this.macroenv = new Environment();
            SimpleEngine.getInstance().init(this.macroenv);
            LispAtto.eval((Callback)SimpleEngine.getInstance(), this.macroenv, LispAttoJS.class.getResourceAsStream("macro-atto.scm"));
            this.readmacro();
            this.pw = new PrintWriter(wr, true);
            this.jscall = new JSCallback(this.pw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void readmacro() {
        InputStreamReader rd = new InputStreamReader(LispAttoJS.class.getResourceAsStream("macro-lib.scm"));
        try {
            while (true) {
                Object o;
                if ((o = AttoParser.read(rd)) == null) {
                    return;
                }
                if (AttoParser.isInvaild(o)) continue;
                o = new Cell(Symbol.get("eval-macro"), new Cell(new Cell(Symbol.QUOTE, new Cell(o, Cell.NIL)), Cell.NIL));
                AttoTraverser.traverse(SimpleEngine.getInstance(), this.macroenv, o);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (ArithmeticException e) {
            throw new RuntimeException(e);
        }
    }

    public Object eval(Environment env, Object p) {
        Object o = p;
        if (!this.basic) {
            o = new Cell(Symbol.get("eval-macro"), new Cell(new Cell(Symbol.QUOTE, new Cell(o, Cell.NIL)), Cell.NIL));
            o = AttoTraverser.traverse(SimpleEngine.getInstance(), this.macroenv, o);
        }
        o = AttoTraverser.traverse(this.jscall, env, o);
        this.pw.flush();
        return o;
    }

    private static void loadJs(String load, ScriptEngineManager mn, ScriptEngine en) {
        try {
            en.eval(new InputStreamReader(LispAttoJS.class.getResourceAsStream(load)));
        }
        catch (ScriptException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static void outputJS(Reader rd, PrintWriter out) throws IOException {
        Object o;
        while ((o = AttoParser.read(rd)) != null) {
            if (AttoParser.isInvaild(o)) continue;
            StringWriter sw = new StringWriter();
            LispAttoJS s = new LispAttoJS(sw, false);
            s.eval(new Environment(), o);
            out.println(sw.toString());
        }
        return;
    }

    public static void repl() {
        ScriptEngineManager mn = new ScriptEngineManager();
        ScriptEngine en = mn.getEngineByName("javascript");
        LispAttoJS.loadJs("mille-atto.js", mn, en);
        LispAttoJS.loadJs("sExpression.js", mn, en);
        LispAttoJS.loadJs("macro-atto.js", mn, en);
        LispAttoJS.loadJs("milia-lib.js", mn, en);
        String pr = " >";
        InputStream is = System.in;
        InputStreamReader rd = new InputStreamReader(is);
        System.out.print(pr);
        while (true) {
            try {
                Object o;
                do {
                    if ((o = AttoParser.read(rd)) != null) continue;
                    return;
                } while (AttoParser.isInvaild(o));
                StringWriter sw = new StringWriter();
                LispAttoJS s = new LispAttoJS(sw, false);
                s.eval(new Environment(), o);
                String js = sw.toString();
                js = "(function(x){return x?x.toString():x}(" + js + "))";
                Object r = en.eval(js);
                System.out.println(r);
            }
            catch (IOException e) {
                System.err.println("IO error");
                e.printStackTrace();
                return;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Runtime error");
                e.printStackTrace();
            }
            catch (ArithmeticException e) {
                System.err.println("Arithmetic error");
                e.printStackTrace();
            }
            catch (ScriptException e) {
                System.err.println("JavaScript error");
                e.printStackTrace();
            }
            System.out.print(pr);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compile(String infile, String outfile, boolean basic) {
        pw = null;
        rd = null;
        try {
            rd = new LineNumberReader(new InputStreamReader(new FileInputStream(infile)));
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outfile))));
lbl6:
            // 3 sources

            while (true) {
                o = AttoParser.read(rd);
                if (o != null) ** GOTO lbl-1000
                if (rd == null) ** GOTO lbl55
                ** GOTO lbl47
                break;
            }
        }
        catch (ReaderException e) {
            System.err.format("Reader error: %s(%d)\n", new Object[]{infile, rd.getLineNumber()});
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException e) {
                    System.err.format("IO error: %s", new Object[]{infile});
                    e.printStackTrace();
                    return false;
                }
            }
            if (pw != null) {
                pw.close();
            }
            return false;
        }
        catch (IOException e) {
            block23: {
                try {
                    System.err.format("IO error: %s\n", new Object[]{infile});
                    e.printStackTrace();
                    if (rd != null) {
                    }
                    break block23;
                }
                catch (Throwable var10_15) {
                    if (rd != null) {
                        try {
                            rd.close();
                        }
                        catch (IOException e) {
                            System.err.format("IO error: %s", new Object[]{infile});
                            e.printStackTrace();
                            return false;
                        }
                    }
                    if (pw != null) {
                        pw.close();
                    }
                    throw var10_15;
                }
lbl47:
                // 1 sources

                try {
                    rd.close();
                }
                catch (IOException e) {
                    System.err.format("IO error: %s", new Object[]{infile});
                    e.printStackTrace();
                    return false;
                }
lbl55:
                // 2 sources

                if (pw != null) {
                    pw.close();
                }
                return true;
lbl-1000:
                // 1 sources

                {
                    if (AttoParser.isInvaild(o)) ** GOTO lbl6
                    sw = new StringWriter();
                    s = new LispAttoJS(sw, basic);
                    s.eval(new Environment(), o);
                    js = sw.toString();
                    pw.println(js);
                    ** continue;
                }
                try {
                    rd.close();
                }
                catch (IOException e) {
                    System.err.format("IO error: %s", new Object[]{infile});
                    e.printStackTrace();
                    return false;
                }
            }
            if (pw != null) {
                pw.close();
            }
            return false;
        }
    }

    public static void main(String[] args) {
        int r = 0;
        boolean basic = false;
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-b")) {
                    basic = true;
                } else {
                    Matcher m = SUFFIX.matcher(args[i]);
                    String of = m.matches() ? String.valueOf(m.group(1)) + ".js" : String.valueOf(args[i]) + ".js";
                    if (!LispAttoJS.compile(args[i], of, basic)) {
                        File f = new File(of);
                        f.delete();
                        r = 2;
                    }
                }
                ++i;
            }
        } else {
            LispAttoJS.repl();
        }
        System.exit(r);
    }
}

