/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.atto;

import java.math.BigInteger;
import java.util.ArrayList;
import net.morilib.lisp.atto.Cell;

public final class AttoUtils {
    static final BigInteger MAXINT = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger MININT = BigInteger.valueOf(Integer.MIN_VALUE);

    static BigInteger toBigInteger(Object o) {
        if (o instanceof Integer) {
            return BigInteger.valueOf(((Integer)o).intValue());
        }
        if (o instanceof BigInteger) {
            return (BigInteger)o;
        }
        if (o instanceof Double) {
            return null;
        }
        throw new IllegalArgumentException();
    }

    static Object toObject(BigInteger x) {
        if (x.compareTo(MAXINT) > 0 || x.compareTo(MININT) < 0) {
            return x;
        }
        return x.intValue();
    }

    public static Object[] toArray(Object o) {
        if (!(o instanceof Cell)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> l = new ArrayList<Object>();
        Cell c = (Cell)o;
        while (c != Cell.NIL) {
            l.add(c.car);
            if (!(c.cdr instanceof Cell)) {
                throw new IllegalArgumentException();
            }
            c = (Cell)c.cdr;
        }
        return l.toArray(new Object[0]);
    }

    public static Cell toList(Object ... objs) {
        Cell l = null;
        Cell r = Cell.NIL;
        if (objs.length > 0) {
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (l != null) {
                    Cell a = new Cell(o, null);
                    l.cdr = a;
                    l = a;
                } else {
                    r = l = new Cell(o, null);
                }
                ++n2;
            }
            l.cdr = Cell.NIL;
        }
        return r;
    }
}

