/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.atto;

import net.morilib.lisp.atto.Appliable;
import net.morilib.lisp.atto.AttoTraverser;
import net.morilib.lisp.atto.AttoUtils;
import net.morilib.lisp.atto.Callback;
import net.morilib.lisp.atto.Cell;
import net.morilib.lisp.atto.Environment;
import net.morilib.lisp.atto.Symbol;

public class Closure
implements Appliable {
    private Environment env;
    private Object args;
    private Object[] body;

    Closure(Environment env, Object args, Object ... body) {
        this.env = env;
        this.args = args;
        this.body = new Object[body.length];
        System.arraycopy(body, 0, this.body, 0, body.length);
    }

    private void _bind(Callback b, Environment e1, Object ... as) {
        Object p = this.args;
        int k = 0;
        while (p != Cell.NIL) {
            if (as[k] == null) {
                throw new NullPointerException();
            }
            if (p instanceof Symbol) {
                Object[] a = new Object[as.length - k];
                System.arraycopy(as, k, a, 0, as.length - k);
                e1.binds.put((Symbol)p, AttoUtils.toList(a));
                return;
            }
            if (!(p instanceof Cell)) {
                throw new IllegalArgumentException();
            }
            if (k >= as.length) {
                throw new IllegalArgumentException();
            }
            if (!(((Cell)p).car instanceof Symbol)) {
                throw new IllegalArgumentException();
            }
            e1.binds.put((Symbol)((Cell)p).car, as[k]);
            p = ((Cell)p).cdr;
            ++k;
        }
    }

    @Override
    public Object apply(Callback b, Environment e, Object ... args) {
        Object r = Cell.NIL;
        Environment e1 = new Environment(this.env);
        this._bind(b, e1, args);
        Object[] objectArray = this.body;
        int n = this.body.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            r = AttoTraverser.traverse(b, e1, o);
            ++n2;
        }
        return r;
    }
}

