/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano.subr;

import java.util.List;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispBoolean;
import net.morilib.lisp.nano.LispCharacter;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.Subr;

public abstract class CharCompare
extends Subr {
    protected abstract boolean compare(LispCharacter var1, LispCharacter var2);

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() < 2) {
            throw mesg.getError("err.argument", "char-compare");
        }
        if (!(lst.get(0) instanceof LispCharacter)) {
            throw mesg.getError("err.require.char", lst.get(0));
        }
        LispCharacter prev = (LispCharacter)lst.get(0);
        int i = 1;
        while (i < lst.size()) {
            Datum d = lst.get(i);
            if (d instanceof LispCharacter) {
                if (!this.compare(prev, (LispCharacter)d)) {
                    return LispBoolean.FALSE;
                }
            } else {
                throw mesg.getError("err.require.char", d);
            }
            prev = (LispCharacter)d;
            ++i;
        }
        return LispBoolean.TRUE;
    }
}

