/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Logger;
import net.morilib.lisp.nano.CodeExecutor;
import net.morilib.lisp.nano.CodeExecutorFactory;
import net.morilib.lisp.nano.CompiledCode;
import net.morilib.lisp.nano.CompilerFactory;
import net.morilib.lisp.nano.Cons;
import net.morilib.lisp.nano.ConsListBuilder;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.InitLispLoader;
import net.morilib.lisp.nano.InitLoadException;
import net.morilib.lisp.nano.InitSubrLoader;
import net.morilib.lisp.nano.IntLispUtils;
import net.morilib.lisp.nano.IntStack;
import net.morilib.lisp.nano.LispCompiler;
import net.morilib.lisp.nano.LispException;
import net.morilib.lisp.nano.LispIOException;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispString;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.NanoParser;
import net.morilib.lisp.nano.Nil;
import net.morilib.lisp.nano.ReadFileException;
import net.morilib.lisp.nano.SchemeOptions;
import net.morilib.lisp.nano.SubrSetCarS;
import net.morilib.lisp.nano.SubrSetCdrS;
import net.morilib.lisp.nano.SubrVectorSetS;
import net.morilib.lisp.nano.Symbol;
import net.morilib.lisp.nano.SynBegin;
import net.morilib.lisp.nano.SynDefine;
import net.morilib.lisp.nano.SynIf;
import net.morilib.lisp.nano.SynLambda;
import net.morilib.lisp.nano.SynQuote;
import net.morilib.lisp.nano.SynSetS;
import net.morilib.lisp.nano.exlib.SubrError;
import net.morilib.lisp.nano.subr.Add;
import net.morilib.lisp.nano.subr.Car;
import net.morilib.lisp.nano.subr.Cdr;
import net.morilib.lisp.nano.subr.IsEq;
import net.morilib.lisp.nano.subr.IsEqv;
import net.morilib.lisp.nano.subr.IsNull;
import net.morilib.lisp.nano.subr.IsPair;
import net.morilib.lisp.nano.subr.IsString;
import net.morilib.lisp.nano.subr.IsSymbol;
import net.morilib.lisp.nano.subr.IsVector;
import net.morilib.lisp.nano.subr.MakeCons;
import net.morilib.lisp.nano.subr.MakeVector;
import net.morilib.lisp.nano.subr.NumGreaterThan;
import net.morilib.lisp.nano.subr.NumLessThan;
import net.morilib.lisp.nano.subr.NumberToString;
import net.morilib.lisp.nano.subr.StringAppend;
import net.morilib.lisp.nano.subr.StringEqual;
import net.morilib.lisp.nano.subr.StringLength;
import net.morilib.lisp.nano.subr.StringRef;
import net.morilib.lisp.nano.subr.StringToSymbol;
import net.morilib.lisp.nano.subr.Sub;
import net.morilib.lisp.nano.subr.Substring;
import net.morilib.lisp.nano.subr.SymbolToString;
import net.morilib.lisp.nano.subr.VectorLength;
import net.morilib.lisp.nano.subr.VectorRef;
import net.morilib.lisp.nano.util.LogEnv;
import net.morilib.lisp.nano.util.PeekableReader;

public final class Scheme {
    public static final int SCHEME_VERSION = 5;
    public static final String SCHLUSH_VERSION = "0.4.5";
    private static final String MA2 = "/net/morilib/lisp/nano/macro2.scm";
    private static final Scheme MACRO;
    private static Logger _log;
    private static PrintWriter transcript;
    private Environment global;
    private LispCompiler comp;
    private CodeExecutor exec;
    private IntStack memento;
    private LispMessage message;
    private boolean usemacro;
    String stackTrace;

    static {
        _log = LogEnv.init("schlush.main");
        Environment e = new Environment();
        Scheme._bind(e, "if", new SynIf());
        Scheme._bind(e, "set!", new SynSetS());
        Scheme._bind(e, "lambda", new SynLambda());
        Scheme._bind(e, "define", new SynDefine());
        Scheme._bind(e, "quote", new SynQuote());
        Scheme._bind(e, "begin", new SynBegin());
        Scheme._bind(e, "cons", new MakeCons());
        Scheme._bind(e, "car", new Car());
        Scheme._bind(e, "cdr", new Cdr());
        Scheme._bind(e, "null?", new IsNull());
        Scheme._bind(e, "pair?", new IsPair());
        Scheme._bind(e, "symbol?", new IsSymbol());
        Scheme._bind(e, "eq?", new IsEq());
        Scheme._bind(e, "eqv?", new IsEqv());
        Scheme._bind(e, "+", new Add());
        Scheme._bind(e, "-", new Sub());
        Scheme._bind(e, ">", new NumGreaterThan());
        Scheme._bind(e, "<", new NumLessThan());
        Scheme._bind(e, "set-car!", new SubrSetCarS());
        Scheme._bind(e, "set-cdr!", new SubrSetCdrS());
        Scheme._bind(e, "vector?", new IsVector());
        Scheme._bind(e, "make-vector", new MakeVector());
        Scheme._bind(e, "vector-ref", new VectorRef());
        Scheme._bind(e, "vector-set!", new SubrVectorSetS());
        Scheme._bind(e, "vector-length", new VectorLength());
        Scheme._bind(e, "string?", new IsString());
        Scheme._bind(e, "string=?", new StringEqual());
        Scheme._bind(e, "string-ref", new StringRef());
        Scheme._bind(e, "string-length", new StringLength());
        Scheme._bind(e, "string-append", new StringAppend());
        Scheme._bind(e, "substring", new Substring());
        Scheme._bind(e, "number->string", new NumberToString());
        Scheme._bind(e, "string->symbol", new StringToSymbol());
        Scheme._bind(e, "symbol->string", new SymbolToString());
        Scheme._bind(e, "error", new SubrError());
        MACRO = new Scheme(e, LispMessage.getInstance(), false);
        try {
            MACRO.set("macroenv", new Cons(Nil.NIL, Nil.NIL));
            NanoParser.read(MACRO, Scheme.class.getResourceAsStream(MA2));
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        transcript = null;
    }

    private static void _bind(Environment e, String s, Datum d) {
        e.bindDatum(Symbol.getSymbol(s), d);
    }

    private Scheme(LispMessage msg) {
        if (msg == null) {
            throw new NullPointerException();
        }
        this.global = new Environment();
        this.message = msg;
        this.comp = CompilerFactory.getInstance(this.message);
        this.exec = CodeExecutorFactory.getInstance(this.message);
        this.memento = this.exec.newMemento();
        this.usemacro = true;
    }

    public Scheme(Environment env, LispMessage msg, boolean macro) {
        if (env == null) {
            throw new NullPointerException();
        }
        if (msg == null) {
            throw new NullPointerException();
        }
        this.global = env;
        this.message = msg;
        this.comp = CompilerFactory.getInstance(this.message);
        this.exec = CodeExecutorFactory.getInstance(this.message);
        this.memento = this.exec.newMemento();
        this.usemacro = macro;
    }

    public Scheme(Environment env, LispMessage msg) {
        this(env, msg, true);
    }

    public static Scheme newInstance(Locale lc) {
        Scheme res = new Scheme(LispMessage.getInstance(lc));
        InitSubrLoader.load(res.global);
        InitLispLoader.load(res);
        return res;
    }

    public static Scheme newInstance() {
        return Scheme.newInstance(Locale.getDefault());
    }

    public static Scheme newInstance(String[] pkg, Locale lc) throws InitLoadException {
        Scheme res = new Scheme(LispMessage.getInstance(lc));
        String[] stringArray = pkg;
        int n = pkg.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            InitSubrLoader.load(s, res.global);
            ++n2;
        }
        InitLispLoader.load(res);
        return res;
    }

    public static Scheme newInstance(String[] pkg) throws InitLoadException {
        return Scheme.newInstance(pkg, Locale.getDefault());
    }

    public static Environment newNullEnv(int ver) {
        return Scheme.newNull((int)ver).global;
    }

    public static Environment newRnRSEnv(int ver) {
        return Scheme.newRnRS((int)ver).global;
    }

    public static Scheme newEmpty() {
        return new Scheme(LispMessage.getInstance());
    }

    public static Scheme newNull(int ver) {
        return Scheme.newNull(ver, null);
    }

    public static Scheme newNull(int ver, Locale lc) {
        Scheme res = new Scheme(LispMessage.getInstance(lc));
        InitSubrLoader.loadNullEnv(res.global, ver);
        InitLispLoader.loadNullEnv(res, ver);
        return res;
    }

    public static Scheme newRnRS(int ver) {
        return Scheme.newRnRS(ver, null);
    }

    public static Scheme newRnRS(int ver, Locale lc) {
        Scheme res = new Scheme(LispMessage.getInstance(lc));
        InitSubrLoader.loadRnRSEnv(res.global, ver);
        InitLispLoader.loadRnRSEnv(res, ver);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTranscript(PrintWriter pw) {
        Class<Scheme> clazz = Scheme.class;
        synchronized (Scheme.class) {
            if (transcript != null) {
                transcript.close();
            }
            transcript = pw;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Environment getGlobalEnvironment() {
        return this.global;
    }

    public Datum input(Environment env, Datum sexp) {
        try {
            CompiledCode.Builder b = new CompiledCode.Builder();
            Datum d = sexp;
            long t = System.currentTimeMillis();
            IntLispUtils.timelog(_log, "Expand Macro : ", t);
            if (this.usemacro) {
                try {
                    d = MACRO.call("eval-macro", d);
                }
                catch (LispException e) {
                    throw this.message.getError("err.macro");
                }
                catch (NoSuchMethodException e) {
                    throw this.message.getError("err.macro");
                }
            }
            t = System.currentTimeMillis();
            this.comp.compile(d, env, b, true, new Cons(), true, new LinkedList<Cons>(), this.exec, this.memento);
            b.addReturnOp();
            IntLispUtils.timelog(_log, "Compile : ", t);
            t = System.currentTimeMillis();
            Datum res = this.exec.exec(b.getCodeRef(), env, this.memento);
            IntLispUtils.timelog(_log, "Execute : ", t);
            _log.fine(this.memento.toString());
            Datum datum = res;
            return datum;
        }
        finally {
            this.stackTrace = this.memento.getStackTrace();
            this.memento = this.exec.newMemento();
            Scheme.MACRO.memento = Scheme.MACRO.exec.newMemento();
        }
    }

    public Datum input(Datum sexp) {
        return this.input(this.global, sexp);
    }

    public Datum read(Environment env, Reader rd1) throws IOException {
        NanoParser p = new NanoParser(null);
        Datum d = p.readExpr(new PeekableReader(rd1));
        return d != null ? this.input(env, d) : d;
    }

    public void read(InputStream in1) throws IOException {
        NanoParser.read(this, in1);
    }

    public Datum read(Reader rd1) throws IOException {
        return this.read(this.global, rd1);
    }

    public Datum input(String s) {
        try {
            Datum d = NanoParser.read(new PeekableReader(new StringReader(s)));
            return d != null ? this.input(d) : null;
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public void readEvalPrintLoop(PeekableReader rd1) throws IOException {
        NanoParser.repl(this, rd1, this.message);
    }

    public void set(String var, Object o) {
        this.global.bindDatum(Symbol.getSymbol(var), LispUtils.toDatum(o));
    }

    public void setDotList(String var, Object cdr, Object ... lst) {
        ConsListBuilder b = new ConsListBuilder();
        Object[] objectArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            b.append(LispUtils.toDatum(o));
            ++n2;
        }
        this.global.bindDatum(Symbol.getSymbol(var), b.get(LispUtils.toDatum(cdr)));
    }

    public void setList(String var, Object ... lst) {
        this.setDotList(var, Nil.NIL, lst);
    }

    public Datum get(String var) {
        return this.global.findDatum(Symbol.getSymbol(var));
    }

    public Datum call(String var, Object ... lst) throws NoSuchMethodException {
        CompiledCode.Builder cd = new CompiledCode.Builder();
        Datum fn = this.get(var);
        if (fn == null) {
            throw new NoSuchMethodException();
        }
        cd.addPush(fn);
        cd.addPush(LispUtils.toConsList(lst));
        cd.addCall();
        cd.addReturnOp();
        return this.exec.exec(cd.getCodeRef(), this.global, this.memento);
    }

    public LispMessage getMessage() {
        return this.message;
    }

    public static void main(String[] args) throws IOException {
        ArrayList<LispString> d1 = new ArrayList<LispString>();
        d1.add(new LispString("schluessel"));
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            d1.add(new LispString(s));
            ++n2;
        }
        Scheme eval = SchemeOptions.preparseOption(args);
        int opt = SchemeOptions.parseOption(args, eval);
        if (args.length == opt) {
            eval.readEvalPrintLoop(PeekableReader.in);
            System.exit(0);
        } else {
            try {
                if (args[opt].equals("-")) {
                    eval.read(PeekableReader.in);
                } else {
                    eval.read(new InputStreamReader(new FileInputStream(args[opt])));
                }
                System.exit(0);
            }
            catch (ReadFileException e) {
                System.err.println(e.getMessage());
                System.exit(2);
            }
        }
    }
}

