/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.LispCharacter;
import net.morilib.lisp.nano.LispIOException;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispUtils;

public class OutputPort
extends Datum {
    private PrintStream lineWriter;
    private boolean standard;
    private boolean closed = false;
    private LispMessage msg;

    private OutputPort(OutputStream wr, boolean std, LispMessage msg) {
        this.lineWriter = wr instanceof PrintStream ? (PrintStream)wr : new PrintStream(wr);
        this.standard = std;
        this.msg = msg;
    }

    public OutputPort(OutputStream wr, LispMessage msg) {
        this(wr, false, msg);
    }

    public OutputPort(File fname, LispMessage msg) {
        try {
            FileOutputStream wr = new FileOutputStream(fname);
            this.lineWriter = new PrintStream(wr);
            this.standard = false;
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    public OutputPort(File fname, String encoding, LispMessage msg) throws UnsupportedEncodingException {
        try {
            FileOutputStream wr = new FileOutputStream(fname);
            this.lineWriter = new PrintStream((OutputStream)wr, true, encoding);
            this.standard = false;
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    public static OutputPort getStandard(LispMessage msg) {
        return new OutputPort(System.out, true, msg);
    }

    public void writeChar(LispCharacter ch) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(ch.getCharacter());
        } else {
            this.lineWriter.print(ch.getCharacter());
        }
    }

    public void write(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        String s = LispUtils.toWriteWithoutSS(d);
        if (this.standard) {
            System.out.print(s);
        } else {
            this.lineWriter.print(s);
        }
    }

    public void display(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        String s = LispUtils.toDisplay(d);
        if (this.standard) {
            System.out.print(s);
        } else {
            this.lineWriter.print(s);
        }
    }

    public void newline() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.println();
        } else {
            this.lineWriter.println();
        }
    }

    public void close() {
        if (!this.closed && !this.standard) {
            this.lineWriter.close();
            this.closed = true;
        }
    }

    @Override
    public boolean isTypePort() {
        return true;
    }

    @Override
    public String toDisplay() {
        return "#<oport>";
    }
}

