/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.LispBoolean;
import net.morilib.lisp.nano.LispComplex;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispNumber;
import net.morilib.lisp.nano.LispRational;
import net.morilib.lisp.nano.LispReal;

public class NanoNumberParser {
    private static final int NINA_ACCEPT = -1;
    private static final int NINA_FAIL = -9;
    private static final int NINA_HALT_ACCEPT = -91;
    private static final int NINA_HALT_REJECT = -72;
    private static final int NINA_BEGIN = -2;
    private static final int NINA_STACKLEN = 72;
    static final int INITIAL = 0;
    private int STATE;
    private int[] __sts = new int[72];
    private Engine[] __stk = new Engine[72];
    private Object[][] __stv = new Object[72][];
    private int __slen = 0;
    Throwable exception;
    private int unread = -1;
    private StringBuffer nbf;
    private StringBuffer dbf;
    private StringBuffer fbf;
    private LispReal real;
    private Datum num;
    private final Engine ENGINE_intx = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoNumberParser.this.intx_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoNumberParser.this.intx_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoNumberParser.this.intx_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoNumberParser.this.intx_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 5;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "intx";
        }
    };
    private final Engine ENGINE_real = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoNumberParser.this.real_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoNumberParser.this.real_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoNumberParser.this.real_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoNumberParser.this.real_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 19;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "real";
        }
    };
    private final Engine ENGINE_nanoNumberParser = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoNumberParser.this.nanoNumberParser_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoNumberParser.this.nanoNumberParser_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoNumberParser.this.nanoNumberParser_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoNumberParser.this.nanoNumberParser_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return 3;
        }

        @Override
        int stateSize() {
            return 30;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "nanoNumberParser";
        }
    };
    private final Engine ENGINE_number = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoNumberParser.this.number_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoNumberParser.this.number_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoNumberParser.this.number_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoNumberParser.this.number_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 9;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "number";
        }
    };

    private void ib() {
        this.real = LispInteger.ONE;
        this.num = null;
    }

    private void ia() {
        this.nbf = new StringBuffer();
        this.fbf = null;
        this.dbf = null;
    }

    private void an(int c) {
        if (c != 43) {
            this.nbf.append((char)c);
        }
    }

    private void ad(int c) {
        this.dbf.append((char)c);
    }

    private void af(int c) {
        if (this.fbf == null) {
            this.fbf = this.nbf;
        }
        this.fbf.append((char)c);
    }

    private LispReal getr() {
        if (this.dbf != null) {
            return LispRational.newRational(new BigInteger(this.nbf.toString()), new BigInteger(this.dbf.toString()));
        }
        if (this.fbf != null) {
            return new LispDouble(Double.parseDouble(this.fbf.toString()));
        }
        String n = this.nbf.toString();
        if (n.equals("i")) {
            return LispDouble.POSITIVE_INFINITY;
        }
        if (n.equals("-i")) {
            return LispDouble.NEGATIVE_INFINITY;
        }
        if (n.equals("n") || n.equals("-n")) {
            return LispDouble.NaN;
        }
        return LispInteger.valueOf(new BigInteger(n));
    }

    private LispReal getr(int rdx) {
        if (this.dbf != null) {
            return LispRational.newRational(new BigInteger(this.nbf.toString(), rdx), new BigInteger(this.dbf.toString(), rdx));
        }
        return LispInteger.valueOf(new BigInteger(this.nbf.toString(), rdx));
    }

    private static Datum _exec(String s) {
        try {
            NanoNumberParser r = new NanoNumberParser();
            r.parse(new StringReader(s));
            return r.num;
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        catch (NumberFormatException e) {
            return LispBoolean.FALSE;
        }
        catch (TokenException e) {
            return LispBoolean.FALSE;
        }
    }

    public static Datum parseNumber(String s, int rdx) {
        if (s.length() == 0) {
            return LispBoolean.FALSE;
        }
        if (s.charAt(0) == '#') {
            return NanoNumberParser._exec(s);
        }
        if (rdx == 10) {
            return NanoNumberParser._exec("#d" + s);
        }
        if (rdx == 8) {
            return NanoNumberParser._exec("#o" + s);
        }
        if (rdx == 16) {
            return NanoNumberParser._exec("#x" + s);
        }
        if (rdx == 2) {
            return NanoNumberParser._exec("#b" + s);
        }
        return LispBoolean.FALSE;
    }

    int _read1(Reader stream) throws IOException {
        int c = stream.read();
        return c < 0 ? -1 : c;
    }

    private int _read(Reader rd) throws IOException {
        int c;
        if (this.unread >= 0) {
            c = this.unread;
            this.unread = -1;
            this.__logprint("Read unread: ", c);
        } else {
            c = this._read1(rd);
            if (c != -1) {
                this.__logprint("Read: ", c);
            } else {
                this.__logprint("Read end-of-file");
            }
        }
        return c;
    }

    void UNGET(int c) {
        this.unread = c;
        this.__logprint("Set unread: ", c);
    }

    private void __logprint(String s, int c) {
    }

    private void __logopen() {
    }

    private void __logprint(String s) {
    }

    private void __logclose() {
    }

    private void __puttrace() {
    }

    private int intx_step(Reader __rd, int $c) throws IOException {
        switch (this.STATE) {
            case 0: {
                if ($c == 43) {
                    this.STATE = 1;
                    return 1;
                }
                if ($c == 45) {
                    this.STATE = 1;
                    return 1;
                }
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 2;
                    return 1;
                }
                if ($c >= 65 && $c <= 70) {
                    this.STATE = 2;
                    return 1;
                }
                if ($c >= 97 && $c <= 102) {
                    this.STATE = 2;
                    return 1;
                }
                return 0;
            }
            case 2: {
                if ($c == 47) {
                    this.STATE = 3;
                    return 1;
                }
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 2;
                    return 1;
                }
                if ($c >= 65 && $c <= 70) {
                    this.STATE = 2;
                    return 1;
                }
                if ($c >= 97 && $c <= 102) {
                    this.STATE = 2;
                    return 1;
                }
                return 0;
            }
            case 3: {
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 4;
                    return 1;
                }
                if ($c >= 65 && $c <= 70) {
                    this.STATE = 4;
                    return 1;
                }
                if ($c >= 97 && $c <= 102) {
                    this.STATE = 4;
                    return 1;
                }
                return 0;
            }
            case 4: {
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 4;
                    return 1;
                }
                if ($c >= 65 && $c <= 70) {
                    this.STATE = 4;
                    return 1;
                }
                if ($c >= 97 && $c <= 102) {
                    this.STATE = 4;
                    return 1;
                }
                return 0;
            }
            case 1: {
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 2;
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    private boolean intx_accepted() {
        return this.STATE == 2 || this.STATE == 4;
    }

    int intx_execaction(int $c) {
        switch (this.STATE) {
            case 4: {
                this.ad($c);
                break;
            }
            case 0: {
                this.ia();
                break;
            }
            case 3: {
                this.dbf = new StringBuffer();
                break;
            }
            case 2: {
                this.an($c);
                break;
            }
            case 1: {
                this.an($c);
            }
        }
        return 1;
    }

    boolean intx_isend() {
        return false;
    }

    private int real_step(Reader __rd, int $c) throws IOException {
        switch (this.STATE) {
            case 0: {
                if ($c == 43) {
                    this.STATE = 1;
                    return 1;
                }
                if ($c == 45) {
                    this.STATE = 1;
                    return 1;
                }
                if ($c == 46) {
                    this.STATE = 2;
                    return 1;
                }
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 3;
                    return 1;
                }
                return 0;
            }
            case 3: {
                if ($c == 46) {
                    this.STATE = 2;
                    return 1;
                }
                if ($c == 47) {
                    this.STATE = 4;
                    return 1;
                }
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 69) {
                    this.STATE = 5;
                    return 1;
                }
                if ($c == 70) {
                    this.STATE = 5;
                    return 1;
                }
                if ($c == 101) {
                    this.STATE = 5;
                    return 1;
                }
                if ($c == 102) {
                    this.STATE = 5;
                    return 1;
                }
                return 0;
            }
            case 5: {
                if ($c == 43) {
                    this.STATE = 6;
                    return 1;
                }
                if ($c == 45) {
                    this.STATE = 6;
                    return 1;
                }
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 6;
                    return 1;
                }
                return 0;
            }
            case 6: {
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 6;
                    return 1;
                }
                return 0;
            }
            case 4: {
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 7;
                    return 1;
                }
                return 0;
            }
            case 7: {
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 7;
                    return 1;
                }
                return 0;
            }
            case 2: {
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 8;
                    return 1;
                }
                return 0;
            }
            case 8: {
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 8;
                    return 1;
                }
                if ($c == 69) {
                    this.STATE = 5;
                    return 1;
                }
                if ($c == 70) {
                    this.STATE = 5;
                    return 1;
                }
                if ($c == 101) {
                    this.STATE = 5;
                    return 1;
                }
                if ($c == 102) {
                    this.STATE = 5;
                    return 1;
                }
                return 0;
            }
            case 1: {
                if ($c >= 48 && $c <= 57) {
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 105) {
                    this.STATE = 9;
                    return 1;
                }
                if ($c == 110) {
                    this.STATE = 10;
                    return 1;
                }
                return 0;
            }
            case 10: {
                if ($c == 97) {
                    this.STATE = 11;
                    return 1;
                }
                return 0;
            }
            case 11: {
                if ($c == 110) {
                    this.STATE = 12;
                    return 1;
                }
                return 0;
            }
            case 12: {
                if ($c == 46) {
                    this.STATE = 13;
                    return 1;
                }
                return 0;
            }
            case 13: {
                if ($c == 48) {
                    this.STATE = 14;
                    return 1;
                }
                return 0;
            }
            case 14: {
                return 0;
            }
            case 9: {
                if ($c == 110) {
                    this.STATE = 15;
                    return 1;
                }
                return 0;
            }
            case 15: {
                if ($c == 102) {
                    this.STATE = 16;
                    return 1;
                }
                return 0;
            }
            case 16: {
                if ($c == 46) {
                    this.STATE = 17;
                    return 1;
                }
                return 0;
            }
            case 17: {
                if ($c == 48) {
                    this.STATE = 18;
                    return 1;
                }
                return 0;
            }
            case 18: {
                return 0;
            }
        }
        return 0;
    }

    private boolean real_accepted() {
        return this.STATE == 18 || this.STATE == 3 || this.STATE == 6 || this.STATE == 7 || this.STATE == 8 || this.STATE == 14;
    }

    int real_execaction(int $c) {
        switch (this.STATE) {
            case 15: {
                break;
            }
            case 6: {
                this.af($c);
                break;
            }
            case 18: {
                this.nbf.append("i");
                break;
            }
            case 1: {
                this.an($c);
                break;
            }
            case 12: {
                break;
            }
            case 7: {
                this.ad($c);
                break;
            }
            case 10: {
                break;
            }
            case 9: {
                break;
            }
            case 16: {
                break;
            }
            case 4: {
                this.dbf = new StringBuffer();
                break;
            }
            case 17: {
                break;
            }
            case 2: {
                this.af($c);
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                this.nbf.append("n");
                break;
            }
            case 3: {
                this.an($c);
                break;
            }
            case 11: {
                break;
            }
            case 5: {
                this.af($c);
                break;
            }
            case 0: {
                this.ia();
                break;
            }
            case 8: {
                this.af($c);
            }
        }
        return 1;
    }

    boolean real_isend() {
        return false;
    }

    private int nanoNumberParser_step(Reader __rd, int $c) throws IOException {
        switch (this.STATE) {
            case 0: {
                if ($c == 35) {
                    this.STATE = 1;
                    return 1;
                }
                this.__stkpush(2, this.ENGINE_number);
                this.STATE = 0;
                return -1;
            }
            case 2: {
                this.STATE = 3;
                return 1;
            }
            case 3: {
                return 0;
            }
            case 1: {
                if ($c == 66) {
                    this.STATE = 4;
                    return 1;
                }
                if ($c == 68) {
                    this.STATE = 5;
                    return 1;
                }
                if ($c == 69) {
                    this.STATE = 6;
                    return 1;
                }
                if ($c == 73) {
                    this.STATE = 7;
                    return 1;
                }
                if ($c == 79) {
                    this.STATE = 8;
                    return 1;
                }
                if ($c == 88) {
                    this.STATE = 9;
                    return 1;
                }
                if ($c == 98) {
                    this.STATE = 4;
                    return 1;
                }
                if ($c == 100) {
                    this.STATE = 5;
                    return 1;
                }
                if ($c == 101) {
                    this.STATE = 6;
                    return 1;
                }
                if ($c == 105) {
                    this.STATE = 7;
                    return 1;
                }
                if ($c == 111) {
                    this.STATE = 8;
                    return 1;
                }
                if ($c == 120) {
                    this.STATE = 9;
                    return 1;
                }
                return 0;
            }
            case 9: {
                if ($c == 35) {
                    this.STATE = 10;
                    return 1;
                }
                this.__stkpush(11, this.ENGINE_intx);
                this.STATE = 0;
                return -1;
            }
            case 11: {
                this.STATE = 3;
                return 1;
            }
            case 10: {
                if ($c == 69) {
                    this.STATE = 12;
                    return 1;
                }
                if ($c == 73) {
                    this.STATE = 13;
                    return 1;
                }
                if ($c == 101) {
                    this.STATE = 12;
                    return 1;
                }
                if ($c == 105) {
                    this.STATE = 13;
                    return 1;
                }
                return 0;
            }
            case 13: {
                this.__stkpush(14, this.ENGINE_intx);
                this.STATE = 0;
                return -1;
            }
            case 14: {
                this.STATE = 3;
                return 1;
            }
            case 12: {
                this.__stkpush(15, this.ENGINE_intx);
                this.STATE = 0;
                return -1;
            }
            case 15: {
                this.STATE = 3;
                return 1;
            }
            case 8: {
                if ($c == 35) {
                    this.STATE = 16;
                    return 1;
                }
                this.__stkpush(17, this.ENGINE_intx);
                this.STATE = 0;
                return -1;
            }
            case 17: {
                this.STATE = 3;
                return 1;
            }
            case 16: {
                if ($c == 69) {
                    this.STATE = 18;
                    return 1;
                }
                if ($c == 73) {
                    this.STATE = 19;
                    return 1;
                }
                if ($c == 101) {
                    this.STATE = 18;
                    return 1;
                }
                if ($c == 105) {
                    this.STATE = 19;
                    return 1;
                }
                return 0;
            }
            case 19: {
                this.__stkpush(20, this.ENGINE_intx);
                this.STATE = 0;
                return -1;
            }
            case 20: {
                this.STATE = 3;
                return 1;
            }
            case 18: {
                this.__stkpush(21, this.ENGINE_intx);
                this.STATE = 0;
                return -1;
            }
            case 21: {
                this.STATE = 3;
                return 1;
            }
            case 7: {
                this.__stkpush(22, this.ENGINE_nanoNumberParser);
                this.STATE = 0;
                return -1;
            }
            case 22: {
                this.STATE = 3;
                return 1;
            }
            case 6: {
                this.__stkpush(23, this.ENGINE_nanoNumberParser);
                this.STATE = 0;
                return -1;
            }
            case 23: {
                this.STATE = 3;
                return 1;
            }
            case 5: {
                this.__stkpush(2, this.ENGINE_nanoNumberParser);
                this.STATE = 0;
                return -1;
            }
            case 4: {
                if ($c == 35) {
                    this.STATE = 24;
                    return 1;
                }
                this.__stkpush(25, this.ENGINE_intx);
                this.STATE = 0;
                return -1;
            }
            case 25: {
                this.STATE = 3;
                return 1;
            }
            case 24: {
                if ($c == 69) {
                    this.STATE = 26;
                    return 1;
                }
                if ($c == 73) {
                    this.STATE = 27;
                    return 1;
                }
                if ($c == 101) {
                    this.STATE = 26;
                    return 1;
                }
                if ($c == 105) {
                    this.STATE = 27;
                    return 1;
                }
                return 0;
            }
            case 27: {
                this.__stkpush(28, this.ENGINE_intx);
                this.STATE = 0;
                return -1;
            }
            case 28: {
                this.STATE = 3;
                return 1;
            }
            case 26: {
                this.__stkpush(29, this.ENGINE_intx);
                this.STATE = 0;
                return -1;
            }
            case 29: {
                this.STATE = 3;
                return 1;
            }
        }
        return 0;
    }

    private boolean nanoNumberParser_accepted() {
        return this.STATE == 17 || this.STATE == 0 || this.STATE == 2 || this.STATE == 3 || this.STATE == 21 || this.STATE == 20 || this.STATE == 23 || this.STATE == 22 || this.STATE == 25 || this.STATE == 11 || this.STATE == 29 || this.STATE == 28 || this.STATE == 14 || this.STATE == 15;
    }

    int nanoNumberParser_execaction(int $c) {
        switch (this.STATE) {
            case 21: {
                this.num = this.getr(8).toExact();
                break;
            }
            case 14: {
                this.num = this.getr(16).toInexact();
                break;
            }
            case 18: {
                break;
            }
            case 2: {
                this.num = this.num != null ? this.num : this.real;
                break;
            }
            case 26: {
                break;
            }
            case 20: {
                this.num = this.getr(8).toInexact();
                break;
            }
            case 7: {
                break;
            }
            case 1: {
                break;
            }
            case 29: {
                this.num = this.getr(2).toExact();
                break;
            }
            case 24: {
                break;
            }
            case 8: {
                break;
            }
            case 27: {
                break;
            }
            case 25: {
                this.num = this.getr(2);
                break;
            }
            case 5: {
                break;
            }
            case 9: {
                break;
            }
            case 3: {
                this.num = LispBoolean.FALSE;
                break;
            }
            case 4: {
                break;
            }
            case 22: {
                this.num = this.num.isTrue() ? ((LispNumber)this.num).toInexact() : this.num;
                break;
            }
            case 17: {
                this.num = this.getr(8);
                break;
            }
            case 13: {
                break;
            }
            case 19: {
                break;
            }
            case 6: {
                break;
            }
            case 0: {
                break;
            }
            case 28: {
                this.num = this.getr(2).toInexact();
                break;
            }
            case 16: {
                break;
            }
            case 23: {
                this.num = this.num.isTrue() ? ((LispNumber)this.num).toExact() : this.num;
                break;
            }
            case 10: {
                break;
            }
            case 12: {
                break;
            }
            case 11: {
                this.num = this.getr(16);
                break;
            }
            case 15: {
                this.num = this.getr(16).toExact();
            }
        }
        return 1;
    }

    boolean nanoNumberParser_isend() {
        return false;
    }

    private int number_step(Reader __rd, int $c) throws IOException {
        switch (this.STATE) {
            case 0: {
                this.__stkpush(1, this.ENGINE_real);
                this.STATE = 0;
                return -1;
            }
            case 1: {
                if ($c == 43) {
                    this.STATE = 2;
                    return 1;
                }
                if ($c == 45) {
                    this.UNGET($c);
                    this.STATE = 2;
                    return 1;
                }
                if ($c == 64) {
                    this.STATE = 3;
                    return 1;
                }
                if ($c == 105) {
                    this.STATE = 4;
                    return 1;
                }
                return 0;
            }
            case 4: {
                return 0;
            }
            case 3: {
                this.__stkpush(5, this.ENGINE_real);
                this.STATE = 0;
                return -1;
            }
            case 5: {
                return 0;
            }
            case 2: {
                if ($c == 105) {
                    this.STATE = 6;
                    return 1;
                }
                this.__stkpush(7, this.ENGINE_real);
                this.STATE = 0;
                return -1;
            }
            case 7: {
                if ($c == 105) {
                    this.STATE = 8;
                    return 1;
                }
                return 0;
            }
            case 8: {
                return 0;
            }
            case 6: {
                return 0;
            }
        }
        return 0;
    }

    private boolean number_accepted() {
        return this.STATE == 1 || this.STATE == 4 || this.STATE == 5 || this.STATE == 6 || this.STATE == 8;
    }

    int number_execaction(int $c) {
        switch (this.STATE) {
            case 7: {
                break;
            }
            case 6: {
                this.num = LispComplex.newComplex(this.real, LispInteger.ONE);
                break;
            }
            case 1: {
                this.real = this.getr();
                break;
            }
            case 5: {
                this.num = LispComplex.newPolar(this.real.getRealDouble(), this.getr().getRealDouble());
                break;
            }
            case 8: {
                this.num = LispComplex.newComplex(this.real, this.getr());
                break;
            }
            case 4: {
                this.num = LispComplex.newComplex(LispInteger.ZERO, this.real);
                break;
            }
            case 0: {
                this.ib();
                break;
            }
            case 2: {
                break;
            }
        }
        return 1;
    }

    boolean number_isend() {
        return false;
    }

    void __stkpush(int st, Engine en) {
        if (this.__slen >= this.__sts.length) {
            int[] a = new int[this.__sts.length * 2];
            Engine[] b = new Engine[this.__stk.length * 2];
            Object[][] c = new Object[this.__stk.length * 2][];
            System.arraycopy(this.__sts, 0, a, 0, this.__sts.length);
            System.arraycopy(this.__stk, 0, b, 0, this.__stk.length);
            System.arraycopy(this.__stv, 0, c, 0, this.__stv.length);
            this.__sts = a;
            this.__stk = b;
            this.__stv = c;
        }
        this.__sts[this.__slen] = st;
        this.__stk[this.__slen] = en;
        this.__stv[this.__slen++] = new Object[en.stateSize()];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _parse(Reader rd, int x) throws IOException {
        boolean b = false;
        int c = x;
        b = this.__stk[this.__slen - 1].accepted();
        if (rd == null) {
            throw new RuntimeException("can not recurse");
        }
        switch (this.__stk[this.__slen - 1].execaction(-2)) {
            case -1: {
                this.__logprint("accept " + this.__stk[this.__slen - 1]);
                return -1;
            }
            case -9: {
                this.__logprint("match failed: begin");
                this.__puttrace();
                return -9;
            }
            case -91: {
                this.__logprint("machine halted: begin");
                return -91;
            }
            case -72: {
                this.__logprint("machine halted: begin");
                return -72;
            }
        }
        try {
            do {
                Engine en = this.__stk[this.__slen - 1];
                if (c < 0) continue;
                int a = en.step(rd, c);
                if (a > 0) {
                    this.__logprint("transit to state " + this.STATE + ": ", c);
                    b = en.accepted();
                    switch (en.execaction(c)) {
                        case -1: {
                            this.__logprint("accept " + this.__stk[this.__slen - 1]);
                            this.UNGET(c);
                            return -1;
                        }
                        case -9: {
                            this.__logprint("match failed: ", c);
                            this.__puttrace();
                            this.UNGET(c);
                            return -9;
                        }
                        case -91: {
                            this.__logprint("machine halted: ", c);
                            return -91;
                        }
                        case -72: {
                            this.__logprint("machine halted: ", c);
                            return -72;
                        }
                    }
                    continue;
                }
                if (a < 0) {
                    this.__logprint("entering " + this.__stk[this.__slen - 1]);
                    return c;
                }
                if (b) {
                    this.__logprint("accept " + this.__stk[this.__slen - 1]);
                    this.UNGET(c);
                    return -1;
                }
                this.__logprint("match failed: ", c);
                this.__puttrace();
                this.UNGET(c);
                return -9;
            } while ((c = this._read(rd)) >= 0);
            if (!b) {
                throw new TokenException();
            }
            return -1;
        }
        catch (RuntimeException e) {
            this.UNGET(c);
            throw e;
        }
    }

    private Boolean execfinally() {
        int a = this.__stk[this.__slen - 1].finallyState();
        if (a >= 0) {
            int b = this.STATE;
            this.STATE = a;
            switch (this.__stk[this.__slen - 1].execaction(-2)) {
                case -91: {
                    this.__slen = 0;
                    return Boolean.TRUE;
                }
                case -72: {
                    this.__slen = 0;
                    return Boolean.FALSE;
                }
            }
            this.STATE = b;
        }
        return null;
    }

    private int getdeadstate() {
        return this.__stk[this.__slen - 1].deadState();
    }

    private int getrecover(Exception e) {
        return this.__stk[this.__slen - 1].recover(e);
    }

    /*
     * Unable to fully structure code
     */
    boolean parse(Reader rd, Engine entry) throws IOException {
        c = -1;
        this.__logopen();
        try {
            this.__stkpush(0, entry);
            block13: while (true) {
                block24: {
                    try {
                        while ((c = this._parse(rd, c)) >= 0) {
                        }
                        if (c != -9) break block24;
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            if ((this.STATE = this.getdeadstate()) >= 0) continue block13;
                            b = this.execfinally();
                            if (b == null) continue;
                            var7_6 = b;
                            return var7_6;
                        }
                    }
                    catch (RuntimeException e) {
                        this.exception = e;
                        if (this.__slen > 0) ** GOTO lbl54
                        throw e;
                    }
                    {
                        ** while (this.__slen-- > 1)
                    }
lbl21:
                    // 1 sources

                    throw new TokenException();
                }
                if (c == -91) {
                    b = this.execfinally();
                    if (b != null) {
                        var7_7 = b;
                        return var7_7;
                    }
                    this.__slen = 0;
                    return true;
                }
                if (c == -72) {
                    b = this.execfinally();
                    if (b != null) {
                        var7_8 = b;
                        return var7_8;
                    }
                    this.__slen = 0;
                    return false;
                }
                if (this.__slen > 1) {
                    b = this.execfinally();
                    if (b != null) {
                        var7_9 = b;
                        return var7_9;
                    }
                    this.STATE = this.__sts[--this.__slen];
                    continue;
                }
                b = this.execfinally();
                if (b == null) break;
                var7_10 = b;
                return var7_10;
lbl-1000:
                // 1 sources

                {
                    b = this.execfinally();
                    if (b != null) {
                        var7_11 = b;
                        return var7_11;
                    }
                    if (this.__slen-- > 1) continue;
                    throw e;
lbl54:
                    // 2 sources

                    ** while ((this.STATE = this.getrecover((Exception)e)) < 0)
                }
lbl55:
                // 1 sources

            }
            var7_12 = this.__stk[this.__slen - 1].accepted();
            return var7_12;
        }
        finally {
            this.__logclose();
        }
    }

    boolean parse(Reader rd) throws IOException {
        return this.parse(rd, this.ENGINE_nanoNumberParser);
    }

    static boolean parseAll(Reader rd) throws IOException {
        NanoNumberParser o = new NanoNumberParser();
        return o.parse(rd);
    }

    boolean parse(InputStream rd) throws IOException {
        return this.parse(new InputStreamReader(rd));
    }

    static boolean parseAll(InputStream rd) throws IOException {
        return NanoNumberParser.parseAll(new InputStreamReader(rd));
    }

    static abstract class Engine {
        Engine() {
        }

        abstract int step(Reader var1, int var2) throws IOException;

        abstract boolean accepted();

        abstract int execaction(int var1);

        abstract boolean isend();

        abstract int recover(Exception var1);

        abstract int deadState();

        abstract int stateSize();

        abstract int finallyState();
    }

    static class TokenException
    extends RuntimeException {
        TokenException() {
        }
    }
}

