/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.nano.Atom;
import net.morilib.lisp.nano.CodeExecutor;
import net.morilib.lisp.nano.CompiledCode;
import net.morilib.lisp.nano.Cons;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.IntStack;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.Nil;
import net.morilib.lisp.nano.Symbol;
import net.morilib.lisp.nano.SymbolName;
import net.morilib.lisp.nano.SynBegin;
import net.morilib.lisp.nano.Syntax;

class LispCompiler {
    private LispMessage message;

    LispCompiler(LispMessage msg) {
        this.message = msg;
    }

    private void compileArgsBind(Datum bcdr, Environment env, CompiledCode.Builder builder, Cons symcall, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        ArrayList<Datum> vals;
        block6: {
            Datum prms = symcall.getCdr();
            vals = new ArrayList<Datum>();
            while (true) {
                if (prms == Nil.NIL) {
                    if (bcdr != Nil.NIL) {
                        throw this.message.getError("err.parameter.insufficient");
                    }
                    break block6;
                }
                if (prms instanceof Atom) {
                    this.compile(bcdr, env, builder, symcall, false, symlist, exec, memento);
                    builder.addBind(prms);
                    break block6;
                }
                if (!(bcdr instanceof Cons)) {
                    throw this.message.getError("err.parameter.insufficient");
                }
                if (!(prms instanceof Cons)) break;
                Datum a1 = ((Cons)prms).getCar();
                Datum a2 = ((Cons)bcdr).getCar();
                this.compile(a2, env, builder, symcall, false, symlist, exec, memento);
                vals.add(a1);
                prms = ((Cons)prms).getCdr();
                bcdr = ((Cons)bcdr).getCdr();
            }
            throw this.message.getError("err.type.invalid");
        }
        int i = vals.size() - 1;
        while (i >= 0) {
            builder.addBind((Datum)vals.get(i));
            --i;
        }
    }

    private void compileSexp(Datum bcar, Datum bcdr, Environment env, CompiledCode.Builder builder, Cons symcall, boolean istail, List<Cons> symlist, CodeExecutor exec, IntStack memento, boolean toplv) {
        if (istail && bcar.equals(symcall.getCar())) {
            this.compileArgsBind(bcdr, env, builder, symcall, symlist, exec, memento);
            builder.addJmpTop();
        } else {
            boolean tlv = toplv && bcar instanceof Cons && ((Cons)bcar).getCar() instanceof SymbolName && ((SymbolName)((Object)((Cons)bcar).getCar())).getName().equals(SynBegin.BEGIN.getName());
            this.compile(bcar, env, builder, tlv, symcall, false, symlist, exec, memento);
            this.compileArgs(bcdr, env, builder, symcall, symlist, exec, memento);
            if (istail) {
                builder.addCallTail(symlist.size());
            } else {
                builder.addCall();
            }
        }
    }

    public void compileArgs(Datum bcdr, Environment env, CompiledCode.Builder builder, Cons symcall, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        block3: {
            builder.addBeginList();
            while (true) {
                if (bcdr instanceof Nil) {
                    builder.addEndList();
                    break block3;
                }
                if (bcdr instanceof Atom) {
                    this.compile(bcdr, env, builder, symcall, false, symlist, exec, memento);
                    builder.addEndListDot();
                    break block3;
                }
                if (!(bcdr instanceof Cons)) break;
                this.compile(((Cons)bcdr).getCar(), env, builder, symcall, false, symlist, exec, memento);
                builder.addAppendList();
                bcdr = ((Cons)bcdr).getCdr();
            }
            throw this.message.getError("err.type.invalid");
        }
    }

    private Datum getSym(Datum bcar, Environment env) {
        Datum ddd = env.findDatum((Symbol)bcar);
        return ddd;
    }

    public void compile(Datum body, Environment env, CompiledCode.Builder builder, boolean toplevel, Cons symcall, boolean istail, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        if (body instanceof SymbolName) {
            builder.addReferSymbol(body);
        } else if (body instanceof Cons) {
            Datum bcar = ((Cons)body).getCar();
            Datum bcdr = ((Cons)body).getCdr();
            if (bcar instanceof SymbolName) {
                Datum ddd = this.getSym(bcar, env);
                if (ddd instanceof Syntax) {
                    Syntax syn = (Syntax)ddd;
                    Datum dz = bcdr;
                    syn.compile(dz, env, this, builder, toplevel, symcall, istail, this.message, symlist, exec, memento);
                } else {
                    this.compileSexp(bcar, bcdr, env, builder, symcall, istail, symlist, exec, memento, toplevel);
                }
            } else {
                this.compileSexp(bcar, bcdr, env, builder, symcall, istail, symlist, exec, memento, toplevel);
            }
        } else {
            builder.addPush(body);
        }
    }

    public void compile(Datum body, Environment env, CompiledCode.Builder builder, Cons callsym, boolean istail, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        this.compile(body, env, builder, false, callsym, istail, symlist, exec, memento);
    }
}

