/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.Serializable;
import net.morilib.lisp.nano.Atom;
import net.morilib.lisp.nano.LispString;

public final class LispBoolean
extends Atom
implements Serializable {
    private static final long serialVersionUID = 1583375250021807431L;
    private boolean value;
    public static final LispBoolean TRUE = new LispBoolean(true);
    public static final LispBoolean FALSE = new LispBoolean(false);

    public static LispBoolean getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    private LispBoolean(boolean value) {
        this.value = value;
    }

    public boolean isEqv(Atom a) {
        return this.equals(a);
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public String toDisplay() {
        return this.value ? "#t" : "#f";
    }

    @Override
    public String toWrite() {
        return this.value ? "#t" : "#f";
    }

    public LispString toLispString() {
        return new LispString(this.value ? "#t" : "#f");
    }

    @Override
    public boolean isTypeBoolean() {
        return true;
    }

    @Override
    public boolean isTrue() {
        return this.value;
    }

    public Object toObject() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof LispBoolean) {
            return this.value == ((LispBoolean)o).value;
        }
        return false;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }

    @Override
    public String toString() {
        return this.value ? "#t" : "#f";
    }
}

