/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.TreeMap;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.Scheme;
import net.morilib.lisp.nano.util.IOs;
import net.morilib.lisp.nano.util.LispHandler;

public final class InitLispLoader {
    private static final String INIT_XML = "/net/morilib/lisp/nano/init/initlisp.xml";
    private static Properties initProp = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void load(Scheme lsp) {
        if (initProp == null) {
            Class<InitLispLoader> clazz = InitLispLoader.class;
            // MONITORENTER : net.morilib.lisp.nano.InitLispLoader.class
            InputStream ins = null;
            try {
                try {
                    initProp = new Properties();
                    ins = InitLispLoader.class.getResourceAsStream(INIT_XML);
                    initProp.loadFromXML(ins);
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot load propfile", e);
                }
            }
            catch (Throwable throwable) {
                IOs.close(ins);
                throw throwable;
            }
            IOs.close(ins);
            // MONITOREXIT : clazz
        }
        TreeMap<Object, Object> mp2 = new TreeMap<Object, Object>(initProp);
        for (Object s : mp2.values()) {
            InitLispLoader.load1(lsp, (String)s);
        }
    }

    public static void loadNullEnv(Scheme lsp, int ver) {
    }

    public static void loadRnRSEnv(Scheme lsp, int ver) {
        switch (ver) {
            case 5: {
                InitLispLoader.load1(lsp, "/net/morilib/lisp/nano/init/r5rs.scm");
            }
        }
    }

    public static boolean load1(String fname, Environment env, LispMessage mesg, ClassLoader loader) {
        return InitLispLoader.load1(new Scheme(env, mesg), fname, loader);
    }

    private static void load1(Scheme lsp, String fn) {
        InputStream ins = null;
        try {
            try {
                LispHandler.setLoggable2(false);
                ins = InitLispLoader.class.getResourceAsStream(fn);
                lsp.read(ins);
                LispHandler.setLoggable2(true);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load initfile", e);
            }
        }
        catch (Throwable throwable) {
            IOs.close(ins);
            throw throwable;
        }
        IOs.close(ins);
    }

    private static boolean load1(Scheme lsp, String fn, ClassLoader loader) {
        InputStream ins;
        block5: {
            ins = null;
            LispHandler.setLoggable2(false);
            ins = loader.getResourceAsStream(fn);
            if (ins != null) break block5;
            IOs.close(ins);
            return false;
        }
        try {
            InputStreamReader rd = new InputStreamReader(ins);
            lsp.read(rd);
            LispHandler.setLoggable2(true);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Cannot load initfile", e);
            }
            catch (Throwable throwable) {
                IOs.close(ins);
                throw throwable;
            }
        }
        IOs.close(ins);
        return true;
    }
}

