/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.po;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteSet;
import net.morilib.util.primitive.ByteSet;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.map.po.ByteMap;

public abstract class AbstractByteMap<V>
implements ByteMap<V> {
    private transient ByteSet keySet = null;
    private transient Collection<V> values = null;

    @Override
    public void clear() {
        Iterator i = this.byteKeyEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValue(Object v) {
        for (ByteMap.PrimitiveEntryK e : this.byteKeyEntrySet()) {
            Object p = e.getValue();
            if ((v != null || p != null) && (v == null || !v.equals(p))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V getElement(byte k) {
        for (ByteMap.PrimitiveEntryK e : this.byteKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteSet byteKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.byteKeyEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(ByteMap<V> map) {
        for (ByteMap.PrimitiveEntryK<V> e : map.byteKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        return this.values == null ? (this.values = new VCol(this.byteKeyEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Byte) {
            return this.containsKeyElement((Byte)key);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key instanceof Byte) {
            return this.getElement((Byte)key);
        }
        return null;
    }

    @Override
    public V put(Byte key, V value) {
        return this.putElement(key, value);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Byte) {
            return this.removeElement((Byte)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends V> m) {
        for (Map.Entry<Byte, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<Byte> keySet() {
        return this.byteKeySet();
    }

    @Override
    public Set<Map.Entry<Byte, V>> entrySet() {
        final Set e = this.byteKeyEntrySet();
        return new AbstractSet<Map.Entry<Byte, V>>(){

            @Override
            public Iterator<Map.Entry<Byte, V>> iterator() {
                final Iterator i = e.iterator();
                return new Iterator<Map.Entry<Byte, V>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<Byte, V> next() {
                        final ByteMap.PrimitiveEntryK o = (ByteMap.PrimitiveEntryK)i.next();
                        return new Map.Entry<Byte, V>(){

                            @Override
                            public Byte getKey() {
                                return o.getKey();
                            }

                            @Override
                            public V getValue() {
                                return o.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                return o.setValue(value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return e.size();
            }
        };
    }

    @Override
    public boolean containsKey(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement((byte)k);
    }

    @Override
    public boolean containsKeyElement(byte k) {
        for (ByteMap.PrimitiveEntryK e : this.byteKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.getElement((byte)k);
    }

    @Override
    public V put(int k, V v) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.putElement((byte)k, v);
    }

    @Override
    public V removeElement(byte k) {
        Iterator i = this.byteKeyEntrySet().iterator();
        while (i.hasNext()) {
            ByteMap.PrimitiveEntryK e = i.next();
            if (e.getKey() != k) continue;
            Object r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public V remove(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.removeElement((byte)k);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (ByteMap.PrimitiveEntryK e : this.byteKeyEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof ByteMap)) break block1;
            m = (ByteMap)obj;
            i = this.byteKeyEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && (v == null && p == null || v != null && v.equals(p))) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (ByteMap.PrimitiveEntryK e : this.byteKeyEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractByteSet {
        private Set<ByteMap.PrimitiveEntryK<V>> eset;

        private KSet(Set<ByteMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator ei = this.eset.iterator();
            return new ByteIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public byte next() {
                    return ((ByteMap.PrimitiveEntryK)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractByteMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteMap.this.clear();
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractCollection<V> {
        private Set<ByteMap.PrimitiveEntryK<V>> eset;

        private VCol(Set<ByteMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public V next() {
                    return ((ByteMap.PrimitiveEntryK)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteMap.this.size();
        }
    }
}

