/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.morilib.util.primitive.AbstractShortCollection;
import net.morilib.util.primitive.AbstractShortVector;
import net.morilib.util.primitive.ShortCollection;
import net.morilib.util.primitive.ShortList;
import net.morilib.util.primitive.ShortSet;
import net.morilib.util.primitive.ShortSortedSet;
import net.morilib.util.primitive.ShortVector;
import net.morilib.util.primitive.iterator.ShortIterator;
import net.morilib.util.primitive.iterator.ShortIterators;
import net.morilib.util.primitive.iterator.ShortVectorIterator;

public final class ShortCollections {
    public static final ShortSet EMPTY_SET = new _EmptyS();
    public static final ShortSortedSet EMPTY_SORTED_SET = new _EmptyS();
    public static final ShortVector EMPTY_VECTOR = new _EmptyV();

    private ShortCollections() {
    }

    public static ShortCollection unmodifiableCollection(ShortCollection c) {
        return c instanceof UnmodifiableCol ? c : new UnmodifiableCol(c);
    }

    public static ShortSet unmodifiableSet(ShortSet set) {
        return set instanceof UnmodifiableSet ? set : new UnmodifiableSet(set);
    }

    public static ShortSortedSet unmodifiableSortedSet(ShortSortedSet set) {
        return set instanceof UnmodifiableSSet ? set : new UnmodifiableSSet(set);
    }

    static class UnmodifiableCol
    extends AbstractShortCollection {
        ShortCollection wrapee;

        UnmodifiableCol(ShortCollection s) {
            this.wrapee = s;
        }

        @Override
        public boolean addShort(short v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllShort(ShortCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllShort(ShortCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllShort(Collection<? extends ShortCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsShort(short v) {
            return this.wrapee.contains(v);
        }

        @Override
        public boolean containsAllShort(ShortCollection a) {
            return this.wrapee.containsAllShort(a);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapee.isEmpty();
        }

        @Override
        public ShortIterator shortIterator() {
            return new Itr(this.wrapee.shortIterator());
        }

        @Override
        public boolean removeShort(short v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllShort(ShortCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllShort(ShortCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.wrapee.size();
        }

        @Override
        public short[] toShortArray() {
            return this.wrapee.toShortArray();
        }

        @Override
        public short[] toShortArray(short[] a) {
            return this.wrapee.toShortArray(a);
        }

        @Override
        public boolean isInfinite() {
            return this.wrapee.isInfinite();
        }

        @Override
        public ShortSet toSet() {
            return this.wrapee.toSet();
        }

        private static class Itr
        implements ShortIterator {
            private ShortIterator itr;

            private Itr(ShortIterator itr) {
                this.itr = itr;
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public short next() {
                return this.itr.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class UnmodifiableSSet
    extends UnmodifiableSet
    implements ShortSortedSet {
        UnmodifiableSSet(ShortCollection s) {
            super(s);
        }

        @Override
        public ShortSortedSet collect(ShortSortedSet set) {
            return ((ShortSortedSet)this.wrapee).collect(set);
        }

        @Override
        public short first() {
            return ((ShortSortedSet)this.wrapee).first();
        }

        @Override
        public ShortSortedSet headSet(short v) {
            return ShortCollections.unmodifiableSortedSet(((ShortSortedSet)this.wrapee).headSet(v));
        }

        @Override
        public ShortSortedSet subSet(short s, short e) {
            return ShortCollections.unmodifiableSortedSet(((ShortSortedSet)this.wrapee).subSet(s, e));
        }

        @Override
        public ShortSortedSet tailSet(short v) {
            return ShortCollections.unmodifiableSortedSet(((ShortSortedSet)this.wrapee).tailSet(v));
        }

        @Override
        public short last() {
            return ((ShortSortedSet)this.wrapee).last();
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCol
    implements ShortSet {
        UnmodifiableSet(ShortCollection s) {
            super(s);
        }

        @Override
        public ShortSet collect(ShortSet set) {
            return ((ShortSet)this.wrapee).collect(set);
        }
    }

    private static class _Empty
    extends AbstractShortCollection {
        private _Empty() {
        }

        @Override
        public boolean addShort(short v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllShort(ShortCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllShort(ShortCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllShort(Collection<? extends ShortCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsShort(short v) {
            return false;
        }

        @Override
        public boolean containsAllShort(ShortCollection a) {
            return a.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean removeShort(short v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllShort(ShortCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllShort(ShortCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ShortIterator shortIterator() {
            return new ShortIterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public short next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isInfinite() {
            return true;
        }
    }

    private static class _EmptyS
    extends _Empty
    implements ShortSortedSet {
        private _EmptyS() {
        }

        @Override
        public ShortSet collect(ShortSet set) {
            return this;
        }

        @Override
        public ShortSortedSet collect(ShortSortedSet set) {
            return this;
        }

        @Override
        public short first() {
            throw new NoSuchElementException();
        }

        @Override
        public ShortSortedSet headSet(short v) {
            return this;
        }

        @Override
        public ShortSortedSet subSet(short s, short e) {
            return this;
        }

        @Override
        public ShortSortedSet tailSet(short v) {
            return this;
        }

        @Override
        public short last() {
            throw new NoSuchElementException();
        }
    }

    private static class _EmptyV
    extends AbstractShortVector
    implements Serializable {
        private static final long serialVersionUID = 1540238742681016912L;
        private static final _Itr ITR = new _Itr();

        private _EmptyV() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public short first() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Short> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Short get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Short set(int index, Short element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Short element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Short remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        @Override
        public ListIterator<Short> listIterator() {
            return ITR;
        }

        @Override
        public ListIterator<Short> listIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.listIterator();
        }

        @Override
        public List<Short> subList(int fromIndex, int toIndex) {
            if (fromIndex != 0 || toIndex != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public void addShort(int index, short v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllShort(int index, ShortCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short getShort(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int indexOfShort(short v) {
            return -1;
        }

        @Override
        public int indexOf(int v) {
            return -1;
        }

        @Override
        public short removeAt(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ShortList rest() {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public ShortList rest(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public short setShort(int index, short v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short set(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOfShort(short v) {
            return -1;
        }

        @Override
        public ShortVectorIterator shortVectorIterator() {
            return ShortIterators.NULL_ITERATOR;
        }

        @Override
        public ShortVectorIterator shortVectorIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.shortVectorIterator();
        }

        @Override
        public ShortVector subVector(int start, int end) {
            if (start != 0 || end != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        private static class _Itr
        implements ListIterator<Short> {
            private _Itr() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Short next() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return false;
            }

            @Override
            public Short previous() {
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            @Override
            public int previousIndex() {
                return -1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Short e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Short e) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

