/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.util.Arrays;
import net.morilib.util.primitive.AbstractDoubleVector;
import net.morilib.util.primitive.DoubleVector;

public class AsDouble {
    public static DoubleVector valuesOf(final double ... a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new AbstractDoubleVector(){

            @Override
            public int size() {
                Arrays.asList(new Object[0]);
                return a.length;
            }

            @Override
            public void addDouble(int index, double v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double getDouble(int index) {
                if (index < 0 || index >= a.length) {
                    throw new IndexOutOfBoundsException();
                }
                return a[index];
            }

            @Override
            public double removeAt(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double setDouble(int index, double v) {
                if (index < 0 || index >= a.length) {
                    throw new IndexOutOfBoundsException();
                }
                double r = a[index];
                a[index] = v;
                return r;
            }

            @Override
            public void clear() {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public double[] toDoubleArray() {
                return (double[])a.clone();
            }

            @Override
            public double[] toDoubleArray(double[] ar) {
                if (a.length > ar.length) {
                    return this.toDoubleArray();
                }
                System.arraycopy(ar, 0, a, 0, a.length);
                return ar;
            }
        };
    }

    public static DoubleVector vector(int ... a) {
        if (a == null) {
            throw new NullPointerException();
        }
        final double[] a2 = new double[a.length];
        int i = 0;
        while (i < a.length) {
            a2[i] = a[i];
            ++i;
        }
        return new AbstractDoubleVector(){

            @Override
            public int size() {
                return a2.length;
            }

            @Override
            public void addDouble(int index, double v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double getDouble(int index) {
                if (index < 0 || index >= a2.length) {
                    throw new IndexOutOfBoundsException();
                }
                return a2[index];
            }

            @Override
            public double removeAt(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double setDouble(int index, double v) {
                if (index < 0 || index >= a2.length) {
                    throw new IndexOutOfBoundsException();
                }
                double r = a2[index];
                a2[index] = v;
                return r;
            }

            @Override
            public void clear() {
                throw new IndexOutOfBoundsException();
            }
        };
    }
}

