/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io.filter;

import java.io.File;
import java.io.FileFilter;

public class PermissionFileFilter
implements FileFilter {
    private String relop;
    private int perms;

    public PermissionFileFilter(String relop, int p) {
        this.relop = relop;
        this.perms = p;
    }

    public PermissionFileFilter(String flg) {
        this.relop = "=";
        if (flg.equals("r")) {
            this.perms = 4;
        } else if (flg.equals("w")) {
            this.perms = 2;
        } else if (flg.equals("x")) {
            this.perms = 1;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean accept(File pathname) {
        int p = 0;
        p |= (pathname.canRead() ? 1 : 0) << 2;
        p |= (pathname.canWrite() ? 1 : 0) << 1;
        p |= pathname.canExecute() ? 1 : 0;
        if (this.relop.equals("<")) {
            return (p & this.perms) != 0 && p != this.perms;
        }
        if (this.relop.equals("<=")) {
            return (p & this.perms) != 0;
        }
        if (this.relop.equals(">")) {
            return (this.perms & p) != 0 && p != this.perms;
        }
        if (this.relop.equals(">=")) {
            return (this.perms & p) != 0;
        }
        if (this.relop.equals("=")) {
            return this.perms == p;
        }
        if (this.relop.equals("!=")) {
            return this.perms != p;
        }
        throw new RuntimeException();
    }

    public String toString() {
        return "perm" + this.relop + Integer.toOctalString(this.perms);
    }
}

