/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io;

import java.io.IOException;
import java.io.InputStream;

public class LookaheadInputStream
extends InputStream {
    private InputStream ins;
    private int lookahead = -72;

    public LookaheadInputStream(InputStream ins) {
        this.ins = ins;
    }

    @Override
    public int read() throws IOException {
        if (this.lookahead >= 0 || this.lookahead == -72) {
            int r = this.lookahead;
            this.lookahead = this.ins.read();
            return r;
        }
        return this.lookahead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.lookahead == -72) {
            int r = this.ins.read(b, off, len);
            if (r < 0) {
                this.lookahead = -1;
                return -1;
            }
            this.lookahead = this.ins.read();
            return r;
        }
        if (this.lookahead < 0) {
            return -1;
        }
        int r = this.ins.read(b, off + 1, len - 1);
        if (r > 0) {
            b[off] = (byte)this.lookahead;
            this.lookahead = this.ins.read();
            return r + 1;
        }
        if (r == 0) {
            return 0;
        }
        b[off] = (byte)this.lookahead;
        this.lookahead = r;
        return 1;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.lookahead == -72) {
            long r = this.ins.skip(n);
            if (r < 0L) {
                this.lookahead = -1;
                return -1;
            }
            this.lookahead = this.ins.read();
            return r;
        }
        if (this.lookahead < 0) {
            return 0L;
        }
        long r = this.ins.skip(n - 1L);
        if (r > 0L) {
            this.lookahead = this.ins.read();
            return r + 1L;
        }
        this.lookahead = -1;
        return 1L;
    }

    @Override
    public int available() throws IOException {
        return this.ins.available();
    }

    @Override
    public void close() throws IOException {
        this.ins.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public int lookahead() throws IOException {
        if (this.lookahead == -72) {
            this.lookahead = this.ins.read();
        }
        return this.lookahead;
    }
}

