/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.util.io.FileAttributeFinder;
import net.morilib.util.io.filter.AndFileFilter;
import net.morilib.util.io.filter.WildcardFileFilter;

public final class DirectoryGlobber {
    private static final Pattern COMPPTN = Pattern.compile("^(.*?)(<.*>)?$");

    private static String[] compile(String pattern) {
        if (pattern.matches("/+$")) {
            throw new IllegalArgumentException();
        }
        String[] r = pattern.split("/+");
        int i = 0;
        while (i < r.length) {
            if (r[i].equals("**")) {
                r[i] = null;
            }
            ++i;
        }
        return r;
    }

    private static FileFilter[] compfilt(String[] ptn) {
        FileFilter[] r = new FileFilter[ptn.length];
        int i = 0;
        while (i < ptn.length) {
            if (ptn[i] == null) {
                r[i] = null;
            } else {
                Matcher mt = COMPPTN.matcher(ptn[i]);
                if (!mt.matches()) {
                    throw new RuntimeException();
                }
                WildcardFileFilter f1 = new WildcardFileFilter(mt.group(1));
                String x = mt.group(2);
                if (x == null) {
                    r[i] = f1;
                } else {
                    x = x.substring(1, x.length() - 1);
                    r[i] = new AndFileFilter(f1, FileAttributeFinder.compile(x));
                }
            }
            ++i;
        }
        return r;
    }

    private static void glob1(Set<File> r, File file, FileFilter[] ptn, int ptr) {
        if (ptr >= ptn.length) {
            return;
        }
        DirectoryIterator itr = new DirectoryIterator(file);
        while (itr.hasNext()) {
            File f = (File)itr.next();
            if (ptn[ptr] == null) {
                if (f.isDirectory()) {
                    DirectoryGlobber.glob1(r, f, ptn, ptr);
                }
                DirectoryGlobber.glob1(r, file, ptn, ptr + 1);
                continue;
            }
            if (!ptn[ptr].accept(f)) continue;
            if (f.isDirectory()) {
                DirectoryGlobber.glob1(r, f, ptn, ptr + 1);
                continue;
            }
            if (ptr + 1 != ptn.length) continue;
            r.add(f);
        }
    }

    public static File[] glob(File f, String pattern) {
        HashSet<File> r = new HashSet<File>();
        DirectoryGlobber.glob1(r, f, DirectoryGlobber.compfilt(DirectoryGlobber.compile(pattern)), 0);
        return r.toArray(new File[0]);
    }

    public static File[] glob(String pattern) {
        String[] p = DirectoryGlobber.compile(pattern);
        HashSet<File> r = new HashSet<File>();
        if (p.length > 0 && p[0].isEmpty()) {
            DirectoryGlobber.glob1(r, new File("/"), DirectoryGlobber.compfilt(p), 1);
        } else {
            DirectoryGlobber.glob1(r, new File("."), DirectoryGlobber.compfilt(p), 0);
        }
        return r.toArray(new File[0]);
    }

    static class DirectoryIterator
    implements Iterator<File> {
        private File[] files;
        private int ptr = 0;

        public DirectoryIterator(File file) {
            this.files = file.listFiles();
        }

        @Override
        public boolean hasNext() {
            return this.files != null && this.ptr < this.files.length;
        }

        @Override
        public File next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.files[this.ptr++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

