/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.morilib.util.codec.ASCIIFilter;
import net.morilib.util.codec.DecodeException;
import net.morilib.util.codec.Decoder;
import net.morilib.util.codec.Encoder;

public class QuotedPrintable
implements Encoder,
Decoder {
    public static final QuotedPrintable STANDARD = new QuotedPrintable(61, false, null);
    public static final QuotedPrintable STANDARD_NEWLINE = new QuotedPrintable(61, true, null);
    private int metachar;
    private boolean newline;
    private ASCIIFilter asciiexcept;

    public QuotedPrintable(int metachar, boolean newline, ASCIIFilter asciiexcept) {
        this.metachar = metachar;
        this.newline = newline;
        this.asciiexcept = asciiexcept == null ? ASCIIFilter.NULL : asciiexcept;
    }

    private boolean _except(int c) {
        return c == this.metachar || this.asciiexcept.test((byte)c);
    }

    private int _hexe(int n) {
        if (n < 0) {
            throw new RuntimeException();
        }
        if (n < 10) {
            return n + 48;
        }
        if (n < 16) {
            return n + 65;
        }
        throw new RuntimeException();
    }

    private int _hexd(int n) throws DecodeException {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 65 && n <= 70) {
            return n - 65;
        }
        throw new DecodeException();
    }

    private void _crlf(OutputStream ous) throws IOException {
        ous.write(this.metachar);
        ous.write(this._hexe(0));
        ous.write(this._hexe(13));
        ous.write(this.metachar);
        ous.write(this._hexe(0));
        ous.write(this._hexe(10));
    }

    private void _putc(OutputStream ous, int c) throws IOException {
        if (c < 33 || c > 126 || this._except(c)) {
            ous.write(this.metachar);
            ous.write(this._hexe(c >> 4));
            ous.write(this._hexe(c & 0xF));
        } else {
            ous.write(c);
        }
    }

    @Override
    public void encode(OutputStream ous, InputStream ins) throws IOException {
        int c;
        int state = 0;
        while ((c = ins.read()) >= 0) {
            switch (state) {
                case 0: {
                    if (this.newline && c == 13) {
                        state = 1;
                        break;
                    }
                    if (this.newline && c == 10) {
                        this._crlf(ous);
                        break;
                    }
                    this._putc(ous, c);
                    break;
                }
                case 1: {
                    if (c == 10) {
                        this._crlf(ous);
                    } else {
                        this._putc(ous, 13);
                        this._putc(ous, c);
                    }
                    state = 0;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    @Override
    public String encode(byte[] a) {
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        ByteArrayInputStream ins = new ByteArrayInputStream(a);
        try {
            this.encode(ous, ins);
            return new String(ous.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void decode(OutputStream ous, InputStream ins) throws IOException, DecodeException {
        int c;
        int state = 0;
        int d = 0;
        block4: while ((c = ins.read()) >= 0) {
            switch (state) {
                case 0: {
                    if (c == this.metachar) {
                        d = 0;
                        state = 1;
                        break;
                    }
                    ous.write(c);
                    break;
                }
                case 1: 
                case 2: {
                    d = (d << 4) + this._hexd(c);
                    if (++state != 3) continue block4;
                    ous.write(d);
                    state = 0;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    @Override
    public byte[] decode(String s) throws DecodeException {
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        ByteArrayInputStream ins = new ByteArrayInputStream(s.getBytes());
        try {
            this.decode(ous, ins);
            return ous.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

