/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.morilib.util.Objects;
import net.morilib.util.Section;
import net.morilib.util.SimpleMap;
import net.morilib.util.Tuple2;

public final class TreeSectionMap<T extends Comparable<T> & Section<K>, K, V>
implements SimpleMap<K, V> {
    private TreeSectionMap<T, K, V> left;
    private TreeSectionMap<T, K, V> right;
    private TreeSectionMap<T, K, V> root;
    private T key;
    private V value;
    private int height = 0;
    private final ItrbK ITR_K = new ItrbK();
    private final ItrbE ITR_E = new ItrbE();

    public TreeSectionMap(T key, V val) {
        this.key = key;
        this.value = val;
        this.root = null;
    }

    private TreeSectionMap(T key, TreeSectionMap<T, K, V> root, V val) {
        this.key = key;
        this.value = val;
        this.root = root;
    }

    private static <T extends Comparable<T> & Section<K>, K, V> TreeSectionMap<T, K, V> _find0(K o, TreeSectionMap<T, K, V> e) {
        if (e == null) {
            return null;
        }
        int cm = ((Section)e.key).side(o);
        if (cm > 0) {
            return TreeSectionMap._find0(o, e.right);
        }
        if (cm < 0) {
            return TreeSectionMap._find0(o, e.left);
        }
        return e;
    }

    private static <T extends Comparable<T> & Section<K>, K, V> TreeSectionMap<T, K, V> _find1(T o, TreeSectionMap<T, K, V> e) {
        if (e == null) {
            return null;
        }
        int cm = e.key.compareTo(o);
        if (cm > 0) {
            return TreeSectionMap._find1(o, e.right);
        }
        if (cm < 0) {
            return TreeSectionMap._find1(o, e.left);
        }
        return e;
    }

    private void rotateLeft() {
        if (this.left == null) {
            T tmp = this.right.key;
            TreeSectionMap<T, K, V> tt = this.right;
            this.right = this.right.right;
            tt.key = this.key;
            tt.right = tt.left;
            this.key = tmp;
            this.left = tt;
        } else {
            T tmp = this.left.key;
            this.left.key = this.key;
            this.key = tmp;
            TreeSectionMap<T, K, V> tt = this.left.left;
            this.left.left = this.left.right;
            this.left.right = this.right;
            this.right = this.left;
            this.left = tt;
        }
        this.height -= 2;
    }

    private void rotateRight() {
        if (this.right == null) {
            T tmp = this.left.key;
            TreeSectionMap<T, K, V> tt = this.left;
            this.left = this.left.left;
            tt.key = this.key;
            tt.left = tt.right;
            this.key = tmp;
            this.right = tt;
        } else {
            T tmp = this.right.key;
            this.right.key = this.key;
            this.key = tmp;
            TreeSectionMap<T, K, V> tt = this.right.right;
            this.right.right = this.right.left;
            this.right.left = this.left;
            this.left = this.right;
            this.right = tt;
        }
        this.height += 2;
    }

    private void doubleRotateLeft() {
        super.rotateRight();
        this.rotateLeft();
    }

    private void doubleRotateRight() {
        super.rotateLeft();
        this.rotateRight();
    }

    /*
     * Unable to fully structure code
     */
    private static <T extends Comparable<T> & Section<K>, K, V> TreeSectionMap<T, K, V> first(TreeSectionMap<T, K, V> r) {
        l = r;
        if (l != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            l = l.left;
lbl5:
            // 2 sources

            ** while (l.left != null)
        }
lbl6:
        // 1 sources

        return l;
    }

    private static int abs(int x) {
        return x < 0 ? -x : x;
    }

    private static <T extends Comparable<T> & Section<K>, K, V> T _add1(T o, TreeSectionMap<T, K, V> e, V val) {
        int hr;
        T res;
        int cm = e.key.compareTo(o);
        if (cm > 0) {
            if (e.left == null) {
                e.left = new TreeSectionMap<T, K, V>(o, e, val);
                --e.height;
                res = null;
            } else {
                res = TreeSectionMap._add1(o, e.left, val);
            }
        } else if (cm < 0) {
            if (e.right == null) {
                e.right = new TreeSectionMap<T, K, V>(o, e, val);
                ++e.height;
                res = null;
            } else {
                res = TreeSectionMap._add1(o, e.right, val);
            }
        } else {
            e.value = val;
            return e.key;
        }
        int hl = e.left == null ? 0 : e.left.height;
        int n = hr = e.right == null ? 0 : e.right.height;
        if (TreeSectionMap.abs(hr) + TreeSectionMap.abs(hl) >= 2) {
            if (hr > 0) {
                super.rotateLeft();
            } else if (hr < 0) {
                super.doubleRotateLeft();
            }
        } else if (TreeSectionMap.abs(hl) + TreeSectionMap.abs(hr) <= 2) {
            if (hl < 0) {
                super.rotateRight();
            } else if (hl > 0) {
                super.doubleRotateRight();
            }
        }
        return res;
    }

    public T find(T o) {
        TreeSectionMap<T, K, V> res = TreeSectionMap._find1(o, this);
        return res == null ? null : (T)res.key;
    }

    public void delete(T o) {
        throw new UnsupportedOperationException();
    }

    public void insert(T o, V val) {
        TreeSectionMap._add1(o, this, val);
    }

    public Iterable<T> keys() {
        return this.ITR_K;
    }

    public Iterable<Tuple2<T, V>> entries() {
        return this.ITR_E;
    }

    @Override
    public V map(K key) {
        TreeSectionMap<T, K, V> res = TreeSectionMap._find0(key, this);
        return res == null ? null : (V)res.value;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String dlm = "";
        buf.append("{");
        for (Tuple2 k : this.ITR_E) {
            buf.append(dlm);
            buf.append(Objects.toString(k.getA()));
            buf.append("=");
            buf.append(Objects.toString(k.getB()));
            dlm = ",";
        }
        buf.append("}");
        return buf.toString();
    }

    private static class Itr<T extends Comparable<T> & Section<K>, K, V>
    implements Iterator<T> {
        private TreeSectionMap<T, K, V> next;

        private Itr(TreeSectionMap<T, K, V> ptr) {
            this.next = TreeSectionMap.first((TreeSectionMap)ptr);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            Comparable res = ((TreeSectionMap)this.next).key;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (((TreeSectionMap)this.next).right != null) {
                this.next = TreeSectionMap.first(((TreeSectionMap)this.next).right);
            } else {
                TreeSectionMap<T, K, V> t = this.next;
                this.next = ((TreeSectionMap)this.next).root;
                while (this.next != null && t == ((TreeSectionMap)this.next).right) {
                    t = this.next;
                    this.next = ((TreeSectionMap)this.next).root;
                }
            }
            return (T)res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ItrE<T extends Comparable<T> & Section<K>, K, V>
    implements Iterator<Tuple2<T, V>> {
        private TreeSectionMap<T, K, V> next;

        private ItrE(TreeSectionMap<T, K, V> ptr) {
            this.next = TreeSectionMap.first((TreeSectionMap)ptr);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Tuple2<T, V> next() {
            Comparable res = ((TreeSectionMap)this.next).key;
            Object rev = ((TreeSectionMap)this.next).value;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (((TreeSectionMap)this.next).right != null) {
                this.next = TreeSectionMap.first(((TreeSectionMap)this.next).right);
            } else {
                TreeSectionMap<T, K, V> t = this.next;
                this.next = ((TreeSectionMap)this.next).root;
                while (this.next != null && t == ((TreeSectionMap)this.next).right) {
                    t = this.next;
                    this.next = ((TreeSectionMap)this.next).root;
                }
            }
            return new Tuple2<Comparable, Object>(res, rev);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ItrbE
    implements Iterable<Tuple2<T, V>> {
        private ItrbE() {
        }

        @Override
        public Iterator<Tuple2<T, V>> iterator() {
            return new ItrE(TreeSectionMap.this);
        }
    }

    private class ItrbK
    implements Iterable<T> {
        private ItrbK() {
        }

        @Override
        public Iterator<T> iterator() {
            return new Itr(TreeSectionMap.this);
        }
    }
}

