/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

import java.math.BigInteger;

public final class Endianness2 {
    private boolean bigEndian;
    public static final Endianness2 BIG = new Endianness2(true);
    public static final Endianness2 LITTLE = new Endianness2(false);

    private Endianness2(boolean b) {
        this.bigEndian = b;
    }

    private int indexTo(int i, int len) {
        return this.bigEndian ? i : len - i - 1;
    }

    private int indexTo2(int i, int len) {
        return !this.bigEndian ? i : len - i - 1;
    }

    public void write(byte[] b, int off, int len, long val) {
        long v2 = val;
        if (len <= 0 || len > 8) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < len) {
            b[off + this.indexTo2((int)i, (int)len)] = (byte)(v2 & 0xFFL);
            v2 >>= 8;
            ++i;
        }
    }

    public void write(byte[] b, int off, int len, BigInteger val) {
        BigInteger v2 = val;
        if (len <= 0) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < len) {
            b[off + this.indexTo2((int)i, (int)len)] = v2.byteValue();
            v2 = v2.shiftRight(8);
            ++i;
        }
    }

    public long readu(byte[] b, int off, int len) {
        long val = 0L;
        if (len <= 0 || len > 8) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < len) {
            val <<= 8;
            val |= (long)b[off + this.indexTo(i, len)] & 0xFFL;
            ++i;
        }
        return val;
    }

    public BigInteger readuBig(byte[] b, int off, int len) {
        BigInteger val = BigInteger.ZERO;
        if (len <= 0) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < len) {
            val = val.shiftLeft(8);
            val = val.or(BigInteger.valueOf(b[off + this.indexTo(i, len)] & 0xFF));
            ++i;
        }
        return val;
    }

    public long read(byte[] b, int off, int len) {
        long val = this.readu(b, off, len);
        if ((val & 1L << (len << 3) - 1) != 0L) {
            int i = len << 3;
            while (i < 64) {
                val |= 255L << i;
                i += 8;
            }
        }
        return val;
    }

    public BigInteger readBig(byte[] b, int off, int len) {
        BigInteger val = BigInteger.ZERO;
        if (len <= 0) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < len) {
            byte w = b[off + this.indexTo(i, len)];
            int v = w & 0xFF;
            if (i == 0) {
                val = BigInteger.valueOf(w);
            } else {
                val = val.shiftLeft(8);
                val = val.or(BigInteger.valueOf(v));
            }
            ++i;
        }
        return val;
    }
}

