/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.syslog;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public class SyslogHeader {
    private static final Pattern PTN1 = Pattern.compile("[a-zA-Z]([\\-a-zA-Z0-9]*[a-zA-Z0-9])?");
    private static final Pattern PTN2 = Pattern.compile("([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])");
    private static final Pattern PTN3 = Pattern.compile("(([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}::[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}::([0-9A-Fa-f]{1,4}:){0,1}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}::([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}::([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}::([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){0,7}::)|(::([fF]{4}:)?([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]))");
    private static final SimpleDateFormat FMT1 = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.US);
    private Date timestamp;
    private String hostname;

    public SyslogHeader(Date timestamp, String hostname) {
        if (timestamp == null || hostname == null) {
            throw new NullPointerException();
        }
        this.timestamp = timestamp;
        this.hostname = hostname;
    }

    public boolean isValidHostname() {
        return PTN1.matcher(this.hostname).matches() || PTN2.matcher(this.hostname).matches() || PTN3.matcher(this.hostname).matches();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String toSyslog() {
        StringBuilder d = new StringBuilder(FMT1.format(this.timestamp));
        if (d.charAt(4) == '0') {
            d.setCharAt(4, ' ');
        }
        d.append(' ').append(this.hostname);
        return d.toString();
    }
}

