/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.stat.dist.continuous;

import net.morilib.math.special.BetaFunction;
import net.morilib.math.special.Gamma2;
import net.morilib.math.stat.dist.AbstractContinuousDistribution;

public class TDistribution
extends AbstractContinuousDistribution {
    double nu;
    private final double lngammaNu1;
    private final double lngammaNu;
    private final double lnSqrtNuPi;

    public TDistribution(double nu) {
        if (nu <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.nu = nu;
        this.lngammaNu1 = Gamma2.lnGamma((nu + 1.0) / 2.0);
        this.lngammaNu = Gamma2.lnGamma(nu / 2.0);
        this.lnSqrtNuPi = Math.log(nu * Math.PI) / 2.0;
    }

    public double getNu() {
        return this.nu;
    }

    @Override
    public double f(double x) {
        return Math.exp(this.lngammaNu1 - this.lnSqrtNuPi - this.lngammaNu - (this.nu + 1.0) / 2.0 * Math.log(1.0 + x * x / this.nu));
    }

    @Override
    public double cdf(double x) {
        double tau = this.nu / (x * x + this.nu);
        double r0 = 1.0 - BetaFunction.I(tau, this.nu / 2.0, 0.5) / 2.0;
        return x < 0.0 ? 1.0 - r0 : r0;
    }

    @Override
    public boolean isInSupport(double n) {
        return true;
    }

    @Override
    public double supportSupremum() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double supportInfimum() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double expectedValue() {
        return 0.0;
    }

    @Override
    public double variance() {
        if (this.nu <= 1.0) {
            return Double.NaN;
        }
        if (this.nu <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return (this.nu - 2.0) / this.nu;
    }

    @Override
    public double mode() {
        return 0.0;
    }

    @Override
    public double median() {
        return 0.0;
    }

    @Override
    public double skewness() {
        return 0.0;
    }

    @Override
    public double kurtosis() {
        return this.nu > 4.0 ? 6.0 / (this.nu - 4.0) : Double.NaN;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + (int)Double.doubleToLongBits(this.nu));
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof TDistribution) {
            TDistribution n = (TDistribution)o;
            return this.nu == n.nu;
        }
        return false;
    }
}

