/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.stat.dist;

import net.morilib.lang.transform.DoubleTransform;
import net.morilib.math.analysis.inexact.MonotonicFunctions;
import net.morilib.math.stat.dist.ContinuousDistribution;

public abstract class AbstractContinuousDistribution
implements ContinuousDistribution {
    public final DoubleTransform cumulative = new DoubleTransform(){

        @Override
        public double f(double x) {
            return AbstractContinuousDistribution.this.cdf(x);
        }
    };

    @Override
    public double cdf(double x1, double x2) {
        return this.cdf(x2) - this.cdf(x1);
    }

    @Override
    public double invCdf(double p) {
        if (p == 1.0) {
            return this.supportSupremum();
        }
        if (p == 0.0) {
            return this.supportInfimum();
        }
        if (0.0 < p && p < 1.0) {
            return MonotonicFunctions.findRootByBisectionMethod(this.cumulative, p, this.supportInfimum(), this.supportSupremum());
        }
        return Double.NaN;
    }

    @Override
    public double median() {
        return this.invCdf(0.5);
    }
}

