/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.order;

import java.util.Set;
import java.util.TreeSet;
import net.morilib.math.order.ExponentialOrder;
import net.morilib.math.order.LogarithmicOrder;
import net.morilib.math.order.OrderElement;
import net.morilib.math.order.PolynomialOrder;

public class FactorialOrder
extends OrderElement {
    private int order;

    FactorialOrder(int n) {
        this.order = n;
    }

    @Override
    public int level() {
        return 91;
    }

    @Override
    public OrderElement multiply(OrderElement o) {
        return this.compareTo(o) < 0 ? o : this;
    }

    @Override
    public Set<OrderElement> log() {
        TreeSet<OrderElement> r = new TreeSet<OrderElement>();
        r.add(new PolynomialOrder(1));
        r.add(new LogarithmicOrder(1, 1));
        return r;
    }

    @Override
    public int compareLevel(OrderElement b) {
        return this.compareTo(b);
    }

    @Override
    public int compareTo(OrderElement o) {
        if (this.level() < o.level()) {
            return -1;
        }
        if (this.level() > o.level()) {
            return 1;
        }
        if (this.order < ((ExponentialOrder)o).order) {
            return -1;
        }
        if (this.order > ((ExponentialOrder)o).order) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isConstant() {
        return this.order == 0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.order == 0) {
            return "1";
        }
        if (this.order != 1) {
            b.append("(n!)^").append(this.order);
        } else {
            b.append("n!");
        }
        return b.toString();
    }
}

