/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.tokenize;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.legacy.DFABuilder;
import net.morilib.automata.nfa.NFABuildException;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.InputPort;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.tokenize.ILispTokenizer;
import net.morilib.util.Tuple2;
import net.morilib.util.tape.CharTape;
import net.morilib.util.tape.MarkableReadOnlyCharTape;
import net.morilib.util.tape.StringTape;

public class LispRegexpTokenizePattern
extends Datum2 {
    private DFA<Integer, Integer, Tuple2<Integer, Integer>> dfa;
    private List<Datum> rllist;

    private LispRegexpTokenizePattern(DFA<Integer, Integer, Tuple2<Integer, Integer>> dfa, List<Datum> rl) {
        this.dfa = dfa;
        this.rllist = rl;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<regexp-tokenize-pattern>");
    }

    /* synthetic */ LispRegexpTokenizePattern(DFA dFA, List list, LispRegexpTokenizePattern lispRegexpTokenizePattern) {
        this(dFA, list);
    }

    static class LispRegexpTokenizer
    extends Datum2
    implements ILispTokenizer {
        private LispRegexpTokenizePattern pat;
        private CharTape tape;

        LispRegexpTokenizer(LispRegexpTokenizePattern pat, CharTape tape) {
            this.pat = pat;
            this.tape = tape;
        }

        @Override
        public Datum tokenize(LispMessage mesg) {
            int c;
            TreeSet acc = new TreeSet();
            StringBuilder b = new StringBuilder();
            int pt = this.tape.mark();
            if (this.tape.readc() < 0) {
                return MultiValues.newValues(LispBoolean.FALSE, LispBoolean.FALSE);
            }
            DFAState stat = this.pat.dfa.getInitialState();
            while ((c = this.tape.readc()) >= 0) {
                b.append((char)c);
                stat = stat.goInt(c);
                if (!stat.getAccepted().isEmpty()) {
                    this.tape.mark();
                    acc.clear();
                    acc.addAll(stat.getAccepted());
                } else if (stat.isDead()) {
                    if (!acc.isEmpty()) {
                        int s = (Integer)acc.first();
                        acc.clear();
                        b.delete(b.length() - pt + this.tape.back(), b.length());
                        this.tape.moveRight();
                        return MultiValues.newValues((Datum)this.pat.rllist.get(s), new LispString(b.toString()));
                    }
                    throw mesg.getError("err.tokenize.invalidtoken");
                }
                ++pt;
                this.tape.moveRight();
            }
            if (!acc.isEmpty()) {
                int s = (Integer)acc.first();
                b.delete(b.length() - pt + this.tape.back() + 1, b.length());
                this.tape.moveRight();
                return MultiValues.newValues((Datum)this.pat.rllist.get(s), new LispString(b.toString()));
            }
            throw mesg.getError("err.tokenize.invalidtoken");
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<regexp-tokenizer>");
        }
    }

    public static class MakeRegexpTokenizePattern
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(c1a);
            ArrayList<Datum> rl = new ArrayList<Datum>();
            ArrayList<String> rexs = new ArrayList<String>();
            while (itr.hasNext()) {
                Datum d = itr.next();
                if (!(d instanceof Cons)) continue;
                Cons c = (Cons)d;
                String re = SubrUtils.getString(c.getCar(), mesg);
                rexs.add(re);
                rl.add(c.getCdr());
            }
            if (!itr.getTerminal().isNil()) {
                throw mesg.getError("err.list", c1a);
            }
            try {
                DFA<Integer, Integer, Tuple2<Integer, Integer>> dfa = DFABuilder.getInstance().buildCombined(rexs.toArray(new String[0]));
                return new LispRegexpTokenizePattern(dfa, rl, null);
            }
            catch (NFABuildException e) {
                throw mesg.getError("err.tokenize.invalidregexp", e.getMessage());
            }
        }
    }

    public static class MakeRegexpTokenizerPort
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c2a instanceof InputPort)) {
                throw mesg.getError("err.require.iport", c2a);
            }
            if (c1a instanceof LispRegexpTokenizePattern) {
                return new LispRegexpTokenizer((LispRegexpTokenizePattern)c1a, new MarkableReadOnlyCharTape((InputPort)c2a));
            }
            throw mesg.getError("err.tokenize.require.regexp", c1a);
        }
    }

    public static class MakeRegexpTokenizerString
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispRegexpTokenizePattern) {
                String str = SubrUtils.getString(c2a, mesg);
                return new LispRegexpTokenizer((LispRegexpTokenizePattern)c1a, new StringTape(str));
            }
            throw mesg.getError("err.tokenize.require.regexp", c1a);
        }
    }
}

