/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing.table;

import net.morilib.lisp.Datum;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Undef;
import net.morilib.lisp.swing.table.AbstractLispTableModel;

public class LispVectorTableModel
extends AbstractLispTableModel {
    private LispVector table;
    private LispVector columnNames;
    private final int column;

    public LispVectorTableModel(LispVector table) {
        this.table = table;
        this.column = this.checkVector(table);
        this.columnNames = null;
    }

    public LispVectorTableModel(LispVector table, LispVector columnNames) {
        this.table = table;
        this.column = this.checkVector(table);
        if (columnNames.size() != this.column) {
            throw new IllegalArgumentException();
        }
        this.columnNames = columnNames;
    }

    private int checkVector(LispVector table) {
        int c = -1;
        int i = 0;
        while (i < table.size()) {
            if (!(table.get(i) instanceof LispVector)) {
                throw new IllegalArgumentException();
            }
            LispVector v = (LispVector)table.get(i);
            c = Math.max(c, v.size());
            ++i;
        }
        return c;
    }

    @Override
    public int getRowCount() {
        return this.table.size();
    }

    @Override
    public int getColumnCount() {
        return this.column;
    }

    @Override
    public int getColumnCount1(int rowIndex) {
        return ((LispVector)this.table.get(rowIndex)).size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Datum getValueAt(int r, int c) {
        LispVector v = (LispVector)this.table.get(r);
        return c < v.size() ? v.get(c) : Undef.UNDEF;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getColumnName(int c) {
        if (this.columnNames == null) {
            return Integer.toString(c + 1);
        }
        return LispUtils.print(this.columnNames.get(c));
    }
}

