/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing.event;

import java.awt.event.MouseEvent;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.UnaryArgs;

public class LispMouseEvent
extends Datum2 {
    private MouseEvent event;

    public LispMouseEvent(MouseEvent e) {
        this.event = e;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<mouse-event>");
    }

    public static class GetMouseButton
    extends MouseSubr {
        @Override
        protected Datum execute(MouseEvent e) {
            switch (e.getButton()) {
                case 0: {
                    return Symbol.getSymbol("no-button");
                }
                case 1: {
                    return Symbol.getSymbol("button1");
                }
                case 2: {
                    return Symbol.getSymbol("button2");
                }
                case 3: {
                    return Symbol.getSymbol("button3");
                }
            }
            return Symbol.getSymbol("unknown-button");
        }
    }

    public static class GetMouseClickCount
    extends MouseSubr {
        @Override
        protected Datum execute(MouseEvent e) {
            return LispInteger.valueOf(e.getClickCount());
        }
    }

    public static class GetMouseX
    extends MouseSubr {
        @Override
        protected Datum execute(MouseEvent e) {
            return LispInteger.valueOf(e.getX());
        }
    }

    public static class GetMouseXEtY
    extends MouseSubr {
        @Override
        protected Datum execute(MouseEvent e) {
            return MultiValues.newValues(LispInteger.valueOf(e.getX()), LispInteger.valueOf(e.getY()));
        }
    }

    public static class GetMouseXEtYOnScreen
    extends MouseSubr {
        @Override
        protected Datum execute(MouseEvent e) {
            return MultiValues.newValues(LispInteger.valueOf(e.getXOnScreen()), LispInteger.valueOf(e.getYOnScreen()));
        }
    }

    public static class GetMouseXOnScreen
    extends MouseSubr {
        @Override
        protected Datum execute(MouseEvent e) {
            return LispInteger.valueOf(e.getXOnScreen());
        }
    }

    public static class GetMouseY
    extends MouseSubr {
        @Override
        protected Datum execute(MouseEvent e) {
            return LispInteger.valueOf(e.getY());
        }
    }

    public static class GetMouseYOnScreen
    extends MouseSubr {
        @Override
        protected Datum execute(MouseEvent e) {
            return LispInteger.valueOf(e.getYOnScreen());
        }
    }

    public static class IsPopupTrigger
    extends MouseSubr {
        @Override
        protected Datum execute(MouseEvent e) {
            return LispBoolean.getInstance(e.isPopupTrigger());
        }
    }

    public static abstract class MouseSubr
    extends UnaryArgs {
        protected abstract Datum execute(MouseEvent var1);

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispMouseEvent) {
                return this.execute(((LispMouseEvent)c1a).event);
            }
            throw mesg.getError("err.swing.require.event.mouse", c1a);
        }
    }
}

