/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.Keyword;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Parser;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.painter.SchlushColor;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.ILispIcon;
import net.morilib.lisp.swing.Selectable;
import net.morilib.lisp.swing.event.LispActionEvent;
import net.morilib.lisp.swing.event.LispAdjustmentEvent;
import net.morilib.lisp.swing.event.LispChangeEvent;
import net.morilib.lisp.swing.event.LispItemEvent;
import net.morilib.lisp.swing.event.LispMouseEvent;
import net.morilib.lisp.swing.event.LispWindowEvent;
import net.morilib.util.mapset.HashOneToOneSet;
import net.morilib.util.mapset.OneToOneSet;

public final class LispSwing {
    private static final Symbol VERTICAL = Symbol.getSymbol("vertical");
    private static final Symbol HORIZONTAL = Symbol.getSymbol("horizontal");
    private static final Symbol UNKNOWN = Symbol.getSymbol("unknown");
    private static final OneToOneSet<Datum, Integer> _KEYS;
    private static final OneToOneSet<Datum, Integer> _MODS;

    static {
        _MODS = new HashOneToOneSet<Datum, Integer>({Symbol.getSymbol("shift"), 1}, {Symbol.getSymbol("ctrl"), 2}, {Symbol.getSymbol("meta"), 4}, {Symbol.getSymbol("alt"), 8});
        InputStream ins = null;
        _KEYS = new HashOneToOneSet<Datum, Integer>();
        try {
            try {
                ins = LispSwing.class.getResourceAsStream("keyboard.s");
                List<Datum> l = Parser.readSExpression(new InputStreamReader(ins, "UTF-8"));
                ConsIterator itr = new ConsIterator(l.get(0));
                while (itr.hasNext()) {
                    Cons c = (Cons)itr.next();
                    _KEYS.put(c.getCar(), c.getCdr().getInt());
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private LispSwing() {
    }

    static Selectable.Item[] toItem(Datum data) {
        ConsIterator it = new ConsIterator(data);
        ArrayList<Selectable.Item> l = new ArrayList<Selectable.Item>();
        while (it.hasNext()) {
            Datum d = it.next();
            if (d instanceof Cons) {
                l.add(new Selectable.Item(((Cons)d).getCdr(), ((Cons)d).getCar()));
                continue;
            }
            l.add(new Selectable.Item(d));
        }
        if (!it.getTerminal().equals(Nil.NIL)) {
            return null;
        }
        return l.toArray(new Selectable.Item[0]);
    }

    static int toKeyEvent(Datum key, LispMessage mesg) {
        if (!_KEYS.containsKey(key)) {
            throw mesg.getError("err.swing.invalidkeytype", key);
        }
        return (Integer)_KEYS.getValue(key);
    }

    static KeyStroke toKeyStroke(Datum key, Datum mod, LispMessage mesg) {
        int m = 0;
        if (mod instanceof Cons) {
            ConsIterator itr = new ConsIterator(mod);
            while (itr.hasNext()) {
                Datum d = itr.next();
                Integer i = (Integer)_MODS.getValue(d);
                if (i == null) {
                    throw mesg.getError("err.swing.invalidkeymodifier", d);
                }
                m |= i.intValue();
            }
            if (!itr.getTerminal().isNil()) {
                throw mesg.getError("err.list", mod);
            }
        } else {
            if (mod.isTrue()) {
                throw mesg.getError("err.swing.invalidkeymodifier", mod);
            }
            if (!_KEYS.containsKey(key)) {
                throw mesg.getError("err.swing.invalidkeytype", key);
            }
        }
        return KeyStroke.getKeyStroke((Integer)_KEYS.getValue(key), m);
    }

    public static int toKeyCode(Datum key, LispMessage mesg) {
        if (!_KEYS.containsKey(key)) {
            throw mesg.getError("err.swing.invalidkeytype", key);
        }
        return (Integer)_KEYS.getValue(key);
    }

    private static Datum call(Datum p, Datum e, Scheme sch, Environment ev, LispMessage m) {
        if (p == null || !p.isTrue() || p.isNil()) {
            return Undef.UNDEF;
        }
        if (p instanceof Subr) {
            return ((Subr)p).eval(LispUtils.list(e), ev, m);
        }
        if (p instanceof Procedure) {
            return sch.call(p, e);
        }
        throw m.getError("err.require.procedure", p);
    }

    public static ActionListener createActionListener(Datum proc, Environment env, LispMessage mesg) {
        final Datum p = proc;
        if (p instanceof Subr) {
            final Environment ev = env;
            final LispMessage m = mesg;
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Subr)p).eval(LispUtils.list(new LispActionEvent(e)), ev, m);
                }
            };
        }
        if (p instanceof Procedure) {
            final Scheme sch = new Scheme(env, mesg);
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    sch.call(p, new LispActionEvent(e));
                }
            };
        }
        throw mesg.getError("err.require.procedure", proc);
    }

    public static MouseListener createMouseListener(Datum d, Datum body, Environment env, LispMessage mesg) {
        final Map<Keyword, Datum> mp = SubrUtils.keywordArgsToMap(d, body, mesg);
        final Environment ev = env;
        final LispMessage m = mesg;
        final Scheme sch = new Scheme(env, mesg);
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("clicked")), new LispMouseEvent(e), sch, ev, m);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("pressed")), new LispMouseEvent(e), sch, ev, m);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("released")), new LispMouseEvent(e), sch, ev, m);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("entered")), new LispMouseEvent(e), sch, ev, m);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("exited")), new LispMouseEvent(e), sch, ev, m);
            }
        };
    }

    public static MouseMotionListener createMouseMotionListener(Datum d, Datum body, Environment env, LispMessage mesg) {
        final Map<Keyword, Datum> mp = SubrUtils.keywordArgsToMap(d, body, mesg);
        final Environment ev = env;
        final LispMessage m = mesg;
        final Scheme sch = new Scheme(env, mesg);
        return new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("dragged")), new LispMouseEvent(e), sch, ev, m);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("moved")), new LispMouseEvent(e), sch, ev, m);
            }
        };
    }

    public static ItemListener createItemListener(Datum proc, Environment env, LispMessage mesg) {
        final Datum p = proc;
        final Environment ev = env;
        final LispMessage m = mesg;
        final Scheme sch = new Scheme(env, mesg);
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LispSwing.call(p, new LispItemEvent(e), sch, ev, m);
            }
        };
    }

    public static AdjustmentListener createAdjustmentListener(Datum proc, Environment env, LispMessage mesg) {
        final Datum p = proc;
        final Environment ev = env;
        final LispMessage m = mesg;
        final Scheme sch = new Scheme(env, mesg);
        return new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                LispSwing.call(p, new LispAdjustmentEvent(e), sch, ev, m);
            }
        };
    }

    public static ChangeListener createChangeListener(Datum proc, Environment env, LispMessage mesg) {
        final Datum p = proc;
        final Environment ev = env;
        final LispMessage m = mesg;
        final Scheme sch = new Scheme(env, mesg);
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LispSwing.call(p, new LispChangeEvent(e), sch, ev, m);
            }
        };
    }

    static Action createAction(Datum d, Datum body, Environment env, LispMessage mesg) {
        final Map<Keyword, Datum> mp = SubrUtils.keywordArgsToMap(d, body, mesg);
        final Environment ev = env;
        final LispMessage m = mesg;
        final Scheme sch = new Scheme(env, mesg);
        AbstractAction res = new AbstractAction(){
            private static final long serialVersionUID = -354094442585077659L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("action")), new LispActionEvent(e), sch, ev, m);
            }
        };
        for (Map.Entry<Keyword, Datum> e : mp.entrySet()) {
            String k = e.getKey().getName();
            if (k.equals("accelerator-key")) {
                List<Datum> l = LispUtils.consToList(e.getValue(), mesg);
                if (l.size() != 2) {
                    throw mesg.getError("err.swing.invalidkeystroke", e.getValue());
                }
                res.putValue("AcceleratorKey", LispSwing.toKeyStroke(l.get(0), l.get(1), mesg));
                continue;
            }
            if (k.equals("long-description")) {
                res.putValue("LongDescription", SubrUtils.getString(e.getValue(), mesg));
                continue;
            }
            if (k.equals("mnemonic-key")) {
                res.putValue("MnemonicKey", LispSwing.toKeyEvent(e.getValue(), mesg));
                continue;
            }
            if (k.equals("name")) {
                res.putValue("Name", SubrUtils.getString(e.getValue(), mesg));
                continue;
            }
            if (k.equals("short-description")) {
                res.putValue("ShortDescription", SubrUtils.getString(e.getValue(), mesg));
                continue;
            }
            if (!k.equals("small-icon")) continue;
            if (e.getValue() instanceof ILispIcon) {
                res.putValue("SmallIcon", ((ILispIcon)((Object)e.getValue())).getIcon());
                continue;
            }
            throw mesg.getError("err.swing.require.icon", e.getValue());
        }
        return res;
    }

    public static WindowListener createWindowListener(Datum d, Datum body, Environment env, LispMessage mesg) {
        final Map<Keyword, Datum> mp = SubrUtils.keywordArgsToMap(d, body, mesg);
        final Environment ev = env;
        final LispMessage m = mesg;
        final Scheme sch = new Scheme(env, mesg);
        return new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("opened")), new LispWindowEvent(e), sch, ev, m);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("closing")), new LispWindowEvent(e), sch, ev, m);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("closed")), new LispWindowEvent(e), sch, ev, m);
            }

            @Override
            public void windowIconified(WindowEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("iconified")), new LispWindowEvent(e), sch, ev, m);
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("deiconified")), new LispWindowEvent(e), sch, ev, m);
            }

            @Override
            public void windowActivated(WindowEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("activated")), new LispWindowEvent(e), sch, ev, m);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                LispSwing.call((Datum)mp.get(Keyword.getKeyword("deactivated")), new LispWindowEvent(e), sch, ev, m);
            }
        };
    }

    static AttributeSet createAttributeSet(Datum d, Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(d);
        SimpleAttributeSet a = new SimpleAttributeSet();
        while (itr.hasNext()) {
            Datum c;
            String k = SubrUtils.nextKeywordName(itr, mesg, body);
            if (k.equals("font-family")) {
                String s = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
                StyleConstants.setFontFamily(a, s);
                continue;
            }
            if (k.equals("font-size")) {
                int s = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
                StyleConstants.setFontSize(a, s);
                continue;
            }
            if (k.equals("bold")) {
                StyleConstants.setBold(a, true);
                continue;
            }
            if (k.equals("italic")) {
                StyleConstants.setItalic(a, true);
                continue;
            }
            if (k.equals("underline")) {
                StyleConstants.setUnderline(a, true);
                continue;
            }
            if (k.equals("strike")) {
                StyleConstants.setStrikeThrough(a, true);
                continue;
            }
            if (k.equals("superscript")) {
                StyleConstants.setSuperscript(a, true);
                continue;
            }
            if (k.equals("subscript")) {
                StyleConstants.setSubscript(a, true);
                continue;
            }
            if (k.equals("color")) {
                c = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
                if (c instanceof SchlushColor) {
                    StyleConstants.setForeground(a, ((SchlushColor)c).getColor());
                    continue;
                }
                throw mesg.getError("err.require.color", c);
            }
            if (!k.equals("background-color")) continue;
            c = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            if (c instanceof SchlushColor) {
                StyleConstants.setBackground(a, ((SchlushColor)c).getColor());
                continue;
            }
            throw mesg.getError("err.require.color", c);
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        return a;
    }

    public static int getOrientation(Datum d1, LispMessage mesg) {
        if (d1.equals(VERTICAL)) {
            return 1;
        }
        if (d1.equals(HORIZONTAL)) {
            return 0;
        }
        throw mesg.getError("err.swing.orientation.invalid", d1);
    }

    public static Symbol orientationSymbol(int orient) {
        switch (orient) {
            case 1: {
                return VERTICAL;
            }
            case 0: {
                return HORIZONTAL;
            }
        }
        return UNKNOWN;
    }
}

